/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.variable;

import com.atlassian.bamboo.chains.Chain;
import com.atlassian.bamboo.core.ScopedExclusionService;
import com.atlassian.bamboo.core.ScopedExclusionServiceHelper;
import com.atlassian.bamboo.plan.Plan;
import com.atlassian.bamboo.plan.PlanIdentifier;
import com.atlassian.bamboo.specs.api.model.VariableProperties;
import com.atlassian.bamboo.utils.BambooCollectors;
import com.atlassian.bamboo.variable.VariableConfigurationService;
import com.atlassian.bamboo.variable.VariableDefinition;
import com.atlassian.bamboo.variable.VariableDefinitionFactory;
import com.atlassian.bamboo.variable.VariableDefinitionManager;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import io.atlassian.util.concurrent.ManagedLock;
import io.atlassian.util.concurrent.ManagedLocks;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class VariableConfigurationServiceImpl
implements VariableConfigurationService {
    private static final Logger log = Logger.getLogger(VariableConfigurationServiceImpl.class);
    private static final String GLOBAL_VARIABLES_LOCK_NAME = "___GLOBAL_VARIABLES_LOCK____";
    private final ScopedExclusionService scopedExclusionService;
    private final VariableDefinitionFactory variableDefinitionFactory;
    private final VariableDefinitionManager variableDefinitionManager;
    private final Function<String, ManagedLock> globalVariablesModificationLock = ManagedLocks.weakManagedLockFactory();
    private static final Pattern SUFFIX_PATTERN = Pattern.compile("_\\d+");

    public VariableConfigurationServiceImpl(@NotNull ScopedExclusionService scopedExclusionService, @NotNull VariableDefinitionManager variableDefinitionManager, @NotNull VariableDefinitionFactory variableDefinitionFactory) {
        this.scopedExclusionService = scopedExclusionService;
        this.variableDefinitionFactory = variableDefinitionFactory;
        this.variableDefinitionManager = variableDefinitionManager;
    }

    private Predicate<VariableDefinition> hasTheSameKeyPrefixAndValue(String keyToCompare, String valueToCompare) {
        return variableDefinition -> {
            if (variableDefinition.getKey().startsWith(keyToCompare) && (variableDefinition.getKey().equals(keyToCompare) || SUFFIX_PATTERN.matcher(variableDefinition.getKey().substring(keyToCompare.length())).matches())) {
                return valueToCompare.equals(variableDefinition.getValue());
            }
            return false;
        };
    }

    private Predicate<VariableDefinition> hasTheSameKey(String keyToCompare) {
        return variableDefinition -> keyToCompare.equals(variableDefinition.getKey());
    }

    @NotNull
    private String getNewUniqueKey(List<VariableDefinition> variableDefinitions, String variableKey) {
        String candidateKey = variableKey;
        int suffix = 1;
        while (variableDefinitions.stream().anyMatch(this.hasTheSameKey(candidateKey))) {
            candidateKey = variableKey + '_' + suffix;
            ++suffix;
        }
        return candidateKey;
    }

    @NotNull
    public VariableDefinition createUniquePlanVariable(final @NotNull Plan plan, final @NotNull String variableKey, final @NotNull String variableValue) {
        return (VariableDefinition)this.scopedExclusionService.withLock((Enum)ScopedExclusionService.ExclusionScopeType.VARIABLES, (Object)plan.getPlanKey(), ScopedExclusionServiceHelper.adapt(new Supplier<VariableDefinition>(){

            @Override
            public VariableDefinition get() {
                List variableDefinitions = VariableConfigurationServiceImpl.this.variableDefinitionManager.getPlanVariables((PlanIdentifier)plan);
                VariableDefinition existingVariable = (VariableDefinition)Iterables.find((Iterable)variableDefinitions, VariableConfigurationServiceImpl.this.hasTheSameKeyPrefixAndValue(variableKey, variableValue)::test, null);
                if (existingVariable != null) {
                    return existingVariable;
                }
                String localVariableKey = VariableConfigurationServiceImpl.this.getNewUniqueKey(variableDefinitions, variableKey);
                VariableDefinition variableDefinition = VariableConfigurationServiceImpl.this.variableDefinitionFactory.createPlanVariable(plan, localVariableKey, variableValue);
                VariableConfigurationServiceImpl.this.variableDefinitionManager.saveVariableDefinition(variableDefinition);
                return variableDefinition;
            }
        }));
    }

    @NotNull
    public VariableDefinition createUniqueGlobalVariable(final @NotNull String variableKey, final @NotNull String variableValue) {
        return (VariableDefinition)this.globalVariablesModificationLock.apply(GLOBAL_VARIABLES_LOCK_NAME).withLock((Supplier)new Supplier<VariableDefinition>(){

            @Override
            public VariableDefinition get() {
                List variableDefinitions = VariableConfigurationServiceImpl.this.variableDefinitionManager.getGlobalVariables();
                Optional existingVariable = variableDefinitions.stream().filter(VariableConfigurationServiceImpl.this.hasTheSameKeyPrefixAndValue(variableKey, variableValue)).findFirst();
                if (existingVariable.isPresent()) {
                    return (VariableDefinition)existingVariable.get();
                }
                String localVariableKey = VariableConfigurationServiceImpl.this.getNewUniqueKey(variableDefinitions, variableKey);
                VariableDefinition variableDefinition = VariableConfigurationServiceImpl.this.variableDefinitionFactory.createGlobalVariable(localVariableKey, variableValue);
                VariableConfigurationServiceImpl.this.variableDefinitionManager.saveVariableDefinition(variableDefinition);
                return variableDefinition;
            }
        });
    }

    @NotNull
    public VariableDefinition createPlanVariable(final @NotNull Plan plan, final @NotNull String variableKey, final @NotNull String variableValue) {
        return (VariableDefinition)this.scopedExclusionService.withLock((Enum)ScopedExclusionService.ExclusionScopeType.VARIABLES, (Object)plan.getPlanKey(), ScopedExclusionServiceHelper.adapt(new Supplier<VariableDefinition>(){

            @Override
            public VariableDefinition get() {
                VariableConfigurationServiceImpl.this.validateVariableDefinitionDoesNotExist(VariableConfigurationServiceImpl.this.variableDefinitionManager.getPlanVariables((PlanIdentifier)plan), variableKey);
                VariableDefinition variableDefinition = VariableConfigurationServiceImpl.this.variableDefinitionFactory.createPlanVariable(plan, variableKey, variableValue);
                VariableConfigurationServiceImpl.this.variableDefinitionManager.saveVariableDefinition(variableDefinition);
                return variableDefinition;
            }
        }));
    }

    @NotNull
    public VariableDefinition createVariableForEnvironment(final long environmentId, final @NotNull String variableKey, final @NotNull String variableValue) {
        return (VariableDefinition)this.scopedExclusionService.withLock((Enum)ScopedExclusionService.ExclusionScopeType.VARIABLES, (Object)environmentId, ScopedExclusionServiceHelper.adapt(new Supplier<VariableDefinition>(){

            @Override
            public VariableDefinition get() {
                VariableConfigurationServiceImpl.this.validateVariableDefinitionDoesNotExist(VariableConfigurationServiceImpl.this.variableDefinitionManager.getDeploymentEnvironmentVariables(environmentId), variableKey);
                VariableDefinition variableDefinition = VariableConfigurationServiceImpl.this.variableDefinitionFactory.createVariableForEnvironment(environmentId, variableKey, variableValue);
                VariableConfigurationServiceImpl.this.variableDefinitionManager.saveVariableDefinition(variableDefinition);
                return variableDefinition;
            }
        }));
    }

    @NotNull
    public VariableDefinition createGlobalVariable(final @NotNull String variableKey, final @NotNull String variableValue) {
        return (VariableDefinition)this.globalVariablesModificationLock.apply(GLOBAL_VARIABLES_LOCK_NAME).withLock((Supplier)new Supplier<VariableDefinition>(){

            @Override
            public VariableDefinition get() {
                VariableConfigurationServiceImpl.this.validateVariableDefinitionDoesNotExist(VariableConfigurationServiceImpl.this.variableDefinitionManager.getGlobalVariables(), variableKey);
                VariableDefinition variableDefinition = VariableConfigurationServiceImpl.this.variableDefinitionFactory.createGlobalVariable(variableKey, variableValue);
                VariableConfigurationServiceImpl.this.variableDefinitionManager.saveVariableDefinition(variableDefinition);
                return variableDefinition;
            }
        });
    }

    @NotNull
    public VariableDefinition updateVariableDefinition(final @NotNull VariableDefinition variableDefinition, final String previousValue) {
        if (variableDefinition.getPlan() != null) {
            return (VariableDefinition)this.scopedExclusionService.withLock((Enum)ScopedExclusionService.ExclusionScopeType.VARIABLES, (Object)variableDefinition.getPlan().getPlanKey(), ScopedExclusionServiceHelper.adapt(new Supplier<VariableDefinition>(){

                @Override
                public VariableDefinition get() {
                    VariableDefinition existingVariable = VariableConfigurationServiceImpl.this.variableDefinitionManager.getPlanVariableByKey((PlanIdentifier)variableDefinition.getPlan(), variableDefinition.getKey());
                    if (existingVariable != null && existingVariable.getId() != variableDefinition.getId()) {
                        throw new IllegalArgumentException("Variable key " + variableDefinition.getKey() + " already exists");
                    }
                    VariableConfigurationServiceImpl.this.variableDefinitionManager.saveVariableDefinition(variableDefinition, previousValue);
                    return variableDefinition;
                }
            }));
        }
        if (variableDefinition.getEnvironmentId() != null) {
            return (VariableDefinition)this.scopedExclusionService.withLock((Enum)ScopedExclusionService.ExclusionScopeType.VARIABLES, (Object)variableDefinition.getEnvironmentId(), ScopedExclusionServiceHelper.adapt(new Supplier<VariableDefinition>(){

                @Override
                public VariableDefinition get() {
                    List variableDefinitions = VariableConfigurationServiceImpl.this.variableDefinitionManager.getDeploymentEnvironmentVariables(variableDefinition.getEnvironmentId().longValue());
                    VariableDefinition existingVariable = (VariableDefinition)Iterables.find((Iterable)variableDefinitions, VariableConfigurationServiceImpl.this.hasTheSameKey(variableDefinition.getKey())::test, null);
                    if (existingVariable != null && existingVariable.getId() != variableDefinition.getId()) {
                        throw new IllegalArgumentException("Variable key " + variableDefinition.getKey() + " already exists");
                    }
                    VariableConfigurationServiceImpl.this.variableDefinitionManager.saveVariableDefinition(variableDefinition, previousValue);
                    return variableDefinition;
                }
            }));
        }
        return (VariableDefinition)this.globalVariablesModificationLock.apply(GLOBAL_VARIABLES_LOCK_NAME).withLock(() -> {
            VariableDefinition existingVariable = this.variableDefinitionManager.getGlobalVariableByKey(variableDefinition.getKey());
            if (existingVariable != null && existingVariable.getId() != variableDefinition.getId()) {
                throw new IllegalArgumentException("Variable key " + variableDefinition.getKey() + " already exists");
            }
            this.variableDefinitionManager.saveVariableDefinition(variableDefinition, previousValue);
            return variableDefinition;
        });
    }

    public void deleteVariableDefinition(@NotNull VariableDefinition variableDefinition) {
        Runnable jobToRun = () -> this.variableDefinitionManager.deleteVariableDefinition(variableDefinition);
        if (variableDefinition.getPlan() != null) {
            this.scopedExclusionService.withLock((Enum)ScopedExclusionService.ExclusionScopeType.VARIABLES, (Object)variableDefinition.getPlan().getPlanKey(), ScopedExclusionServiceHelper.adapt(jobToRun));
        } else {
            this.globalVariablesModificationLock.apply(GLOBAL_VARIABLES_LOCK_NAME).withLock(jobToRun);
        }
    }

    public void setPlanVariables(@NotNull Chain plan, @NotNull List<VariableProperties> variables) {
        Map keysToValues = variables.stream().collect(Collectors.toMap(VariableProperties::getName, v -> v, BambooCollectors.throwingMerger(), HashMap::new));
        this.scopedExclusionService.withLock((Enum)ScopedExclusionService.ExclusionScopeType.VARIABLES, (Object)plan.getPlanKey(), ScopedExclusionServiceHelper.adapt(() -> {
            List existingVariables = this.variableDefinitionManager.getPlanVariables((PlanIdentifier)plan);
            this.createAndDeleteVariablesReturnUnprocessed(keysToValues, existingVariables).forEach((k, v) -> {
                VariableDefinition variableDefinition = this.variableDefinitionFactory.createPlanVariable((Plan)plan, k, v);
                this.variableDefinitionManager.saveVariableDefinition(variableDefinition);
            });
        }));
    }

    public void setDeploymentEnvironmentVariables(long environmentId, @NotNull List<VariableProperties> variables) {
        Map keysToValues = variables.stream().collect(Collectors.toMap(VariableProperties::getName, v -> v, BambooCollectors.throwingMerger(), HashMap::new));
        this.scopedExclusionService.withLock((Enum)ScopedExclusionService.ExclusionScopeType.VARIABLES, (Object)environmentId, ScopedExclusionServiceHelper.adapt(() -> {
            List existingVariables = this.variableDefinitionManager.getDeploymentEnvironmentVariables(environmentId);
            this.createAndDeleteVariablesReturnUnprocessed(keysToValues, existingVariables).forEach((k, v) -> {
                VariableDefinition variableDefinition = this.variableDefinitionFactory.createVariableForEnvironment(environmentId, k, v);
                this.variableDefinitionManager.saveVariableDefinition(variableDefinition);
            });
        }));
    }

    private Map<String, String> createAndDeleteVariablesReturnUnprocessed(Map<String, VariableProperties> keysToValues, List<VariableDefinition> existingVariables) {
        Map unprocessed = keysToValues.values().stream().collect(Collectors.toMap(VariableProperties::getName, VariableProperties::getValue, BambooCollectors.throwingMerger(), HashMap::new));
        for (VariableDefinition variableDefinition : existingVariables) {
            if (keysToValues.containsKey(variableDefinition.getKey())) {
                VariableProperties variableProperties = keysToValues.get(variableDefinition.getKey());
                String newValue = variableProperties.getValue();
                if (!variableProperties.isCreateOnly() && !variableDefinition.getValue().equals(newValue)) {
                    variableDefinition.setValue(newValue);
                    this.variableDefinitionManager.saveVariableDefinition(variableDefinition);
                }
                unprocessed.remove(variableDefinition.getKey());
                continue;
            }
            this.variableDefinitionManager.deleteVariableDefinition(variableDefinition);
        }
        return unprocessed;
    }

    private void validateVariableDefinitionDoesNotExist(Collection<VariableDefinition> variableDefinitions, String variableKey) {
        this.validateVariableDefinitionDoesNotExist(variableDefinitions.stream(), variableKey);
    }

    private void validateVariableDefinitionDoesNotExist(Stream<VariableDefinition> variableDefinitions, String variableKey) {
        Preconditions.checkArgument((boolean)variableDefinitions.noneMatch(this.hasTheSameKey(variableKey)), (String)"Variable key %s already exists", (Object[])new Object[]{variableKey});
    }
}

