/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.variable;

import com.atlassian.bamboo.build.Job;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.util.BambooIterables;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.util.PasswordMaskingUtils;
import com.atlassian.bamboo.variable.VariableContext;
import com.atlassian.bamboo.variable.VariableContextBuilder;
import com.atlassian.bamboo.variable.VariableContextImpl;
import com.atlassian.bamboo.variable.VariableDefinition;
import com.atlassian.bamboo.variable.VariableDefinitionContext;
import com.atlassian.bamboo.variable.VariableDefinitionContextImpl;
import com.atlassian.bamboo.variable.VariableDefinitionManager;
import com.atlassian.bamboo.variable.VariableFunctions;
import com.atlassian.bamboo.variable.VariableSubstitutionContext;
import com.atlassian.bamboo.variable.VariableType;
import com.atlassian.bamboo.variable.VariableUtils;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VariableContextBuilderImpl
implements VariableContextBuilder {
    private static final Logger log = Logger.getLogger(VariableContextBuilderImpl.class);
    private Map<String, VariableDefinitionContext> variables = new HashMap<String, VariableDefinitionContext>();
    private boolean excludePasswordVariables = false;
    private boolean maskPasswords = false;
    private final VariableDefinitionManager variableDefinitionManager;

    public VariableContextBuilderImpl(VariableDefinitionManager variableDefinitionManager) {
        this.variableDefinitionManager = variableDefinitionManager;
    }

    public VariableContextBuilder enforcePasswordMasking() {
        this.maskPasswords = true;
        return this;
    }

    public VariableContextBuilder excludePasswordVariables() {
        this.excludePasswordVariables = true;
        return this;
    }

    public VariableContextBuilder addManualVariables(@Nullable Map<String, String> input) {
        if (input != null) {
            for (Map.Entry<String, String> entry : input.entrySet()) {
                this.put(new VariableDefinitionContextImpl(entry.getKey(), entry.getValue(), VariableType.MANUAL));
            }
        }
        return this;
    }

    public VariableContextBuilder add(Iterable<VariableDefinition> input) {
        this.variables.putAll(VariableUtils.identifiersToContextMap(input));
        return this;
    }

    public VariableContextBuilder add(Map<String, VariableDefinitionContext> input) {
        this.variables.putAll(input);
        return this;
    }

    public VariableContextBuilder addFromSubstitutionContext(Iterable<? extends VariableSubstitutionContext> input) {
        BambooIterables.stream(input).map(VariableFunctions::definitionContextFromIdentifier).forEach(c -> this.variables.put(c.getKey(), (VariableDefinitionContext)c));
        return this;
    }

    public VariableContextBuilder addFromVariableContext(@Nullable VariableContext context) {
        if (context != null) {
            this.variables.putAll(context.getEffectiveVariables());
        }
        return this;
    }

    public VariableContextBuilder addGlobalVariables() {
        return this.add(this.variableDefinitionManager.getGlobalVariables());
    }

    public VariableContextBuilder addPlanVariables(@Nullable ImmutablePlan plan) {
        return this.add(plan != null ? plan.getEffectiveVariables() : Collections.emptyList());
    }

    public VariableContextBuilder addVariablesForEnvironment(@Nullable Long environmentId) {
        return this.add(environmentId != null ? this.variableDefinitionManager.getDeploymentEnvironmentVariables(environmentId.longValue()) : Collections.emptyList());
    }

    public VariableContextBuilder addVariablesForVersion(@Nullable Long deploymentVersionId) {
        return this.add(deploymentVersionId != null ? this.variableDefinitionManager.getDeploymentVersionVariables(deploymentVersionId.longValue()) : Collections.emptyList());
    }

    public VariableContextBuilder addParentPlanVariablesIfRequired(@Nullable ImmutablePlan plan) {
        Job job = (Job)Narrow.downTo((Object)plan, Job.class);
        return this.addPlanVariables((ImmutablePlan)(job != null ? job.getParent() : null));
    }

    public VariableContextBuilder addManualAndResultVariablesFromContext(@NotNull VariableContext variableContext) {
        variableContext.getEffectiveVariables().values().stream().filter(VariableFunctions::isManualOrResultVariable).forEach(vdc -> this.variables.put(vdc.getKey(), (VariableDefinitionContext)vdc));
        return this;
    }

    public VariableContext buildContext() {
        return new VariableContextImpl(this.buildMap());
    }

    public Map<String, VariableDefinitionContext> buildMap() {
        Predicate excludePasswordVariablesPredicate = this.excludePasswordVariables ? Predicates.not(PasswordMaskingUtils::shouldBeMasked) : Predicates.alwaysTrue();
        Function maskingPasswordsFunction = this.maskPasswords ? variableDefinitionContext -> PasswordMaskingUtils.shouldBeMasked((VariableDefinitionContext)variableDefinitionContext) ? new VariableDefinitionContextImpl(variableDefinitionContext.getKey(), PasswordMaskingUtils.mask((String)variableDefinitionContext.getValue(), (String)variableDefinitionContext.getValue()), variableDefinitionContext.getVariableType()) : variableDefinitionContext : Functions.identity();
        return new HashMap<String, VariableDefinitionContext>(Maps.transformValues((Map)Maps.filterKeys(this.variables, (Predicate)excludePasswordVariablesPredicate), (Function)maskingPasswordsFunction));
    }

    private void put(@NotNull VariableDefinitionContext variable) {
        this.variables.put(variable.getKey(), variable);
    }
}

