/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.variable;

import com.atlassian.bamboo.collections.message.FinalArrayList;
import com.atlassian.bamboo.collections.message.FinalHashMap;
import com.atlassian.bamboo.util.PasswordMaskingUtils;
import com.atlassian.bamboo.utils.concurrent.TransientResettableLazyReference;
import com.atlassian.bamboo.variable.VariableContext;
import com.atlassian.bamboo.variable.VariableDefinitionContext;
import com.atlassian.bamboo.variable.VariableDefinitionContextImpl;
import com.atlassian.bamboo.variable.VariableSubstitutionContext;
import com.atlassian.bamboo.variable.VariableSubstitutionContextImpl;
import com.atlassian.bamboo.variable.VariableType;
import com.atlassian.collectors.CollectorsUtil;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.concurrent.NotThreadSafe;
import org.jetbrains.annotations.NotNull;

@NotThreadSafe
public class VariableContextImpl
implements VariableContext {
    private final FinalHashMap<String, VariableDefinitionContextImpl> inheritedState;
    private final FinalHashMap<String, VariableDefinitionContextImpl> resultVariablesState = new FinalHashMap();
    private final FinalHashMap<String, VariableDefinitionContextImpl> localVariablesState = new FinalHashMap();
    private final TransientResettableLazyReference<FinalArrayList<VariableDefinitionContextImpl>> passwordVariablesRef = new TransientResettableLazyReference<FinalArrayList<VariableDefinitionContextImpl>>(){

        protected FinalArrayList<VariableDefinitionContextImpl> create() {
            return new FinalArrayList((Collection)((FinalHashMap)VariableContextImpl.this.effectiveStateRef.get()).values().stream().filter(PasswordMaskingUtils::shouldBeMasked).collect(CollectorsUtil.toImmutableList()));
        }
    };
    private final TransientResettableLazyReference<FinalHashMap<String, VariableDefinitionContextImpl>> effectiveStateRef = new TransientResettableLazyReference<FinalHashMap<String, VariableDefinitionContextImpl>>(){

        protected FinalHashMap<String, VariableDefinitionContextImpl> create() {
            HashMap effectiveState = new HashMap(VariableContextImpl.this.inheritedState);
            effectiveState.putAll(VariableContextImpl.this.resultVariablesState);
            effectiveState.putAll(VariableContextImpl.this.localVariablesState);
            return new FinalHashMap(effectiveState);
        }
    };
    private FinalHashMap<String, VariableSubstitutionContextImpl> substitutions;

    public VariableContextImpl(Map<String, VariableDefinitionContext> definitions) {
        this.inheritedState = new FinalHashMap();
        for (Map.Entry<String, VariableDefinitionContext> definition : definitions.entrySet()) {
            this.inheritedState.put((Object)definition.getKey(), (Object)new VariableDefinitionContextImpl(definition.getValue()));
        }
        this.substitutions = new FinalHashMap();
    }

    @NotNull
    public Map<String, VariableSubstitutionContext> getSubstitutions() {
        return this.substitutions;
    }

    @NotNull
    public Map<String, VariableDefinitionContext> getDefinitions() {
        return this.getEffectiveVariables();
    }

    @NotNull
    public Map<String, VariableDefinitionContext> getOriginalVariables() {
        return Collections.unmodifiableMap(this.inheritedState);
    }

    @NotNull
    public Map<String, VariableDefinitionContext> getEffectiveVariables() {
        return Collections.unmodifiableMap((Map)this.effectiveStateRef.get());
    }

    @NotNull
    public Map<String, VariableDefinitionContext> getResultVariables() {
        return ImmutableMap.copyOf(this.resultVariablesState);
    }

    public void addResultVariable(@NotNull String key, @NotNull String value) {
        this.localVariablesState.remove((Object)key);
        this.resultVariablesState.put((Object)key, (Object)new VariableDefinitionContextImpl(key, value, VariableType.RESULT));
        this.effectiveStateRef.reset();
        this.passwordVariablesRef.reset();
    }

    public void addLocalVariable(@NotNull String key, @NotNull String value) {
        this.localVariablesState.put((Object)key, (Object)new VariableDefinitionContextImpl(key, value, VariableType.CUSTOM));
        this.effectiveStateRef.reset();
        this.passwordVariablesRef.reset();
    }

    public void removeLocalVariable(@NotNull String key) {
        this.localVariablesState.remove((Object)key);
        this.effectiveStateRef.reset();
        this.passwordVariablesRef.reset();
    }

    public List<VariableDefinitionContext> getPasswordVariables() {
        return Collections.unmodifiableList((List)this.passwordVariablesRef.get());
    }
}

