/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.variable;

import com.atlassian.bamboo.plan.PlanIdentifier;
import com.atlassian.bamboo.utils.Comparators;
import com.atlassian.bamboo.utils.scopedcaches.ThreadScopedCaches;
import com.atlassian.bamboo.variable.EncryptedVariableDefinitionAccessor;
import com.atlassian.bamboo.variable.VariableContext;
import com.atlassian.bamboo.variable.VariableDefinition;
import com.atlassian.bamboo.variable.VariableDefinitionDao;
import com.atlassian.bamboo.variable.VariableDefinitionIdentifier;
import com.atlassian.bamboo.variable.VariableFunctions;
import com.atlassian.bamboo.variable.VariableType;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VariableDefinitionAccessorImpl
implements EncryptedVariableDefinitionAccessor {
    private final VariableDefinitionDao variableDefinitionDao;

    public VariableDefinitionAccessorImpl(VariableDefinitionDao variableDefinitionDao) {
        this.variableDefinitionDao = variableDefinitionDao;
    }

    @Nullable
    public VariableDefinition findVariableDefinition(long id) {
        return this.variableDefinitionDao.findById(id);
    }

    @NotNull
    public List<VariableDefinition> getGlobalVariables() {
        return new ArrayList<VariableDefinition>(this.getGlobalVariablesViaCache());
    }

    @Nullable
    public VariableDefinition getGlobalVariableByKey(String key) {
        return this.variableDefinitionDao.findGlobalVariableByKey(key);
    }

    @Nullable
    public VariableDefinition getPlanVariableByKey(@NotNull PlanIdentifier plan, @NotNull String key) {
        return this.variableDefinitionDao.findPlanVariableByKey(plan, key);
    }

    @NotNull
    public List<VariableDefinition> getPlanVariables(@NotNull PlanIdentifier plan) {
        return Comparators.getVariableDefinitionOrdering().sortedCopy((Iterable)this.variableDefinitionDao.findVariablesByPlan(plan));
    }

    public int countDeploymentEnvironmentVariables(long environmentId) {
        return this.variableDefinitionDao.countVariablesByEnvironmentId(environmentId);
    }

    @NotNull
    public List<VariableDefinition> getDeploymentEnvironmentVariables(long environmentId) {
        return Comparators.getVariableDefinitionOrdering().sortedCopy(this.variableDefinitionDao.findVariablesByEnvironmentId(environmentId));
    }

    @NotNull
    public List<VariableDefinition> getDeploymentVersionVariables(long deploymentVersionId) {
        return Comparators.getVariableDefinitionOrdering().sortedCopy(this.variableDefinitionDao.findVariablesByVersionId(deploymentVersionId));
    }

    @NotNull
    public List<VariableDefinition> getGlobalNotOverriddenVariables(@NotNull PlanIdentifier plan) {
        List planVariables = this.variableDefinitionDao.findVariablesByPlan(plan);
        HashSet<String> planVariablesKeys = new HashSet<String>();
        for (VariableDefinition planVariable : planVariables) {
            planVariablesKeys.add(planVariable.getKey());
        }
        return this.getGlobalVariablesViaCache().stream().filter(variableDefinition -> !planVariablesKeys.contains(variableDefinition.getKey())).collect(Collectors.toCollection(ArrayList::new));
    }

    @NotNull
    public List<VariableDefinition> getGlobalNotOverriddenEnvironmentVariables(long environmentId) {
        List<VariableDefinition> envVariables = this.getDeploymentEnvironmentVariables(environmentId);
        HashSet<String> envVariablesKeys = new HashSet<String>();
        for (VariableDefinition envVariable : envVariables) {
            envVariablesKeys.add(envVariable.getKey());
        }
        return this.getGlobalVariablesViaCache().stream().filter(variableDefinition -> !envVariablesKeys.contains(variableDefinition.getKey())).collect(Collectors.toCollection(ArrayList::new));
    }

    @NotNull
    public Map<String, String> getSimpleVariableMapByType(@NotNull VariableContext variableContext, @NotNull VariableType variableType) {
        return new HashMap<String, String>(Maps.transformValues((Map)Maps.filterValues((Map)variableContext.getEffectiveVariables(), vdc -> variableType.equals((Object)VariableFunctions.getVariableType((VariableDefinitionIdentifier)vdc))), VariableFunctions.getVariableDefinitionContextValue()));
    }

    private List<VariableDefinition> getGlobalVariablesViaCache() {
        return (List)ThreadScopedCaches.getValue((ThreadScopedCaches.Key)RequestScopedCacheKey.VARIABLES_CACHE, (Object)"allGlobalSorted", () -> Comparators.getVariableDefinitionOrdering().sortedCopy((Iterable)this.variableDefinitionDao.findGlobalVariables()));
    }

    private static enum RequestScopedCacheKey implements ThreadScopedCaches.Key<String, List<VariableDefinition>>
    {
        VARIABLES_CACHE;

    }
}

