/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.variable;

import com.atlassian.bamboo.plan.Plan;
import com.atlassian.bamboo.plan.PlanClassHelper;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.variable.VariableDefinition;
import com.atlassian.bamboo.variable.VariableDefinitionFactory;
import com.atlassian.bamboo.variable.VariableDefinitionImpl;
import com.atlassian.bamboo.variable.VariableType;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class VariableDefinitionFactoryImpl
implements VariableDefinitionFactory {
    private static final Logger log = Logger.getLogger(VariableDefinitionFactoryImpl.class);

    public VariableDefinition createGlobalVariable(@NotNull String key, @NotNull String value) {
        VariableDefinitionImpl variableDefinition = new VariableDefinitionImpl();
        variableDefinition.setKey(key);
        variableDefinition.setValue(value);
        variableDefinition.setVariableType(VariableType.GLOBAL);
        return variableDefinition;
    }

    public VariableDefinition createPlanVariable(@NotNull Plan plan, @NotNull String key, @NotNull String value) {
        VariableDefinitionImpl variableDefinition = new VariableDefinitionImpl();
        variableDefinition.setPlan(plan);
        variableDefinition.setKey(key);
        variableDefinition.setValue(value);
        if (PlanClassHelper.isJob((ImmutablePlan)plan)) {
            variableDefinition.setVariableType(VariableType.JOB);
        } else {
            variableDefinition.setVariableType(VariableType.PLAN);
        }
        return variableDefinition;
    }

    public VariableDefinition createVariableForEnvironment(long environmentId, String variableKey, String variableValue) {
        VariableDefinitionImpl variableDefinition = new VariableDefinitionImpl();
        variableDefinition.setEnvironmentId(environmentId);
        variableDefinition.setKey(variableKey);
        variableDefinition.setValue(variableValue);
        variableDefinition.setVariableType(VariableType.ENVIRONMENT);
        return variableDefinition;
    }

    public VariableDefinition createVariableForVersion(long versionId, String variableKey, String variableValue) {
        VariableDefinitionImpl variableDefinition = new VariableDefinitionImpl();
        variableDefinition.setDeploymentVersionId(versionId);
        variableDefinition.setKey(variableKey);
        variableDefinition.setValue(variableValue);
        variableDefinition.setVariableType(VariableType.VERSION);
        return variableDefinition;
    }
}

