/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.variable;

import com.atlassian.bamboo.core.BambooEntityObject;
import com.atlassian.bamboo.plan.Plan;
import com.atlassian.bamboo.variable.VariableDefinition;
import com.atlassian.bamboo.variable.VariableType;
import com.google.common.base.MoreObjects;
import javax.persistence.Entity;
import javax.persistence.Table;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.annotations.GenericGenerator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Entity
@Table(name="VARIABLE_DEFINITION")
@GenericGenerator(name="ImportAwareGenerator", strategy="com.atlassian.bamboo.persistence.ImportAwareGenerator")
public class VariableDefinitionImpl
extends BambooEntityObject
implements VariableDefinition {
    public static final long KEY_MAX_LENGTH = 255L;
    public static final long VALUE_MAX_LENGTH = 4000L;
    private String key;
    private String value;
    private Plan plan;
    private Long environmentId;
    private Long deploymentVersionId;
    private VariableType variableType;

    public static VariableDefinition clone(@NotNull VariableDefinition input) {
        VariableDefinitionImpl variableDefinition = new VariableDefinitionImpl(input);
        variableDefinition.setId(input.getId());
        return variableDefinition;
    }

    public VariableDefinitionImpl() {
    }

    public VariableDefinitionImpl(String key, String value, Plan plan, VariableType variableType) {
        this.key = key;
        this.value = value;
        this.plan = plan;
        this.variableType = variableType;
    }

    public VariableDefinitionImpl(VariableDefinition other) {
        this.key = other.getKey();
        this.value = other.getValue();
        this.plan = other.getPlan();
        this.environmentId = other.getEnvironmentId();
        this.deploymentVersionId = other.getDeploymentVersionId();
        this.variableType = other.getVariableType();
    }

    @NotNull
    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getValue() {
        return StringUtils.defaultString((String)this.value);
    }

    public void setValue(String value) {
        this.value = StringUtils.defaultString((String)value);
    }

    public VariableType getVariableType() {
        return this.variableType;
    }

    public void setVariableType(VariableType variableType) {
        this.variableType = variableType;
    }

    public Plan getPlan() {
        return this.plan;
    }

    public void setPlan(Plan plan) {
        this.plan = plan;
    }

    @Nullable
    public Long getEnvironmentId() {
        return this.environmentId;
    }

    public void setEnvironmentId(@Nullable Long environmentId) {
        this.environmentId = environmentId;
    }

    @Nullable
    public Long getDeploymentVersionId() {
        return this.deploymentVersionId;
    }

    public void setDeploymentVersionId(@Nullable Long deploymentVersionId) {
        this.deploymentVersionId = deploymentVersionId;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("variableType", (Object)this.variableType).add("plan", this.plan != null ? this.plan.getPlanKey() : "<none>").add("key", (Object)this.key).add("value", (Object)this.value).add("environmentId", (Object)this.environmentId).add("deploymentVersionId", (Object)this.deploymentVersionId).toString();
    }
}

