/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.variable;

import com.atlassian.bamboo.Key;
import com.atlassian.bamboo.core.BambooObject;
import com.atlassian.bamboo.crypto.instance.SecretEncryptionService;
import com.atlassian.bamboo.deployments.environments.Environment;
import com.atlassian.bamboo.deployments.environments.service.EnvironmentService;
import com.atlassian.bamboo.persister.AuditLogEntity;
import com.atlassian.bamboo.persister.AuditLogEntityType;
import com.atlassian.bamboo.persister.AuditLogService;
import com.atlassian.bamboo.plan.Plan;
import com.atlassian.bamboo.plan.PlanIdentifier;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.util.BambooIterables;
import com.atlassian.bamboo.util.PasswordMaskingUtils;
import com.atlassian.bamboo.variable.EncryptedVariableDefinitionAccessor;
import com.atlassian.bamboo.variable.VariableContext;
import com.atlassian.bamboo.variable.VariableContextBuilder;
import com.atlassian.bamboo.variable.VariableContextBuilderImpl;
import com.atlassian.bamboo.variable.VariableDefinition;
import com.atlassian.bamboo.variable.VariableDefinitionDao;
import com.atlassian.bamboo.variable.VariableDefinitionImpl;
import com.atlassian.bamboo.variable.VariableDefinitionManager;
import com.atlassian.bamboo.variable.VariableType;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.context.annotation.Lazy;

public class VariableDefinitionManagerImpl
implements VariableDefinitionManager {
    private static final Logger log = Logger.getLogger(VariableDefinitionManagerImpl.class);
    private static final String VARIABLE_HAS_BEEN_REMOVED = "Variable [%s] has been removed.";
    private static final String VARIABLE_HAS_BEEN_CREATED = "Variable [%s] has been created.";
    private static final String VARIABLE_HAS_BEEN_CHANGED = "Variable [%s] has been changed.";
    private final VariableDefinitionDao variableDefinitionDao;
    private final AuditLogService auditLogService;
    private final EncryptedVariableDefinitionAccessor encryptedVariableDefinitionAccessor;
    @Inject
    @Lazy
    private EnvironmentService environmentService;
    @Inject
    @Lazy
    private SecretEncryptionService secretEncryptionService;

    public VariableDefinitionManagerImpl(VariableDefinitionDao variableDefinitionDao, AuditLogService auditLogService, EncryptedVariableDefinitionAccessor encryptedVariableDefinitionAccessor) {
        this.variableDefinitionDao = variableDefinitionDao;
        this.auditLogService = auditLogService;
        this.encryptedVariableDefinitionAccessor = encryptedVariableDefinitionAccessor;
    }

    @Nullable
    public VariableDefinition findVariableDefinition(long id) {
        return this.decrypt(this.encryptedVariableDefinitionAccessor.findVariableDefinition(id));
    }

    public void saveVariableDefinition(@NotNull VariableDefinition variableDefinition) {
        String value = variableDefinition.getValue();
        this.variableDefinitionDao.save((BambooObject)this.encrypt(variableDefinition));
        this.createAuditLogRecord(variableDefinition, VARIABLE_HAS_BEEN_CREATED, value, null);
    }

    public void saveVariableDefinition(@NotNull VariableDefinition variableDefinition, @Nullable String previousValue) {
        String value = variableDefinition.getValue();
        this.variableDefinitionDao.save((BambooObject)this.encrypt(variableDefinition));
        this.createAuditLogRecord(variableDefinition, VARIABLE_HAS_BEEN_CHANGED, value, previousValue);
    }

    public void deleteVariableDefinition(@NotNull VariableDefinition variableDefinition) {
        VariableDefinition byId = this.variableDefinitionDao.findById(variableDefinition.getId());
        if (byId != null) {
            this.variableDefinitionDao.delete((BambooObject)byId);
            this.createAuditLogRecord(variableDefinition, VARIABLE_HAS_BEEN_REMOVED, null, null);
        }
    }

    public void deleteVariablesForPlan(@NotNull Plan plan) {
        this.variableDefinitionDao.deleteByPlan(plan.getId());
    }

    @NotNull
    public List<VariableDefinition> getGlobalVariables() {
        return this.decrypt(this.encryptedVariableDefinitionAccessor.getGlobalVariables());
    }

    @Nullable
    public VariableDefinition getGlobalVariableByKey(String key) {
        return this.decrypt(this.encryptedVariableDefinitionAccessor.getGlobalVariableByKey(key));
    }

    @Nullable
    public VariableDefinition getPlanVariableByKey(@NotNull PlanIdentifier plan, @NotNull String key) {
        return this.decrypt(this.encryptedVariableDefinitionAccessor.getPlanVariableByKey(plan, key));
    }

    @NotNull
    public List<VariableDefinition> getPlanVariables(@NotNull PlanIdentifier plan) {
        return this.decrypt(this.encryptedVariableDefinitionAccessor.getPlanVariables(plan));
    }

    public int countDeploymentEnvironmentVariables(long environmentId) {
        return this.encryptedVariableDefinitionAccessor.countDeploymentEnvironmentVariables(environmentId);
    }

    @NotNull
    public List<VariableDefinition> getDeploymentEnvironmentVariables(long environmentId) {
        return this.decrypt(this.encryptedVariableDefinitionAccessor.getDeploymentEnvironmentVariables(environmentId));
    }

    @NotNull
    public List<VariableDefinition> getDeploymentVersionVariables(long deploymentVersionId) {
        return this.decrypt(this.encryptedVariableDefinitionAccessor.getDeploymentVersionVariables(deploymentVersionId));
    }

    @NotNull
    public List<VariableDefinition> getGlobalNotOverriddenVariables(@NotNull PlanIdentifier plan) {
        return this.decrypt(this.encryptedVariableDefinitionAccessor.getGlobalNotOverriddenVariables(plan));
    }

    @NotNull
    public List<VariableDefinition> getGlobalNotOverriddenEnvironmentVariables(long environmentId) {
        return this.decrypt(this.encryptedVariableDefinitionAccessor.getGlobalNotOverriddenEnvironmentVariables(environmentId));
    }

    @NotNull
    public Map<String, String> getSimpleVariableMapByType(@NotNull VariableContext variableContext, @NotNull VariableType variableType) {
        return this.encryptedVariableDefinitionAccessor.getSimpleVariableMapByType(variableContext, variableType);
    }

    @NotNull
    public VariableContextBuilder createVariableContextBuilder() {
        return new VariableContextBuilderImpl(this);
    }

    public void remove(VariableDefinition variableDefinition) {
        this.variableDefinitionDao.delete((BambooObject)variableDefinition);
    }

    public void save(VariableDefinition variableDefinition) {
        this.variableDefinitionDao.save((BambooObject)this.encrypt(variableDefinition));
    }

    public void saveVariableDefinitions(List<VariableDefinition> variableDefinitions) {
        this.variableDefinitionDao.saveAll(this.encrypt(variableDefinitions));
    }

    @Nullable
    private VariableDefinition decrypt(@Nullable VariableDefinition variableDefinition) {
        if (variableDefinition == null) {
            return null;
        }
        VariableDefinition copy = VariableDefinitionImpl.clone(variableDefinition);
        if (variableDefinition.getValue() != null && PasswordMaskingUtils.shouldBeMasked((String)variableDefinition.getKey()) && this.secretEncryptionService.isEncrypted(variableDefinition.getValue())) {
            copy.setValue(this.secretEncryptionService.decrypt(variableDefinition.getValue()));
        }
        return copy;
    }

    private List<VariableDefinition> decrypt(@NotNull Iterable<VariableDefinition> variablesByVersionId) {
        return BambooIterables.stream(variablesByVersionId).map(this::decrypt).collect(Collectors.toCollection(ArrayList::new));
    }

    private List<VariableDefinition> encrypt(List<VariableDefinition> variableDefinitions) {
        return variableDefinitions.stream().map(this::encrypt).collect(Collectors.toCollection(ArrayList::new));
    }

    @NotNull
    private VariableDefinition encrypt(@NotNull VariableDefinition variableDefinition) {
        if (PasswordMaskingUtils.shouldBeMasked((String)variableDefinition.getKey()) && !this.secretEncryptionService.isEncrypted(variableDefinition.getValue())) {
            String value = variableDefinition.getValue();
            if (value == null) {
                variableDefinition.setValue(null);
            } else {
                variableDefinition.setValue(this.secretEncryptionService.encrypt(value));
            }
        }
        return variableDefinition;
    }

    private String getVariableHeader(VariableDefinition variableDefinition) {
        return variableDefinition.getVariableType().name();
    }

    private void createAuditLogRecord(@NotNull VariableDefinition variableDefinition, String action, String value, String oldValue) {
        if (variableDefinition.getPlan() != null) {
            PlanKey planKey;
            Plan plan = variableDefinition.getPlan();
            PlanKey planKey2 = planKey = plan != null ? plan.getPlanKey() : null;
            if (Objects.equals(value, oldValue)) {
                this.auditLogService.log(String.format(action, variableDefinition.getKey()), (Key)planKey, AuditLogEntityType.PLAN, new AuditLogEntity(AuditLogEntityType.VARIABLE, this.getVariableHeader(variableDefinition)));
            } else {
                this.auditLogService.log(String.format(action, variableDefinition.getKey()), oldValue, value, (Key)planKey, AuditLogEntityType.PLAN, new AuditLogEntity(AuditLogEntityType.VARIABLE, this.getVariableHeader(variableDefinition)));
            }
        } else if (variableDefinition.getEnvironmentId() != null) {
            Environment environment = this.environmentService.getEnvironment(variableDefinition.getEnvironmentId().longValue());
            if (environment != null) {
                if (Objects.equals(value, oldValue)) {
                    this.auditLogService.log(String.format(action, variableDefinition.getKey()), (Key)environment.getKey(), AuditLogEntityType.DEPLOYMENT_PROJECT, new AuditLogEntity(AuditLogEntityType.VARIABLE, this.getVariableHeader(variableDefinition)));
                } else {
                    this.auditLogService.log(String.format(action, variableDefinition.getKey()), oldValue, value, (Key)environment.getKey(), AuditLogEntityType.DEPLOYMENT_PROJECT, new AuditLogEntity(AuditLogEntityType.VARIABLE, this.getVariableHeader(variableDefinition)));
                }
            } else {
                log.error((Object)("Can't create audit log for variable as environment can't be found " + variableDefinition.getEnvironmentId()));
            }
        } else if (Objects.equals(value, oldValue)) {
            this.auditLogService.log(String.format(action, variableDefinition.getKey()), null, null, new AuditLogEntity(AuditLogEntityType.VARIABLE, this.getVariableHeader(variableDefinition)));
        } else {
            this.auditLogService.log(String.format(action, variableDefinition.getKey()), oldValue, value, null, null, new AuditLogEntity(AuditLogEntityType.VARIABLE, this.getVariableHeader(variableDefinition)));
        }
    }
}

