/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.variable;

import com.atlassian.bamboo.variable.VariableDefinition;
import com.atlassian.bamboo.variable.VariableDefinitionContext;
import com.atlassian.bamboo.variable.VariableDefinitionContextImpl;
import com.atlassian.bamboo.variable.VariableDefinitionIdentifier;
import com.atlassian.bamboo.variable.VariableSubstitutionContext;
import com.atlassian.bamboo.variable.VariableSubstitutionContextImpl;
import com.atlassian.bamboo.variable.VariableType;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import java.util.EnumSet;
import org.jetbrains.annotations.Nullable;

public class VariableFunctions {
    private static EnumSet<VariableType> MANUAL_OR_RESULT = EnumSet.of(VariableType.MANUAL, VariableType.RESULT);

    public static VariableType getVariableType(@Nullable VariableDefinitionIdentifier input) {
        return ((VariableDefinitionIdentifier)Preconditions.checkNotNull((Object)input)).getVariableType();
    }

    public static String getVariableValue(@Nullable VariableDefinitionIdentifier input) {
        return ((VariableDefinitionIdentifier)Preconditions.checkNotNull((Object)input)).getValue();
    }

    public static VariableSubstitutionContext copyVariableSubstitutionContext(@Nullable VariableSubstitutionContext input) {
        Preconditions.checkNotNull((Object)input);
        return new VariableSubstitutionContextImpl(input);
    }

    public static VariableDefinitionContext definitionContextFromIdentifier(@Nullable VariableDefinitionIdentifier input) {
        Preconditions.checkNotNull((Object)input);
        return new VariableDefinitionContextImpl(input.getKey(), input.getValue(), input.getVariableType());
    }

    public static String getVariableKey(@Nullable VariableDefinitionIdentifier input) {
        Preconditions.checkNotNull((Object)input);
        return input.getKey();
    }

    public static boolean isManualOrResultVariable(VariableDefinitionIdentifier input) {
        return MANUAL_OR_RESULT.contains(input.getVariableType());
    }

    private VariableFunctions() {
    }

    public static Function<VariableDefinition, VariableType> getVariableDefinitionType() {
        return VariableFunctions::getVariableType;
    }

    public static Function<VariableDefinitionContext, VariableType> getVariableDefinitionContextType() {
        return VariableFunctions::getVariableType;
    }

    public static Function<VariableDefinitionContext, String> getVariableDefinitionContextValue() {
        return VariableFunctions::getVariableValue;
    }

    public static Function<VariableSubstitutionContext, VariableSubstitutionContext> getCopySubstitutionContextFunction() {
        return VariableFunctions::copyVariableSubstitutionContext;
    }

    public static Function<VariableDefinitionIdentifier, VariableDefinitionContext> definitionFromIdentifier() {
        return VariableFunctions::definitionContextFromIdentifier;
    }

    public static Function<VariableDefinitionIdentifier, String> getVariableKey() {
        return VariableFunctions::getVariableKey;
    }

    public static Predicate<VariableDefinitionIdentifier> isManualOrResult() {
        return VariableFunctions::isManualOrResultVariable;
    }
}

