/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.variable;

import com.atlassian.annotations.Internal;
import com.atlassian.bamboo.variable.VariableDefinitionIdentifier;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

@Internal
public class VariableHashCodeProvider {
    private VariableHashCodeProvider() {
    }

    public static String calculateVariableSetSha(@NotNull Iterable<? extends VariableDefinitionIdentifier> variableDefinitionIdentifiers) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        for (VariableDefinitionIdentifier variableDefinitionIdentifier : variableDefinitionIdentifiers) {
            try {
                Charset charset = StandardCharsets.UTF_8;
                baos.write(variableDefinitionIdentifier.getKey().getBytes(charset));
                baos.write(0);
                baos.write(((String)StringUtils.defaultIfEmpty((CharSequence)variableDefinitionIdentifier.getValue(), (CharSequence)"")).getBytes(charset));
                baos.write(0);
                baos.write(variableDefinitionIdentifier.getVariableType().name().getBytes(charset));
                baos.write(0);
            }
            catch (IOException e) {
                throw new RuntimeException("Cannot happen: Error writing string to byte array", e);
            }
        }
        return DigestUtils.shaHex((byte[])baos.toByteArray());
    }
}

