/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.variable;

import java.util.Objects;
import javax.annotation.concurrent.Immutable;
import org.jetbrains.annotations.NotNull;

@Immutable
public class VariableUsage {
    private final String namespace;
    private final String name;

    public VariableUsage(@NotNull String namespace, @NotNull String name) {
        this.namespace = namespace;
        this.name = name;
    }

    @NotNull
    public String getNamespace() {
        return this.namespace;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public String toUsageString() {
        return String.format("${%s.%s}", this.namespace, this.name);
    }

    public String toString() {
        return this.toUsageString();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof VariableUsage)) {
            return false;
        }
        VariableUsage variableUsage = (VariableUsage)other;
        return Objects.equals(this.namespace, variableUsage.namespace) && Objects.equals(this.name, variableUsage.name);
    }

    public int hashCode() {
        return Objects.hash(this.namespace, this.name);
    }
}

