/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.variable;

import com.atlassian.bamboo.util.BambooIterables;
import com.atlassian.bamboo.utils.BambooCollectors;
import com.atlassian.bamboo.variable.VariableDefinition;
import com.atlassian.bamboo.variable.VariableDefinitionContext;
import com.atlassian.bamboo.variable.VariableDefinitionIdentifier;
import com.atlassian.bamboo.variable.VariableFunctions;
import com.atlassian.bamboo.variable.VariableUsage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class VariableUtils {
    private static final Pattern VARIABLE_USAGE_PATTERN = Pattern.compile("\\$\\{([a-z]+)\\.([^\\$\\{\\}]+)\\}");

    private VariableUtils() {
    }

    public static Map<String, VariableDefinitionContext> identifiersToContextMap(@NotNull Iterable<? extends VariableDefinitionIdentifier> ids) {
        return (Map)BambooIterables.stream(ids).map(arg_0 -> VariableFunctions.definitionFromIdentifier().apply(arg_0)).collect(BambooCollectors.toMap(VariableDefinitionContext::getKey));
    }

    public static boolean containsVariableUsage(@NotNull String text) {
        return VARIABLE_USAGE_PATTERN.matcher(text).find();
    }

    @NotNull
    public static List<VariableUsage> findVariableUsages(@NotNull String text) {
        Matcher matcher = VARIABLE_USAGE_PATTERN.matcher(text);
        ArrayList<VariableUsage> result = new ArrayList<VariableUsage>();
        while (matcher.find()) {
            result.add(new VariableUsage(matcher.group(1), matcher.group(2)));
        }
        return result;
    }

    public static Map<String, VariableDefinition> buildVariableDefinitionMap(Collection<? extends VariableDefinition> variableDefinitions) {
        return variableDefinitions.stream().collect(Collectors.toMap(VariableDefinitionContext::getKey, Function.identity()));
    }
}

