/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.variable;

import com.atlassian.bamboo.crypto.instance.SecretEncryptionService;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.variable.EncryptedVariableDefinitionAccessor;
import com.atlassian.bamboo.variable.VariableDefinition;
import com.atlassian.bamboo.variable.VariableType;
import com.atlassian.bamboo.variable.VariableValidationService;
import com.atlassian.struts.ValidationAware;
import com.opensymphony.xwork2.TextProvider;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VariableValidationServiceImpl
implements VariableValidationService {
    private static final Logger log = Logger.getLogger(VariableValidationServiceImpl.class);
    private static final Set<VariableType> ALLOWED_PLAN_VARIABLE_TYPES = EnumSet.of(VariableType.PLAN, VariableType.JOB);
    private static final Pattern VALID_KEY_PATTERN = Pattern.compile("[a-z0-9_\\.]+", 2);
    private final SecretEncryptionService secretEncryptionService;
    private final TextProvider textProvider;
    private final EncryptedVariableDefinitionAccessor variableDefinitionAccessor;

    public VariableValidationServiceImpl(SecretEncryptionService secretEncryptionService, TextProvider textProvider, EncryptedVariableDefinitionAccessor variableDefinitionAccessor) {
        this.secretEncryptionService = secretEncryptionService;
        this.textProvider = textProvider;
        this.variableDefinitionAccessor = variableDefinitionAccessor;
    }

    public void validateIdForGlobalVariable(@NotNull ValidationAware validationAware, long variableId) {
        if (variableId < 0L) {
            validationAware.addActionError(this.textProvider.getText("variables.error.id.notFound", new String[]{Long.toString(variableId)}));
        } else {
            VariableDefinition variableDefinition = this.variableDefinitionAccessor.findVariableDefinition(variableId);
            if (variableDefinition == null || variableDefinition.getVariableType() != VariableType.GLOBAL) {
                validationAware.addActionError(this.textProvider.getText("variables.error.id.notFound", new String[]{Long.toString(variableId)}));
            }
        }
    }

    public void validateIdForPlanVariable(@NotNull ValidationAware validationAware, long variableId, @NotNull ImmutablePlan expectedPlan) {
        if (variableId < 0L) {
            validationAware.addActionError(this.textProvider.getText("variables.error.id.notFound", new String[]{Long.toString(variableId)}));
        } else {
            VariableDefinition variableDefinition = this.variableDefinitionAccessor.findVariableDefinition(variableId);
            if (variableDefinition == null || !ALLOWED_PLAN_VARIABLE_TYPES.contains(variableDefinition.getVariableType()) || !expectedPlan.equals(variableDefinition.getPlan())) {
                validationAware.addActionError(this.textProvider.getText("variables.error.id.notFound", new String[]{Long.toString(variableId)}));
            }
        }
    }

    public void validateIdForDeploymentEnvironmentVariable(@NotNull ValidationAware validationAware, long variableId, long environmentId) {
        if (variableId < 0L) {
            validationAware.addActionError(this.textProvider.getText("variables.error.id.notFound", new String[]{Long.toString(variableId)}));
        } else {
            VariableDefinition variableDefinition = this.variableDefinitionAccessor.findVariableDefinition(variableId);
            if (variableDefinition == null || variableDefinition.getVariableType() != VariableType.ENVIRONMENT || !Objects.equals(environmentId, variableDefinition.getEnvironmentId())) {
                validationAware.addActionError(this.textProvider.getText("variables.error.id.notFound", new String[]{Long.toString(variableId)}));
            }
        }
    }

    public void validateKey(@NotNull ValidationAware validationAware, @NotNull String fieldName, @Nullable String variableKey) {
        if (StringUtils.isEmpty((CharSequence)variableKey)) {
            validationAware.addFieldError(fieldName, this.textProvider.getText("variables.error.key.required"));
        } else if (!VALID_KEY_PATTERN.matcher(variableKey).matches()) {
            validationAware.addFieldError(fieldName, this.textProvider.getText("variables.error.key.alpha"));
        } else if ((long)StringUtils.length((CharSequence)variableKey) > 255L) {
            validationAware.addFieldError(fieldName, this.textProvider.getText("variables.key.length.exceeds.maximum"));
        }
    }

    public void validateValueForVariable(@NotNull ValidationAware validationAware, @NotNull String fieldName, @Nullable String variableValue) {
        if ((long)StringUtils.length((CharSequence)variableValue) > 4000L) {
            validationAware.addFieldError(fieldName, this.textProvider.getText("variables.value.length.exceeds.maximum"));
        }
    }

    public void validateValueForEncryptedVariable(@NotNull ValidationAware validationAware, @NotNull String fieldName, @Nullable String variableValue) {
        this.validateValueForVariable(validationAware, fieldName, variableValue);
        if (StringUtils.isNotEmpty((CharSequence)variableValue) && this.secretEncryptionService.isEncrypted(variableValue)) {
            try {
                this.secretEncryptionService.decrypt(variableValue);
            }
            catch (Exception e) {
                validationAware.addFieldError(fieldName, this.textProvider.getText("variables.value.incorrect.encrypted.value"));
            }
        }
    }
}

