/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.variable.baseline;

import com.atlassian.bamboo.collections.message.FinalArrayList;
import com.atlassian.bamboo.collections.message.FinalHashSet;
import com.atlassian.bamboo.core.BambooEntityObject;
import com.atlassian.bamboo.security.classlist.WhitelistAssumeRuntimeType;
import com.atlassian.bamboo.security.classlist.WhitelistAssumeRuntimeTypes;
import com.atlassian.bamboo.variable.VariableDefinitionIdentifier;
import com.atlassian.bamboo.variable.VariableHashCodeProvider;
import com.atlassian.bamboo.variable.baseline.VariableBaselineItem;
import com.atlassian.bamboo.variable.baseline.VariableBaselineItemImpl;
import com.atlassian.bamboo.variable.baseline.VariableContextBaseline;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.UnmodifiableListIterator;
import java.util.Set;
import java.util.function.Predicate;
import javax.persistence.Entity;
import javax.persistence.Table;
import org.hibernate.annotations.GenericGenerator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Entity
@Table(name="VARIABLE_CONTEXT_BASELINE")
@GenericGenerator(name="ImportAwareGenerator", strategy="com.atlassian.bamboo.persistence.ImportAwareGenerator")
public class VariableContextBaselineImpl
extends BambooEntityObject
implements VariableContextBaseline {
    @WhitelistAssumeRuntimeTypes(value={@WhitelistAssumeRuntimeType(value=FinalHashSet.class), @WhitelistAssumeRuntimeType(value=VariableBaselineItemImpl.class)})
    private Set<VariableBaselineItem> variables = new FinalHashSet();
    private String hash;

    protected void initVariables(FinalArrayList<VariableBaselineItem> variables) {
        this.variables = new FinalHashSet(variables);
        for (VariableBaselineItem item : variables) {
            item.setOwningBaseline((VariableContextBaseline)this);
        }
        this.hash = VariableHashCodeProvider.calculateVariableSetSha((Iterable<? extends VariableDefinitionIdentifier>)VariableDefinitionIdentifier.ORDERING.immutableSortedCopy(variables));
    }

    @Nullable
    public VariableBaselineItem findByKey(String key) {
        return this.variables.stream().filter(variableBaselineItem -> variableBaselineItem.getKey().equals(key)).findFirst().orElse(null);
    }

    public static Predicate<VariableContextBaselineImpl> sameBaseline(@NotNull VariableContextBaselineImpl originalBaseline) {
        return that -> {
            if (that == null) {
                return false;
            }
            if (originalBaseline == that) {
                return true;
            }
            if (!originalBaseline.getHash().equals(that.getHash())) {
                return false;
            }
            UnmodifiableListIterator e1 = originalBaseline.getVariables().listIterator();
            UnmodifiableListIterator e2 = that.getVariables().listIterator();
            while (e1.hasNext() && e2.hasNext()) {
                if (VariableDefinitionIdentifier.ORDERING.compare(e1.next(), e2.next()) == 0) continue;
                return false;
            }
            return !e1.hasNext() && !e2.hasNext();
        };
    }

    public ImmutableList<VariableBaselineItem> getVariables() {
        return VariableDefinitionIdentifier.ORDERING.immutableSortedCopy(this.variables);
    }

    public String getHash() {
        return this.hash;
    }

    protected void setHash(String hash) {
        this.hash = hash;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof VariableContextBaselineImpl) || !super.equals(o)) {
            return false;
        }
        return VariableContextBaselineImpl.sameBaseline(this).test((VariableContextBaselineImpl)((Object)o));
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.hash != null ? this.hash.hashCode() : 0);
        return result;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("hash", (Object)this.hash).toString();
    }
}

