/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.variable.substitutor;

import com.atlassian.bamboo.variable.substitutor.VariableNode;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;

class NestedVariableCycleFinder {
    NestedVariableCycleFinder() {
    }

    public static CycleResult containsCycle(Collection<VariableNode> nodes) {
        boolean removedSingleNode;
        ArrayList remainingNodes = Lists.newArrayList(nodes);
        Collections.sort(remainingNodes);
        HashSet<VariableNode> alreadyRemoved = new HashSet<VariableNode>();
        do {
            removedSingleNode = false;
            Iterator iterator = remainingNodes.iterator();
            while (iterator.hasNext()) {
                VariableNode node = (VariableNode)iterator.next();
                if (!alreadyRemoved.containsAll(node.getDependsOn())) continue;
                iterator.remove();
                alreadyRemoved.add(node);
                removedSingleNode = true;
            }
        } while (removedSingleNode);
        return remainingNodes.isEmpty() ? CycleResult.noCycle() : CycleResult.cycle(remainingNodes);
    }

    public static class CycleResult {
        private final boolean containsCycle;
        private final Collection<VariableNode> cycle;

        private CycleResult(boolean containsCycle, Collection<VariableNode> cycle) {
            this.containsCycle = containsCycle;
            this.cycle = cycle;
        }

        public static CycleResult noCycle() {
            return new CycleResult(false, Collections.emptyList());
        }

        public static CycleResult cycle(Collection<VariableNode> cycle) {
            return new CycleResult(true, (Collection<VariableNode>)ImmutableList.copyOf(cycle));
        }

        public boolean containsCycle() {
            return this.containsCycle;
        }

        public Collection<VariableNode> getCycle() {
            return this.cycle;
        }
    }
}

