/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.variable.substitutor;

import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.utils.Pair;
import com.atlassian.bamboo.variable.VariableDefinitionContext;
import com.atlassian.bamboo.variable.substitutor.NestedVariableCycleFinder;
import com.atlassian.bamboo.variable.substitutor.VariableNode;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NestedVariableResolver {
    private static final Pattern VARIABLE_SUBSTITUTE_PATTERN = Pattern.compile("\\$\\{bamboo\\.(.*?)}", 2);

    public static Map<String, VariableDefinitionContext> resolveVariables(@NotNull Map<String, VariableDefinitionContext> originalVariables, @Nullable BuildLogger buildLogger) {
        Map<String, VariableNode> graph = NestedVariableResolver.createNodes(originalVariables);
        Multimap<String, VariableNode> variablesRequiringSubstitution = NestedVariableResolver.findDependencies(graph, originalVariables, buildLogger);
        variablesRequiringSubstitution.keySet().stream().map(graph::get).forEach(node -> variablesRequiringSubstitution.get((Object)node.getOriginalVariable().getKey()).forEach(node::dependsOn));
        NestedVariableCycleFinder.CycleResult cycleResult = NestedVariableCycleFinder.containsCycle(graph.values());
        if (cycleResult.containsCycle()) {
            NestedVariableResolver.throwCycleDetectedException(cycleResult.getCycle());
        }
        return NestedVariableResolver.resolveVariablesWithoutCycles(graph.values());
    }

    private static Map<String, VariableDefinitionContext> resolveVariablesWithoutCycles(Collection<VariableNode> nodes) {
        HashMap<String, VariableDefinitionContext> result = new HashMap<String, VariableDefinitionContext>();
        ArrayList remainingNodes = Lists.newArrayList(nodes);
        do {
            Iterator iterator = remainingNodes.iterator();
            while (iterator.hasNext()) {
                VariableNode node = (VariableNode)iterator.next();
                if (!node.getDependsOn().stream().allMatch(n -> result.containsKey(n.getKey()))) continue;
                node.resolve();
                iterator.remove();
                result.put(node.getKey(), node.getResolvedVariable());
            }
        } while (!remainingNodes.isEmpty());
        return result;
    }

    private static Multimap<String, VariableNode> findDependencies(Map<String, VariableNode> graph, Map<String, VariableDefinitionContext> originalVariables, BuildLogger buildLogger) {
        ArrayListMultimap variablesRequiringSubstitution = ArrayListMultimap.create();
        Predicate<Pair<String, String>> ignoreNotExistingReferencesPredicate = NestedVariableResolver.getIgnoreNotExistingReferencesPredicate(originalVariables, buildLogger);
        originalVariables.values().stream().filter(variableDefinition -> StringUtils.isNotBlank((CharSequence)variableDefinition.getValue())).map(variableDefinition -> Pair.make((Object)variableDefinition.getKey(), (Object)VARIABLE_SUBSTITUTE_PATTERN.matcher(variableDefinition.getValue()))).flatMap(keyMatcherPair -> {
            Matcher matcher = (Matcher)keyMatcherPair.getSecond();
            HashSet<Pair> foundGroups = new HashSet<Pair>();
            while (matcher.find()) {
                String group = matcher.group(1);
                foundGroups.add(Pair.make((Object)keyMatcherPair.getFirst(), (Object)group));
            }
            return foundGroups.stream();
        }).filter(ignoreNotExistingReferencesPredicate).map(keyValuePair -> Pair.make((Object)keyValuePair.getFirst(), originalVariables.get(keyValuePair.getSecond()))).map(keyVariablePair -> Pair.make((Object)keyVariablePair.getFirst(), graph.get(((VariableDefinitionContext)keyVariablePair.getSecond()).getKey()))).forEach(arg_0 -> NestedVariableResolver.lambda$findDependencies$7((Multimap)variablesRequiringSubstitution, arg_0));
        return variablesRequiringSubstitution;
    }

    private static Predicate<Pair<String, String>> getIgnoreNotExistingReferencesPredicate(Map<String, VariableDefinitionContext> originalVariables, BuildLogger buildLogger) {
        return buildLogger == null ? keyValuePair -> originalVariables.containsKey(keyValuePair.getSecond()) : keyValuePair -> {
            boolean variableExists = originalVariables.containsKey(keyValuePair.getSecond());
            if (!variableExists) {
                buildLogger.addErrorLogEntry(String.format("Variable '%s' references '%s' which doesn't exist. Can't resolve it.", keyValuePair.getFirst(), keyValuePair.getSecond()));
            }
            return variableExists;
        };
    }

    private static Map<String, VariableNode> createNodes(Map<String, VariableDefinitionContext> originalVariables) {
        return originalVariables.values().stream().collect(Collectors.toMap(VariableDefinitionContext::getKey, VariableNode::new));
    }

    private static void throwCycleDetectedException(Collection<VariableNode> potentialCycle) {
        String cycle = potentialCycle.stream().map(VariableNode::getOriginalVariable).map(VariableDefinitionContext::getKey).collect(Collectors.joining(" -> "));
        throw new IllegalArgumentException(String.format("Can't reference nested variables, found cycle in references %s", cycle));
    }

    private static /* synthetic */ void lambda$findDependencies$7(Multimap variablesRequiringSubstitution, Pair keyNodePair) {
        variablesRequiringSubstitution.put(keyNodePair.getFirst(), keyNodePair.getSecond());
    }
}

