/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.variable.substitutor;

import com.atlassian.bamboo.variable.SubstitutedVariableDefinitionContextImpl;
import com.atlassian.bamboo.variable.VariableDefinitionContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

class VariableNode
implements Comparable<VariableNode> {
    private final Set<VariableNode> dependsOn = new HashSet<VariableNode>();
    private final String key;
    private final VariableDefinitionContext originalVariable;
    private VariableDefinitionContext resolvedVariable;

    public VariableNode(VariableDefinitionContext originalVariable) {
        this.originalVariable = originalVariable;
        this.key = originalVariable.getKey();
    }

    public boolean isResolved() {
        return !this.hasReferences() || this.hasReferences() && this.resolvedVariable != null;
    }

    public void resolve() {
        if (this.isResolved()) {
            return;
        }
        ArrayList<String> keysToReplace = new ArrayList<String>();
        HashMap<String, VariableDefinitionContext> valuesToReplaceWith = new HashMap<String, VariableDefinitionContext>();
        for (VariableNode node : this.dependsOn) {
            node.resolve();
            keysToReplace.add(node.key);
            valuesToReplaceWith.put(node.key, node.getResolvedVariable());
        }
        this.resolvedVariable = new SubstitutedVariableDefinitionContextImpl(this.originalVariable, keysToReplace, valuesToReplaceWith);
    }

    public void dependsOn(VariableNode node) {
        this.dependsOn.add(node);
    }

    public boolean hasReferences() {
        return !this.dependsOn.isEmpty();
    }

    public VariableDefinitionContext getOriginalVariable() {
        return this.originalVariable;
    }

    public VariableDefinitionContext getResolvedVariable() {
        return this.hasReferences() ? this.resolvedVariable : this.originalVariable;
    }

    public String getKey() {
        return this.key;
    }

    public Set<VariableNode> getDependsOn() {
        return this.dependsOn;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VariableNode node = (VariableNode)o;
        return Objects.equals(this.key, node.key);
    }

    public int hashCode() {
        return Objects.hash(this.key);
    }

    public String toString() {
        return "key='" + this.key + '\'' + ", dependsOn=" + this.dependsOn.stream().map(VariableNode::getOriginalVariable).map(VariableDefinitionContext::getKey).collect(Collectors.toList());
    }

    @Override
    public int compareTo(@NotNull VariableNode that) {
        int myReferences = this.dependsOn.size();
        int thatReferences = that.dependsOn.size();
        return myReferences - thatReferences;
    }
}

