/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.variable.substitutor;

import com.atlassian.bamboo.build.BuildLoggerManager;
import com.atlassian.bamboo.build.fileserver.BuildDirectoryManager;
import com.atlassian.bamboo.configuration.AdministrationConfigurationAccessor;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.utils.BambooUrl;
import com.atlassian.bamboo.v2.build.CommonContext;
import com.atlassian.bamboo.v2.build.agent.capability.AgentContext;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilityContext;
import com.atlassian.bamboo.variable.CustomVariableContextImpl;
import com.atlassian.bamboo.variable.VariableDefinitionContext;
import com.atlassian.bamboo.variable.VariableDefinitionManager;
import com.atlassian.bamboo.variable.substitutor.VariableSubstitutor;
import com.atlassian.bamboo.variable.substitutor.VariableSubstitutorFactory;
import com.atlassian.bamboo.variable.substitutor.VariableSubstitutorImpl;
import com.atlassian.bamboo.vcs.module.VcsRepositoryManager;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class VariableSubstitutorFactoryImpl
implements VariableSubstitutorFactory {
    private static final Logger log = Logger.getLogger(VariableSubstitutorFactoryImpl.class);
    private BuildLoggerManager buildLoggerManager;
    private CapabilityContext capabilityContext;
    private AgentContext agentContext;
    private BuildDirectoryManager buildDirectoryManager;
    private BambooUrl bambooUrl;
    private VariableDefinitionManager variableDefinitionManager;
    private VcsRepositoryManager vcsRepositoryManager;

    @NotNull
    public VariableSubstitutor newSubstitutorForGlobalContext() {
        return new VariableSubstitutorImpl(this.buildLoggerManager, this.capabilityContext, this.agentContext, this.buildDirectoryManager, this.bambooUrl, this.variableDefinitionManager, this.vcsRepositoryManager);
    }

    @NotNull
    public VariableSubstitutor newSubstitutorForPlan(@NotNull ImmutablePlan plan) {
        if (this.variableDefinitionManager == null) {
            throw new UnsupportedOperationException("Can't create context for plan if server side managers are not present. Are you running this on remote agent?");
        }
        return new VariableSubstitutorImpl(plan, this.buildLoggerManager, this.capabilityContext, this.agentContext, this.buildDirectoryManager, this.bambooUrl, this.variableDefinitionManager, this.vcsRepositoryManager);
    }

    @NotNull
    public VariableSubstitutor newSubstitutorForCommonContext(@NotNull CommonContext commonContext) {
        CustomVariableContextImpl customVariableContext = new CustomVariableContextImpl(this);
        return new VariableSubstitutorImpl(commonContext, this.buildLoggerManager, this.capabilityContext, this.agentContext, this.buildDirectoryManager, this.bambooUrl, customVariableContext, this.vcsRepositoryManager);
    }

    @NotNull
    public VariableSubstitutor newSubstitutorForVariables(@NotNull Map<String, VariableDefinitionContext> variablesContextMap) {
        return new VariableSubstitutorImpl(variablesContextMap, this.buildLoggerManager, this.capabilityContext, this.agentContext, this.buildDirectoryManager, this.bambooUrl, this.vcsRepositoryManager);
    }

    public void setBuildLoggerManager(BuildLoggerManager buildLoggerManager) {
        this.buildLoggerManager = buildLoggerManager;
    }

    public void setCapabilityContext(CapabilityContext capabilityContext) {
        this.capabilityContext = capabilityContext;
    }

    public void setAdministrationConfigurationAccessor(AdministrationConfigurationAccessor administrationConfigurationAccessor) {
        this.bambooUrl = new BambooUrl(administrationConfigurationAccessor);
    }

    public void setAgentContext(AgentContext agentContext) {
        this.agentContext = agentContext;
    }

    public void setBuildDirectoryManager(BuildDirectoryManager buildDirectoryManager) {
        this.buildDirectoryManager = buildDirectoryManager;
    }

    public void setVariableDefinitionManager(VariableDefinitionManager variableDefinitionManager) {
        this.variableDefinitionManager = variableDefinitionManager;
    }

    public void setVcsRepositoryManager(VcsRepositoryManager vcsRepositoryManager) {
        this.vcsRepositoryManager = vcsRepositoryManager;
    }
}

