/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.variable.substitutor;

import com.atlassian.bamboo.build.BuildLoggerManager;
import com.atlassian.bamboo.build.CommandLogEntry;
import com.atlassian.bamboo.build.LogEntry;
import com.atlassian.bamboo.build.fileserver.BuildDirectoryManager;
import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.deployments.execution.DeploymentContext;
import com.atlassian.bamboo.plan.PlanResultKey;
import com.atlassian.bamboo.plan.artifact.ArtifactContext;
import com.atlassian.bamboo.plan.artifact.ArtifactSubscriptionContext;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.resultsummary.tests.TestQuarantineHelper;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.util.PasswordMaskingUtils;
import com.atlassian.bamboo.utils.BambooUrl;
import com.atlassian.bamboo.utils.SystemProperty;
import com.atlassian.bamboo.v2.build.BuildContext;
import com.atlassian.bamboo.v2.build.CommonContext;
import com.atlassian.bamboo.v2.build.agent.ExecutableBuildAgent;
import com.atlassian.bamboo.v2.build.agent.capability.AgentContext;
import com.atlassian.bamboo.v2.build.agent.capability.Capability;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilityContext;
import com.atlassian.bamboo.v2.build.agent.capability.ReadOnlyCapabilitySet;
import com.atlassian.bamboo.v2.build.trigger.ManualBuildTriggerReason;
import com.atlassian.bamboo.variable.BuiltInVariableHelper;
import com.atlassian.bamboo.variable.CustomVariableContext;
import com.atlassian.bamboo.variable.VariableContext;
import com.atlassian.bamboo.variable.VariableContextImpl;
import com.atlassian.bamboo.variable.VariableDefinitionContext;
import com.atlassian.bamboo.variable.VariableDefinitionManager;
import com.atlassian.bamboo.variable.VariableSubstitutionContext;
import com.atlassian.bamboo.variable.VariableSubstitutionContextImpl;
import com.atlassian.bamboo.variable.VariableType;
import com.atlassian.bamboo.variable.substitutor.NestedVariableResolver;
import com.atlassian.bamboo.variable.substitutor.VariableSubstitutor;
import com.atlassian.bamboo.vcs.module.VcsRepositoryManager;
import com.google.common.collect.Maps;
import io.atlassian.util.concurrent.Lazy;
import io.atlassian.util.concurrent.Suppliers;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@NotThreadSafe
public class VariableSubstitutorImpl
implements VariableSubstitutor {
    private static final Logger log = Logger.getLogger(VariableSubstitutorImpl.class);
    private static final Pattern VARIABLE_PATTERN = Pattern.compile("\\$\\{([a-z]+)\\.([^\\$\\{\\}]+)\\}");
    private static final String BAMBOO_PREFIX = "bamboo.";
    @NotNull
    private final Supplier<VariableContext> variableContext;
    @Nullable
    private final CommonContext currentContext;
    @NotNull
    private final Map<String, VariableSubstitutionContext> substitutedVariables = new HashMap<String, VariableSubstitutionContext>();
    @NotNull
    private final Map<String, VariableDefinitionContext> buildInRepositoryVariables = new HashMap<String, VariableDefinitionContext>();
    @NotNull
    private final Map<String, VariableDefinitionContext> automaticVariables = new HashMap<String, VariableDefinitionContext>();
    private final BuildLoggerManager buildLoggerManager;
    private final CapabilityContext capabilityContext;
    private final AgentContext agentContext;
    private final BuildDirectoryManager buildDirectoryManager;
    private final VcsRepositoryManager vcsRepositoryManager;
    private final BambooUrl bambooUrl;

    protected VariableSubstitutorImpl(@NotNull BuildLoggerManager buildLoggerManager, @Nullable CapabilityContext capabilityContext, @NotNull AgentContext agentContext, @NotNull BuildDirectoryManager buildDirectoryManager, @NotNull BambooUrl bambooUrl, @Nullable VariableDefinitionManager variableDefinitionManager, @NotNull VcsRepositoryManager vcsRepositoryManager) {
        this.buildLoggerManager = buildLoggerManager;
        this.capabilityContext = capabilityContext;
        this.agentContext = agentContext;
        this.buildDirectoryManager = buildDirectoryManager;
        this.vcsRepositoryManager = vcsRepositoryManager;
        this.bambooUrl = bambooUrl;
        this.variableContext = Lazy.supplier(this.createContextWithGlobalVariables(variableDefinitionManager));
        this.currentContext = null;
    }

    protected VariableSubstitutorImpl(@NotNull ImmutablePlan immutablePlan, @NotNull BuildLoggerManager buildLoggerManager, @Nullable CapabilityContext capabilityContext, @NotNull AgentContext agentContext, @NotNull BuildDirectoryManager buildDirectoryManager, @NotNull BambooUrl bambooUrl, @NotNull VariableDefinitionManager variableDefinitionManager, @NotNull VcsRepositoryManager vcsRepositoryManager) {
        this.buildLoggerManager = buildLoggerManager;
        this.capabilityContext = capabilityContext;
        this.agentContext = agentContext;
        this.buildDirectoryManager = buildDirectoryManager;
        this.vcsRepositoryManager = vcsRepositoryManager;
        this.bambooUrl = bambooUrl;
        this.currentContext = null;
        this.variableContext = Lazy.supplier(() -> variableDefinitionManager.createVariableContextBuilder().addGlobalVariables().addPlanVariables(immutablePlan).buildContext());
    }

    protected VariableSubstitutorImpl(@NotNull CommonContext commonContext, @NotNull BuildLoggerManager buildLoggerManager, @Nullable CapabilityContext capabilityContext, @NotNull AgentContext agentContext, @NotNull BuildDirectoryManager buildDirectoryManager, @NotNull BambooUrl bambooUrl, @NotNull CustomVariableContext customVariableContext, @NotNull VcsRepositoryManager vcsRepositoryManager) {
        this.buildLoggerManager = buildLoggerManager;
        this.capabilityContext = capabilityContext;
        this.agentContext = agentContext;
        this.buildDirectoryManager = buildDirectoryManager;
        this.vcsRepositoryManager = vcsRepositoryManager;
        this.bambooUrl = bambooUrl;
        this.currentContext = commonContext;
        this.variableContext = Suppliers.memoize((Object)commonContext.getVariableContext());
        this.generateVariablesForContext(customVariableContext);
    }

    protected VariableSubstitutorImpl(@NotNull Map<String, VariableDefinitionContext> variablesContextMap, @NotNull BuildLoggerManager buildLoggerManager, @Nullable CapabilityContext capabilityContext, @NotNull AgentContext agentContext, @NotNull BuildDirectoryManager buildDirectoryManager, @NotNull BambooUrl bambooUrl, @NotNull VcsRepositoryManager vcsRepositoryManager) {
        this.buildLoggerManager = buildLoggerManager;
        this.capabilityContext = capabilityContext;
        this.agentContext = agentContext;
        this.buildDirectoryManager = buildDirectoryManager;
        this.vcsRepositoryManager = vcsRepositoryManager;
        this.bambooUrl = bambooUrl;
        this.currentContext = null;
        this.variableContext = Suppliers.memoize((Object)new VariableContextImpl(variablesContextMap));
    }

    @Nullable
    public String substituteString(@Nullable String value) {
        return this.substituteBambooVariables(value);
    }

    public Map<String, VariableSubstitutionContext> getSubstitutedVariables() {
        return this.substitutedVariables;
    }

    @NotNull
    public String removeAllVariables(@NotNull String value) {
        Set<String> variables = this.findAllVariables(value);
        HashMap<String, VariableDefinitionContext> variableSubstitutionMap = new HashMap<String, VariableDefinitionContext>();
        for (String variable : variables) {
            BuiltInVariableHelper.addVariableContext(variableSubstitutionMap, variable, "", VariableType.UNKNOWN);
        }
        return this.substituteVariables(value, null, variableSubstitutionMap);
    }

    @NotNull
    public Set<String> findAllVariables(@Nullable String variable) {
        HashSet<String> variables = new HashSet<String>();
        if (variable != null) {
            Matcher matcher = VARIABLE_PATTERN.matcher(variable);
            while (matcher.find()) {
                String variableNamespace = matcher.group(1);
                String variableField = matcher.group(2);
                if (!variableNamespace.equals("bamboo") && !variableNamespace.equals("system")) continue;
                variables.add(variableField);
            }
        }
        return variables;
    }

    public void addLocalVariable(@NotNull String key, @NotNull String value) {
        this.variableContext.get().addLocalVariable(key, value);
    }

    @NotNull
    public Map<String, VariableDefinitionContext> getVariableContexts() {
        return this.filterVariableContextByName(null);
    }

    public Map<String, VariableDefinitionContext> getBuiltInRepositoryVariablesIfBuildContext() {
        return this.buildInRepositoryVariables;
    }

    @Contract(value="null -> null")
    @Nullable
    private String substituteBambooVariables(@Nullable String stringWithValuesToSubstitute) {
        Set<String> variables = this.findAllVariables(stringWithValuesToSubstitute);
        if (variables.isEmpty()) {
            return stringWithValuesToSubstitute;
        }
        Map<String, VariableDefinitionContext> variableMap = this.filterVariableContextByName(variables);
        return this.substituteVariables(stringWithValuesToSubstitute, this.getBuildLogger(), variableMap);
    }

    @Contract(value="null, _, _ -> null")
    private String substituteVariables(@Nullable String command, @Nullable BuildLogger buildLogger, @NotNull Map<String, VariableDefinitionContext> variableSourceMap) {
        if (command == null) {
            return null;
        }
        String substitutedCommand = command;
        Matcher matcher = VARIABLE_PATTERN.matcher(command);
        while (matcher.find()) {
            SystemProperty property;
            String variable = matcher.group(0);
            String variableNamespace = matcher.group(1);
            String variableField = matcher.group(2);
            String variableValue = null;
            if (variableNamespace.equals("bamboo")) {
                if (variableSourceMap.containsKey(variableField)) {
                    VariableDefinitionContext variableDefinitionContext = variableSourceMap.get(variableField);
                    variableValue = variableDefinitionContext.getValue();
                    this.getSubstitutedVariables().put(variableField, new VariableSubstitutionContextImpl(variableField, variableValue, variableDefinitionContext.getVariableType()));
                }
            } else if (variableNamespace.equals("system") && (property = new SystemProperty(true, new String[]{variableField})).exists()) {
                variableValue = property.getValue();
                this.getSubstitutedVariables().put(variableField, new VariableSubstitutionContextImpl(variableField, variableValue, VariableType.SYSTEM));
            }
            if (variableValue == null) continue;
            substitutedCommand = StringUtils.replaceOnce((String)substitutedCommand, (String)variable, variableValue);
            this.logSubstitute(variable, variableValue, buildLogger);
        }
        return substitutedCommand;
    }

    private void generateVariablesForContext(CustomVariableContext customVariableContext) {
        BuildContext buildContext = (BuildContext)Narrow.downTo((Object)this.currentContext, BuildContext.class);
        this.automaticVariables.putAll(this.getCommonBuildVariables(buildContext));
        this.automaticVariables.putAll(this.getCommonVariables(this.currentContext));
        this.automaticVariables.putAll(this.getDeploymentVariables(this.currentContext));
        if (buildContext != null) {
            customVariableContext.withVariableSubstitutor((VariableSubstitutor)new VariableSubstitutorImpl(this.variableContext.get().getEffectiveVariables(), this.buildLoggerManager, this.capabilityContext, this.agentContext, this.buildDirectoryManager, this.bambooUrl, this.vcsRepositoryManager), () -> BuiltInVariableHelper.createRepositoryVariables(this.buildInRepositoryVariables, buildContext.getVcsRepositories(), buildContext.getBuildChanges(), VariableType.CUSTOM, this.vcsRepositoryManager));
        }
        this.automaticVariables.putAll(this.buildInRepositoryVariables);
    }

    @NotNull
    private Map<String, VariableDefinitionContext> filterVariableContextByName(@Nullable Set<String> variableNames) {
        LinkedHashMap<String, VariableDefinitionContext> variables = new LinkedHashMap<String, VariableDefinitionContext>(this.variableContext.get().getEffectiveVariables());
        variables.putAll(this.automaticVariables);
        variables.putAll(this.getVariablesForCapabilityContext());
        variables.putAll(this.getVariablesForBuildContext(this.currentContext));
        variables.putAll(this.getVariablesForSubscriptionsContext(this.currentContext));
        this.addAgentVariables(this.currentContext, variables);
        Map<String, VariableDefinitionContext> replacedVariables = NestedVariableResolver.resolveVariables(variables, this.getBuildLogger());
        return variableNames != null ? this.getResults(replacedVariables, variableNames) : replacedVariables;
    }

    private Map<String, VariableDefinitionContext> getVariablesForBuildContext(@Nullable CommonContext commonContext) {
        if (commonContext == null) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, VariableDefinitionContext> variables = new LinkedHashMap<String, VariableDefinitionContext>();
        BuildContext buildContext = (BuildContext)Narrow.downTo((Object)commonContext, BuildContext.class);
        if (buildContext != null && buildContext.getParentBuildContext() != null) {
            for (Map.Entry entry : buildContext.getParentBuildContext().getCurrentResult().getCustomBuildData().entrySet()) {
                BuiltInVariableHelper.addVariableContext(variables, (String)entry.getKey(), (String)entry.getValue(), VariableType.CUSTOM);
            }
        }
        for (Map.Entry entry : commonContext.getCurrentResult().getCustomBuildData().entrySet()) {
            BuiltInVariableHelper.addVariableContext(variables, (String)entry.getKey(), (String)entry.getValue(), VariableType.CUSTOM);
        }
        TestQuarantineHelper.remove(variables);
        return Collections.unmodifiableMap(variables);
    }

    private Map<String, VariableDefinitionContext> getVariablesForSubscriptionsContext(@Nullable CommonContext commonContext) {
        BuildContext buildContext = (BuildContext)Narrow.downTo((Object)commonContext, BuildContext.class);
        if (buildContext != null) {
            HashMap<String, VariableDefinitionContext> map = new HashMap<String, VariableDefinitionContext>();
            ArtifactContext artifactContext = buildContext.getArtifactContext();
            Collection subscriptions = artifactContext.getSubscriptionContexts();
            for (ArtifactSubscriptionContext subscription : subscriptions) {
                String key = StringUtils.removeStart((String)subscription.getVariableName(), (String)BAMBOO_PREFIX);
                String value = subscription.isSingleFile() ? subscription.getEffectiveDestinationPath() : subscription.getDestinationPath();
                BuiltInVariableHelper.addVariableContext(map, key, value, VariableType.CUSTOM);
            }
            return Collections.unmodifiableMap(map);
        }
        return Collections.emptyMap();
    }

    private Map<String, VariableDefinitionContext> getVariablesForCapabilityContext() {
        if (this.capabilityContext != null) {
            LinkedHashMap<String, VariableDefinitionContext> variables = new LinkedHashMap<String, VariableDefinitionContext>();
            ReadOnlyCapabilitySet capabilitySet = this.capabilityContext.getCapabilitySet();
            if (capabilitySet != null) {
                Set capabilities = capabilitySet.getCapabilities();
                for (Capability capability : capabilities) {
                    String substitutionKey = "capability." + capability.getKey();
                    String substitutionValue = capability.getValueWithDefault();
                    BuiltInVariableHelper.addVariableContext(variables, substitutionKey, substitutionValue, VariableType.CUSTOM);
                }
            }
            return variables;
        }
        return Collections.emptyMap();
    }

    private void addAgentVariables(@NotNull CommonContext commonContext, @NotNull Map<String, VariableDefinitionContext> variables) {
        ExecutableBuildAgent buildAgent;
        if (commonContext != null && this.agentContext != null && (buildAgent = this.agentContext.getBuildAgent()) != null) {
            BuiltInVariableHelper.addVariableContext(variables, "agentId", Long.toString(buildAgent.getId()), VariableType.CUSTOM);
            File agentWorkingDirectory = this.buildDirectoryManager.getWorkingDirectoryOfCurrentAgent();
            if (agentWorkingDirectory != null) {
                BuiltInVariableHelper.addVariableContext(variables, "agentWorkingDirectory", agentWorkingDirectory.getAbsolutePath(), VariableType.CUSTOM);
            }
        }
    }

    private Map<String, VariableDefinitionContext> getCommonVariables(@Nullable CommonContext commonContext) {
        ManualBuildTriggerReason manualBuildTriggerReason;
        LinkedHashMap<String, VariableDefinitionContext> variables = new LinkedHashMap<String, VariableDefinitionContext>();
        if (commonContext != null && (manualBuildTriggerReason = (ManualBuildTriggerReason)((Object)Narrow.to((Object)commonContext.getTriggerReason(), ManualBuildTriggerReason.class))) != null) {
            BuiltInVariableHelper.addVariableContext(variables, "ManualBuildTriggerReason.userName", manualBuildTriggerReason.getUserName(), VariableType.CUSTOM);
        }
        return variables;
    }

    @NotNull
    private Map<String, VariableDefinitionContext> getDeploymentVariables(@Nullable CommonContext commonContext) {
        LinkedHashMap<String, VariableDefinitionContext> variables = new LinkedHashMap<String, VariableDefinitionContext>();
        DeploymentContext deploymentContext = (DeploymentContext)Narrow.downTo((Object)commonContext, DeploymentContext.class);
        if (deploymentContext != null) {
            BuiltInVariableHelper.addVariableContext(variables, "deploy.project", deploymentContext.getDeploymentProjectName(), VariableType.CUSTOM);
            BuiltInVariableHelper.addVariableContext(variables, "deploy.environment", deploymentContext.getEnvironmentName(), VariableType.CUSTOM);
            BuiltInVariableHelper.addVariableContext(variables, "deploy.version", deploymentContext.getDeploymentVersion().getName(), VariableType.CUSTOM);
            BuiltInVariableHelper.addVariableContext(variables, "deploy.version.previous", deploymentContext.getPreviousVersionName(), VariableType.CUSTOM);
            BuiltInVariableHelper.addVariableContext(variables, "deploy.release", deploymentContext.getDeploymentVersion().getName(), VariableType.CUSTOM);
            BuiltInVariableHelper.addVariableContext(variables, "deploy.release.previous", deploymentContext.getPreviousVersionName(), VariableType.CUSTOM);
            BuiltInVariableHelper.addVariableContext(variables, "deploy.rollback", Boolean.toString(deploymentContext.isRollback()), VariableType.CUSTOM);
            String resultsUrl = this.bambooUrl.withBaseUrlFromConfiguration("/deploy/viewDeploymentResult.action?deploymentResultId=" + deploymentContext.getDeploymentResultId());
            BuiltInVariableHelper.addVariableContext(variables, "resultsUrl", resultsUrl, VariableType.CUSTOM);
        }
        return variables;
    }

    @NotNull
    private Map<String, VariableDefinitionContext> getCommonBuildVariables(@Nullable BuildContext buildContext) {
        LinkedHashMap<String, VariableDefinitionContext> variables = new LinkedHashMap<String, VariableDefinitionContext>();
        if (buildContext != null) {
            String parentShortName;
            PlanResultKey planResultKey = buildContext.getPlanResultKey();
            if (buildContext.getParentBuildContext() != null) {
                if (buildContext.getParentBuildContext().isBranch()) {
                    String planBranchName = buildContext.getParentBuildContext().getShortName();
                    String projectName = buildContext.getParentBuildContext().getProjectName();
                    String fullPlanName = buildContext.getParentBuildContext().getPlanName();
                    int delimiterLength = " - ".length();
                    parentShortName = fullPlanName.substring(projectName.length() + delimiterLength, fullPlanName.length() - (planBranchName.length() + delimiterLength));
                } else {
                    parentShortName = buildContext.getParentBuildContext().getShortName();
                }
            } else {
                parentShortName = null;
            }
            String planFullyQualifiedName = buildContext.getPlanName();
            String jobShortName = buildContext.getShortName();
            BuildContext parentBuildContext = buildContext.getParentBuildContext();
            PlanResultKey parentResultKey = null;
            String parentPlanName = null;
            if (parentBuildContext != null) {
                parentResultKey = parentBuildContext.getPlanResultKey();
                parentPlanName = parentBuildContext.getPlanName();
            }
            this.addVariables(variables, planResultKey, planFullyQualifiedName, jobShortName, parentResultKey, parentPlanName, parentShortName);
        }
        return variables;
    }

    private void addVariables(@NotNull Map<String, VariableDefinitionContext> variables, @NotNull PlanResultKey planResultKey, @NotNull String planFullyQualifiedName, @NotNull String planShortName, @Nullable PlanResultKey parentResultKey, @Nullable String parentPlanName, @Nullable String parentPlanShortName) {
        if (parentResultKey != null) {
            BuiltInVariableHelper.addVariableContext(variables, "planKey", parentResultKey.getPlanKey().toString(), VariableType.CUSTOM);
            BuiltInVariableHelper.addVariableContext(variables, "shortPlanKey", parentResultKey.getPlanKey().getPartialKey(), VariableType.CUSTOM);
        }
        BuiltInVariableHelper.addVariableContext(variables, "planName", parentPlanName, VariableType.CUSTOM);
        BuiltInVariableHelper.addVariableContext(variables, "buildNumber", Integer.toString(planResultKey.getBuildNumber()), VariableType.CUSTOM);
        BuiltInVariableHelper.addVariableContext(variables, "buildKey", planResultKey.getPlanKey().toString(), VariableType.CUSTOM);
        BuiltInVariableHelper.addVariableContext(variables, "buildPlanName", planFullyQualifiedName, VariableType.CUSTOM);
        BuiltInVariableHelper.addVariableContext(variables, "buildResultKey", planResultKey.getKey(), VariableType.CUSTOM);
        BuiltInVariableHelper.addVariableContext(variables, "shortPlanName", parentPlanShortName, VariableType.CUSTOM);
        BuiltInVariableHelper.addVariableContext(variables, "shortJobKey", planResultKey.getPlanKey().getPartialKey(), VariableType.CUSTOM);
        BuiltInVariableHelper.addVariableContext(variables, "shortJobName", planShortName, VariableType.CUSTOM);
        String resultsUrl = this.bambooUrl.withBaseUrlFromConfiguration("/browse/" + planResultKey.toString());
        BuiltInVariableHelper.addVariableContext(variables, "buildResultsUrl", resultsUrl, VariableType.CUSTOM);
        BuiltInVariableHelper.addVariableContext(variables, "resultsUrl", resultsUrl, VariableType.CUSTOM);
    }

    @NotNull
    private Map<String, VariableDefinitionContext> getResults(@NotNull Map<String, VariableDefinitionContext> variables, @NotNull Collection<String> variableNames) {
        if (!variableNames.isEmpty()) {
            return Maps.filterKeys(variables, variableNames::contains);
        }
        return variables;
    }

    private void logSubstitute(String variable, String value, @Nullable BuildLogger buildLogger) {
        if (buildLogger != null) {
            CommandLogEntry logEntry = PasswordMaskingUtils.shouldBeMasked((String)variable) ? new CommandLogEntry("Substituting password variable: " + variable) : new CommandLogEntry("Substituting variable: " + variable + " with " + value);
            log.debug((Object)buildLogger.addBuildLogEntry((LogEntry)logEntry));
        }
    }

    private Supplier<VariableContext> createContextWithGlobalVariables(@Nullable VariableDefinitionManager variableDefinitionManager) {
        return () -> variableDefinitionManager != null ? variableDefinitionManager.createVariableContextBuilder().addGlobalVariables().buildContext() : new VariableContextImpl(Collections.emptyMap());
    }

    @Nullable
    private BuildLogger getBuildLogger() {
        BuildLogger buildLogger = null;
        if (this.currentContext != null) {
            buildLogger = this.buildLoggerManager.getLogger(this.currentContext.getResultKey());
        }
        return buildLogger;
    }
}

