/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.variable.upgrade;

import com.atlassian.bamboo.plan.PlanResultKey;
import com.atlassian.bamboo.resultsummary.ResultsSummaryManager;
import com.atlassian.bamboo.resultsummary.variables.ResultsSummaryVariableAccessor;
import com.atlassian.bamboo.utils.SystemProperty;
import com.atlassian.bamboo.variable.upgrade.VariableContextUpgradeScheduler;
import java.util.List;
import javax.inject.Inject;
import org.apache.log4j.Logger;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class VariableContextUpgradeJob
implements Job {
    private static final Logger log = Logger.getLogger(VariableContextUpgradeScheduler.class);
    protected static final int VALID_FORMAT_VERSION_FOR_VARIABLES = 5706;
    @Inject
    private ResultsSummaryManager resultsSummaryManager;
    @Inject
    private ResultsSummaryVariableAccessor resultsSummaryVariableAccessor;
    @Inject
    private VariableContextUpgradeScheduler variableContextUpgradeScheduler;

    public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        List oldFormatResultsFound;
        int maxResults = (int)SystemProperty.VARIABLE_UPGRADE_BATCH_SIZE.getTypedValue();
        if (maxResults <= 0) {
            maxResults = 300;
        }
        if ((oldFormatResultsFound = this.resultsSummaryManager.findChainResultsWithFormatVersionLessThan(5706, maxResults)).isEmpty()) {
            log.info((Object)"No more results that require variable context update. Removing job from schedule");
            this.variableContextUpgradeScheduler.destroySchedule();
            return;
        }
        log.info((Object)("Updating variable context for " + oldFormatResultsFound.size() + " results..."));
        for (PlanResultKey planResultKey : oldFormatResultsFound) {
            this.resultsSummaryVariableAccessor.upgradeVariableDataIfNeeded(planResultKey);
        }
        log.info((Object)("Updating variable context for " + oldFormatResultsFound.size() + " results completed"));
    }
}

