/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.variable.upgrade;

import com.atlassian.bamboo.quartz.PreventJobExecutionUntilCompletedTriggerListener;
import com.atlassian.bamboo.resultsummary.ResultsSummaryManager;
import com.atlassian.bamboo.schedule.BambooScheduler;
import com.atlassian.bamboo.utils.SystemProperty;
import com.atlassian.bamboo.variable.upgrade.VariableContextUpgradeJob;
import java.text.ParseException;
import org.apache.log4j.Logger;
import org.quartz.CronExpression;
import org.quartz.CronScheduleBuilder;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.Matcher;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;
import org.quartz.impl.matchers.KeyMatcher;
import org.quartz.utils.Key;

public class VariableContextUpgradeScheduler
implements BambooScheduler {
    private static final Logger log = Logger.getLogger(VariableContextUpgradeScheduler.class);
    private static final String JOB_NAME = "Variable context upgrade";
    private static final String JOB_GROUP = "Variable context upgrade";
    private static final TriggerKey TRIGGER_KEY = new TriggerKey("Variable context upgrade", "Variable context upgrade");
    private static final JobKey JOB_KEY = new JobKey("Variable context upgrade", "Variable context upgrade");
    private static final String DEFAULT_CRON = "0 0 4 ? * *";
    private final Scheduler quartzScheduler;
    private ResultsSummaryManager resultsSummaryManager;

    public VariableContextUpgradeScheduler(Scheduler quartzScheduler, ResultsSummaryManager resultsSummaryManager) {
        this.quartzScheduler = quartzScheduler;
        this.resultsSummaryManager = resultsSummaryManager;
    }

    public void initialiseSchedule() {
        try {
            Trigger trigger = this.quartzScheduler.getTrigger(TRIGGER_KEY);
            if (trigger != null && trigger.mayFireAgain()) {
                return;
            }
            if (SystemProperty.VARIABLE_UPGRADE_BATCH_SIZE.getTypedValue() <= 0L) {
                log.info((Object)"Variable context upgrade job not scheduled: disabled by system property");
                return;
            }
            if (this.resultsSummaryManager.findChainResultsWithFormatVersionLessThan(5706, 1).isEmpty()) {
                log.info((Object)"Variable context upgrade job not scheduled: no data to upgrade");
                return;
            }
            JobDetail jobDetail = JobBuilder.newJob(VariableContextUpgradeJob.class).withIdentity(JOB_KEY).build();
            Trigger trigger2 = TriggerBuilder.newTrigger().withIdentity(TRIGGER_KEY).withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((CronExpression)new CronExpression(SystemProperty.VARIABLE_UPGRADE_SCHEDULE_CRON.getValue(DEFAULT_CRON)))).build();
            this.quartzScheduler.getListenerManager().addTriggerListener(PreventJobExecutionUntilCompletedTriggerListener.INSTANCE, (Matcher)KeyMatcher.keyEquals((Key)trigger2.getKey()));
            this.quartzScheduler.scheduleJob(jobDetail, trigger2);
            log.info((Object)String.format("Variable context upgrade job running according to cron: %s", SystemProperty.VARIABLE_UPGRADE_SCHEDULE_CRON.getValue(DEFAULT_CRON)));
        }
        catch (ParseException | SchedulerException e) {
            log.error((Object)"Unable to schedule Variable context upgrade", e);
        }
    }

    public void destroySchedule() {
        try {
            this.quartzScheduler.deleteJob(JOB_KEY);
        }
        catch (SchedulerException e) {
            log.error((Object)"Unable to remove job Variable context upgrade", (Throwable)e);
        }
    }
}

