/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.vcs;

import com.google.common.collect.ImmutableMap;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.UUID;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnalyticsUtils {
    public static final String NULL_UUID = UUID.nameUUIDFromBytes("null".getBytes()).toString();
    public static final Map<String, String> SUPPORTED_REPOSITORIES_KEYS_TO_TYPE = new ImmutableMap.Builder().put((Object)"com.atlassian.bamboo.plugin.system.repository:cvs", (Object)"cvs").put((Object)"com.atlassian.bamboo.plugin.system.repository:svn", (Object)"svn").put((Object)"com.atlassian.bamboo.plugin.system.repository:svnv2", (Object)"svn").put((Object)"com.atlassian.bamboo.plugin.system.repository:p4", (Object)"perforce").put((Object)"com.atlassian.bamboo.plugins.atlassian-bamboo-plugin-git:git", (Object)"git").put((Object)"com.atlassian.bamboo.plugins.atlassian-bamboo-plugin-git:gitv2", (Object)"git").put((Object)"com.atlassian.bamboo.plugins.atlassian-bamboo-plugin-git:gh", (Object)"github").put((Object)"com.atlassian.bamboo.plugins.atlassian-bamboo-plugin-mercurial:mercurial", (Object)"mercurial").put((Object)"com.atlassian.bamboo.plugins.stash.atlassian-bamboo-plugin-stash:stash-rep", (Object)"bitbucket.server").put((Object)"com.atlassian.bamboo.plugins.stash.atlassian-bamboo-plugin-stash:bbserver", (Object)"bitbucket.server").put((Object)"com.atlassian.bamboo.plugins.atlassian-bamboo-plugin-bitbucket:bb", (Object)"bitbucket.cloud").put((Object)"com.atlassian.bamboo.plugins.atlassian-bamboo-plugin-bitbucket:bbCloud", (Object)"bitbucket.cloud").build();

    @Nullable
    @Contract(value="null -> null; !null -> !null")
    public static Object mapToBooleanIfApplicable(@Nullable String value) {
        return value == null ? null : (AnalyticsUtils.looksLikeBoolean(value) ? Boolean.valueOf(Boolean.parseBoolean(value.trim())) : value);
    }

    @NotNull
    @Contract(value="null -> !null")
    public static String anonymizeFreeText(@Nullable String value) {
        return value == null ? NULL_UUID : UUID.nameUUIDFromBytes(value.getBytes(StandardCharsets.UTF_8)).toString();
    }

    private static boolean looksLikeBoolean(String value) {
        return value.trim().equalsIgnoreCase("true") || value.trim().equalsIgnoreCase("false");
    }
}

