/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.vcs;

import com.atlassian.bamboo.event.ChainStartedEvent;
import com.atlassian.bamboo.event.analytics.VcsRepositoryBuildStartedAnalyticsEvent;
import com.atlassian.bamboo.vcs.AnalyticsUtils;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.jetbrains.annotations.NotNull;

public class VcsRepositoryAnalytics {
    @Inject
    private EventPublisher eventPublisher;
    @VisibleForTesting
    public static final Set<String> WHITELISTED_REPOSITORIES_KEYS = ImmutableSet.of((Object)"com.atlassian.bamboo.plugin.system.repository:p4", (Object)"com.atlassian.bamboo.plugin.system.repository:cvs", (Object)"com.atlassian.bamboo.plugin.system.repository:svn", (Object)"com.atlassian.bamboo.plugins.atlassian-bamboo-plugin-git:git", (Object)"com.atlassian.bamboo.plugins.atlassian-bamboo-plugin-git:gh", (Object)"com.atlassian.bamboo.plugins.atlassian-bamboo-plugin-mercurial:hg", (Object[])new String[]{"com.atlassian.bamboo.plugins.stash.atlassian-bamboo-plugin-stash:stash-rep", "com.atlassian.bamboo.plugins.atlassian-bamboo-plugin-bitbucket:bb", "com.atlassian.bamboo.plugins.atlassian-bamboo-plugin-bitbucket:bbCloud", "com.atlassian.bamboo.plugin.system.repository:svnv2", "com.atlassian.bamboo.plugins.atlassian-bamboo-plugin-git:gitv2", "com.atlassian.bamboo.plugins.stash.atlassian-bamboo-plugin-stash:bbserver", "com.codicesoftware.plugins.bamboo40.bamboo-plasticscm-plugin:plasticscm", "com.luxoft.bamboo.plugins.accurev:accurev", "com.stellarity.bamboo.tfs-repository-plugin:tfs"});
    @VisibleForTesting
    public static final Map<String, Set<String>> WHITELISTED_REPOSITORY_PROPERTIES = ImmutableMap.of((Object)"com.atlassian.bamboo.plugins.atlassian-bamboo-plugin-git:git", (Object)ImmutableSet.of((Object)"repository.git.lfs"), (Object)"com.atlassian.bamboo.plugins.atlassian-bamboo-plugin-git:gitv2", (Object)ImmutableSet.of((Object)"repository.git.lfs"), (Object)"com.atlassian.bamboo.plugins.atlassian-bamboo-plugin-bitbucket:bbCloud", (Object)ImmutableSet.of((Object)"repository.bitbucket.git.lfs"), (Object)"com.atlassian.bamboo.plugins.stash.atlassian-bamboo-plugin-stash:bbserver", (Object)ImmutableSet.of((Object)"repository.stash.lfs"));
    @VisibleForTesting
    public static final String UNKNOWN_REPOSITORY_KEY_VALUE = "other";

    @EventListener
    public void onChainStarted(@NotNull ChainStartedEvent event) {
        event.getBuildContext().getVcsRepositories().forEach(vcsRepository -> this.eventPublisher.publish((Object)new VcsRepositoryBuildStartedAnalyticsEvent(this.filterPluginKey(vcsRepository.getPluginKey()), this.filterConfiguration(vcsRepository.getPluginKey(), vcsRepository.getVcsLocation().getConfiguration()))));
    }

    @NotNull
    private String filterPluginKey(@NotNull String key) {
        return WHITELISTED_REPOSITORIES_KEYS.contains(key) ? key : UNKNOWN_REPOSITORY_KEY_VALUE;
    }

    @NotNull
    private Map<String, Object> filterConfiguration(@NotNull String pluginKey, @NotNull Map<String, String> configuration) {
        Set allowedConfigKeys = WHITELISTED_REPOSITORY_PROPERTIES.getOrDefault(pluginKey, Collections.emptySet());
        return configuration.entrySet().stream().filter(entry -> allowedConfigKeys.contains(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, entry -> AnalyticsUtils.mapToBooleanIfApplicable((String)entry.getValue())));
    }
}

