/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.vcs.configuration;

import com.atlassian.bamboo.collections.message.FinalHashMap;
import com.atlassian.bamboo.vcs.configuration.VcsChangeDetectionOptions;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChangeDetectionSourceDefinitionImpl
implements VcsChangeDetectionOptions {
    private final boolean quietPeriodEnabled;
    private final int quietPeriod;
    private final int maxRetries;
    private final boolean commitIsolationEnabled;
    private final String changesetFilterPatternRegex;
    private final String filterFilePatternOption;
    private final String filterFilePatternRegex;
    private final FinalHashMap<String, String> configuration;

    public ChangeDetectionSourceDefinitionImpl(@NotNull Map<String, String> configuration) {
        this.configuration = FinalHashMap.copyWithNoNullValues(configuration);
        this.quietPeriodEnabled = Boolean.valueOf((String)StringUtils.defaultIfBlank((CharSequence)configuration.get("repository.common.quietPeriod.enabled"), (CharSequence)"false"));
        this.quietPeriod = Integer.valueOf((String)StringUtils.defaultIfBlank((CharSequence)configuration.get("repository.common.quietPeriod.period"), (CharSequence)"10"));
        this.maxRetries = Integer.valueOf((String)StringUtils.defaultIfBlank((CharSequence)configuration.get("repository.common.quietPeriod.maxRetries"), (CharSequence)"5"));
        this.changesetFilterPatternRegex = configuration.get("changeset.filter.pattern.regex");
        this.filterFilePatternOption = configuration.get("filter.pattern.option");
        this.filterFilePatternRegex = configuration.get("filter.pattern.regex");
        this.commitIsolationEnabled = Boolean.valueOf(configuration.get("commit.isolation.option"));
    }

    public ChangeDetectionSourceDefinitionImpl(VcsChangeDetectionOptions vcsChangeDetectionOptions) {
        this.configuration = FinalHashMap.copyWithNoNullValues((Map)vcsChangeDetectionOptions.getConfiguration());
        this.quietPeriod = vcsChangeDetectionOptions.getQuietPeriod();
        this.quietPeriodEnabled = vcsChangeDetectionOptions.isQuietPeriodEnabled();
        this.changesetFilterPatternRegex = vcsChangeDetectionOptions.getChangesetFilterPatternRegex();
        this.maxRetries = vcsChangeDetectionOptions.getMaxRetries();
        this.filterFilePatternOption = vcsChangeDetectionOptions.getFilterFilePatternOption();
        this.filterFilePatternRegex = vcsChangeDetectionOptions.getFilterFilePatternRegex();
        this.commitIsolationEnabled = vcsChangeDetectionOptions.isCommitIsolationEnabled();
    }

    public boolean isQuietPeriodEnabled() {
        return this.quietPeriodEnabled;
    }

    public int getQuietPeriod() {
        return this.quietPeriod;
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }

    public boolean isCommitIsolationEnabled() {
        return this.commitIsolationEnabled;
    }

    @Nullable
    public String getChangesetFilterPatternRegex() {
        return this.changesetFilterPatternRegex;
    }

    @NotNull
    public Map<String, String> getConfiguration() {
        return this.configuration;
    }

    @Nullable
    public String getFilterFilePatternOption() {
        return this.filterFilePatternOption;
    }

    @Nullable
    public String getFilterFilePatternRegex() {
        return this.filterFilePatternRegex;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChangeDetectionSourceDefinitionImpl that = (ChangeDetectionSourceDefinitionImpl)o;
        return new EqualsBuilder().append(this.configuration, that.configuration).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append(this.configuration).toHashCode();
    }
}

