/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.vcs.configuration;

import com.atlassian.bamboo.core.BambooEntityOid;
import com.atlassian.bamboo.repository.RepositoryData;
import com.atlassian.bamboo.vcs.configuration.PartialVcsRepositoryData;
import com.atlassian.bamboo.vcs.configuration.VcsBambooSpecsDetectionOptions;
import com.atlassian.bamboo.vcs.configuration.VcsBranchDefinition;
import com.atlassian.bamboo.vcs.configuration.VcsBranchDetectionOptions;
import com.atlassian.bamboo.vcs.configuration.VcsChangeDetectionOptions;
import com.atlassian.bamboo.vcs.configuration.VcsLocationDefinition;
import com.atlassian.bamboo.vcs.configuration.VcsRepositoryData;
import com.atlassian.bamboo.vcs.viewer.configuration.VcsRepositoryViewerDefinition;
import com.google.common.base.Preconditions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompleteVcsRepositoryData
implements VcsRepositoryData {
    private final VcsRepositoryData inheritedData;
    private final PartialVcsRepositoryData overrides;

    public CompleteVcsRepositoryData(@Nullable VcsRepositoryData inheritedData, @NotNull PartialVcsRepositoryData overrides) {
        this.inheritedData = inheritedData;
        this.overrides = overrides;
        Preconditions.checkState((inheritedData != null || overrides.overridesLocation() ? 1 : 0) != 0, (Object)"Invalid repository object no server data");
        Preconditions.checkNotNull((Object)this.getVcsLocation(), (Object)"Invalid repository object no server data");
    }

    @NotNull
    public String getPluginKey() {
        return this.overrides.getPluginKey();
    }

    @NotNull
    public VcsLocationDefinition getVcsLocation() {
        if (this.overrides.overridesLocation()) {
            return this.overrides.getVcsLocation();
        }
        return this.inheritedData.getVcsLocation();
    }

    @NotNull
    public VcsBranchDefinition getBranch() {
        if (this.inheritedData != null && !this.overrides.overridesBranch()) {
            return this.inheritedData.getBranch();
        }
        return this.overrides.getBranch();
    }

    @NotNull
    public VcsChangeDetectionOptions getVcsChangeDetectionOptions() {
        if (this.inheritedData != null && !this.overrides.overridesChangeDetectionOptions()) {
            return this.inheritedData.getVcsChangeDetectionOptions();
        }
        return this.overrides.getVcsChangeDetectionOptions();
    }

    @Nullable
    public VcsBranchDetectionOptions getVcsBranchDetectionOptions() {
        if (this.inheritedData != null && !this.overrides.overridesBranchDetectionOptions()) {
            return this.inheritedData.getVcsBranchDetectionOptions();
        }
        return this.overrides.getVcsBranchDetectionOptions();
    }

    @Nullable
    public VcsBambooSpecsDetectionOptions getBambooSpecsDetectionOptions() {
        if (this.inheritedData != null) {
            return this.inheritedData.getBambooSpecsDetectionOptions();
        }
        return this.overrides.getBambooSpecsConfiguration();
    }

    @Nullable
    public VcsRepositoryViewerDefinition getViewerConfiguration() {
        if (this.inheritedData != null && !this.overrides.overridesLocation()) {
            return this.inheritedData.getViewerConfiguration();
        }
        return this.overrides.getViewerConfiguration();
    }

    public boolean isMarkedForDeletion() {
        return this.overrides.isMarkedForDeletion();
    }

    public boolean isLinked() {
        return this.overrides.isLinked();
    }

    public boolean isRootVcsLinked() {
        return this.overrides.isRootVcsLinked();
    }

    public boolean isLegacyRepository() {
        if (this.inheritedData != null && !this.overrides.overridesLocation()) {
            return this.inheritedData.isLegacyRepository();
        }
        return this.overrides.isLegacyRepository();
    }

    @NotNull
    public RepositoryData asLegacyData() {
        if (this.inheritedData != null && !this.overrides.overridesLocation()) {
            return this.inheritedData.asLegacyData();
        }
        return this.overrides.asLegacyData();
    }

    public long getId() {
        return this.overrides.getId();
    }

    public BambooEntityOid getOid() {
        return this.overrides.getOid();
    }

    @NotNull
    public String getName() {
        return this.overrides.getName();
    }

    @Nullable
    public String getDescription() {
        return this.overrides.getDescription();
    }

    @Nullable
    public Long getParentId() {
        return this.overrides.getParentId();
    }

    @Nullable
    public BambooEntityOid getParentOid() {
        return this.overrides.getParentOid();
    }

    public long getRootVcsRepositoryId() {
        return this.overrides.getRootVcsRepositoryId();
    }
}

