/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.vcs.configuration;

import com.atlassian.bamboo.repository.LegacyRepositoryDataImpl;
import com.atlassian.bamboo.repository.LegacyRepositoryDefinitionImpl;
import com.atlassian.bamboo.repository.RepositoryConfigurationReference;
import com.atlassian.bamboo.repository.RepositoryData;
import com.atlassian.bamboo.spring.ComponentAccessor;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.vcs.configuration.PlanRepositoryDefinition;
import com.atlassian.bamboo.vcs.configuration.VcsLocationDefinition;
import com.atlassian.bamboo.vcs.configuration.VcsLocationDefinitionImpl;
import com.atlassian.bamboo.vcs.configuration.VcsRepositoryData;
import com.atlassian.bamboo.vcs.converter.Repository2VcsTypeConverter;
import com.atlassian.bamboo.vcs.module.VcsRepositoryManager;
import java.util.function.Supplier;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.jetbrains.annotations.NotNull;

class LegacyRepositoryDataSupplier
implements Supplier<RepositoryData> {
    private final VcsRepositoryData source;

    public LegacyRepositoryDataSupplier(@NotNull VcsRepositoryData repositoryData) {
        this.source = repositoryData;
    }

    @Override
    public RepositoryData get() {
        PlanRepositoryDefinition prd = (PlanRepositoryDefinition)Narrow.downTo((Object)this.source, PlanRepositoryDefinition.class);
        if (this.source.isLegacyRepository()) {
            VcsLocationDefinition vcsLocationDefinition = this.source.getVcsLocation();
            RepositoryConfigurationReference ref = ((VcsLocationDefinitionImpl)vcsLocationDefinition).getConfigurationRef();
            if (prd != null) {
                return new LegacyRepositoryDefinitionImpl(prd, ref);
            }
            return new LegacyRepositoryDataImpl(this.source, ref);
        }
        VcsRepositoryManager vcsRepositoryManager = (VcsRepositoryManager)ComponentAccessor.VCS_REPOSITORY_MANAGER.get();
        Repository2VcsTypeConverter reverseConverter = vcsRepositoryManager.findReverseConverterFor(this.source.getPluginKey());
        if (reverseConverter != null) {
            HierarchicalConfiguration configuration = reverseConverter.asLegacyData(this.source);
            RepositoryConfigurationReference configRef = new RepositoryConfigurationReference(configuration);
            if (prd != null) {
                return new LegacyRepositoryDefinitionImpl(prd, reverseConverter.acceptedRepositoryPluginKey(), configRef);
            }
            return new LegacyRepositoryDataImpl(this.source, reverseConverter.acceptedRepositoryPluginKey(), configRef);
        }
        throw new UnsupportedOperationException("Plugin " + this.source.getPluginKey() + " cannot be used through legacy API call");
    }
}

