/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.vcs.configuration;

import com.atlassian.bamboo.core.BambooEntityOid;
import com.atlassian.bamboo.plan.branch.VcsBranch;
import com.atlassian.bamboo.vcs.configuration.PartialVcsRepositoryData;
import com.atlassian.bamboo.vcs.configuration.PartialVcsRepositoryDataImpl;
import com.atlassian.bamboo.vcs.configuration.VcsRepositoryData;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PartialVcsRepositoryDataBuilder {
    private long id = -1L;
    private BambooEntityOid oid;
    private String pluginKey;
    private String name;
    private String description;
    private VcsBranch vcsBranch;
    private String viewerPluginKey;
    private Map<String, String> serverConfiguration;
    private Map<String, String> changeDetectionConfiguration;
    private Map<String, String> branchDetectionConfiguration;
    private Map<String, String> branchConfiguration;
    private Map<String, String> viewerConfiguration;
    private Map<String, String> bambooSpecsDetectionConfiguration;
    private String legacyXml;
    private String legacyViewerXml;
    private VcsRepositoryData inheritedData;
    private boolean linked;

    private PartialVcsRepositoryDataBuilder() {
    }

    public static PartialVcsRepositoryDataBuilder newBuilder() {
        return new PartialVcsRepositoryDataBuilder();
    }

    public PartialVcsRepositoryDataBuilder copyWithEmptyConfig(@Nullable PartialVcsRepositoryData other) {
        if (other != null) {
            this.id = other.getId();
            this.oid = other.getOid();
            this.name = other.getName();
            this.pluginKey = other.getPluginKey();
            this.description = other.getDescription();
            this.linked = other.isLinked();
            this.inheritedData = other.getInheritedData();
        }
        return this;
    }

    public PartialVcsRepositoryDataBuilder fullCopy(@NotNull PartialVcsRepositoryData other) {
        this.copyWithEmptyConfig(other);
        if (other.getVcsLocation() != null) {
            this.serverConfiguration = other.getVcsLocation().getConfiguration();
            this.legacyXml = other.getVcsLocation().getLegacyConfigurationXml();
        }
        if (other.getBranch() != null) {
            this.vcsBranch = other.getBranch().getVcsBranch();
            this.branchConfiguration = other.getBranch().getConfiguration();
        }
        if (other.getViewerConfiguration() != null) {
            this.legacyViewerXml = other.getViewerConfiguration().getLegacyConfigurationXml();
            this.viewerConfiguration = other.getViewerConfiguration().getConfiguration();
            this.viewerPluginKey = other.getViewerConfiguration().getPluginKey();
        }
        if (other.getVcsChangeDetectionOptions() != null) {
            this.changeDetectionConfiguration = other.getVcsChangeDetectionOptions().getConfiguration();
        }
        if (other.getVcsBranchDetectionOptions() != null) {
            this.branchDetectionConfiguration = other.getVcsBranchDetectionOptions().getConfiguration();
        }
        if (other.getBambooSpecsConfiguration() != null) {
            this.bambooSpecsDetectionConfiguration = other.getBambooSpecsConfiguration().getConfiguration();
        }
        return this;
    }

    public PartialVcsRepositoryDataBuilder name(String name) {
        this.name = name;
        return this;
    }

    public PartialVcsRepositoryDataBuilder oid(BambooEntityOid oid) {
        this.oid = oid;
        return this;
    }

    public PartialVcsRepositoryDataBuilder description(String description) {
        this.description = description;
        return this;
    }

    public PartialVcsRepositoryDataBuilder serverConfiguration(@Nullable Map<String, String> serverConfiguration) {
        this.serverConfiguration = serverConfiguration;
        return this;
    }

    public PartialVcsRepositoryDataBuilder changeDetectionConfiguration(@Nullable Map<String, String> changeDetectionConfiguration) {
        this.changeDetectionConfiguration = changeDetectionConfiguration;
        return this;
    }

    public PartialVcsRepositoryDataBuilder branchDetectionConfiguration(@Nullable Map<String, String> branchDetectionConfiguration) {
        this.branchDetectionConfiguration = branchDetectionConfiguration;
        return this;
    }

    public PartialVcsRepositoryDataBuilder bambooSpecsDetectionConfiguration(@Nullable Map<String, String> bambooSpecsDetectionConfiguration) {
        this.bambooSpecsDetectionConfiguration = bambooSpecsDetectionConfiguration;
        return this;
    }

    public PartialVcsRepositoryDataBuilder branchConfiguration(@Nullable Map<String, String> branchConfiguration) {
        this.branchConfiguration = branchConfiguration;
        return this;
    }

    public PartialVcsRepositoryDataBuilder vcsBranch(VcsBranch vcsBranch) {
        this.vcsBranch = vcsBranch;
        return this;
    }

    public PartialVcsRepositoryDataBuilder viewerPluginKey(String viewerPluginKey) {
        this.viewerPluginKey = viewerPluginKey;
        return this;
    }

    public PartialVcsRepositoryDataBuilder viewerConfiguration(Map<String, String> viewerConfiguration) {
        this.viewerConfiguration = viewerConfiguration;
        return this;
    }

    public PartialVcsRepositoryDataBuilder legacyXml(String legacyXml) {
        this.legacyXml = legacyXml;
        return this;
    }

    public PartialVcsRepositoryDataBuilder legacyViewerXml(String legacyXml) {
        this.legacyViewerXml = legacyXml;
        return this;
    }

    public PartialVcsRepositoryDataBuilder linked(boolean isLinked) {
        this.linked = isLinked;
        return this;
    }

    public PartialVcsRepositoryDataBuilder pluginKey(String pluginKey) {
        this.pluginKey = pluginKey;
        return this;
    }

    public PartialVcsRepositoryDataBuilder inheritedData(VcsRepositoryData inheritedData) {
        this.inheritedData = inheritedData;
        return this;
    }

    @Deprecated
    public String getLegacyXml() {
        return this.legacyXml;
    }

    @Deprecated
    public Map<String, String> getBranchConfiguration() {
        return this.branchConfiguration;
    }

    public PartialVcsRepositoryData build() {
        return new PartialVcsRepositoryDataImpl(this.id, this.oid, this.pluginKey, this.name, this.description, this.vcsBranch, this.viewerPluginKey, this.serverConfiguration, this.changeDetectionConfiguration, this.branchDetectionConfiguration, this.branchConfiguration, this.viewerConfiguration, this.bambooSpecsDetectionConfiguration, this.legacyXml, this.legacyViewerXml, this.linked, this.inheritedData);
    }

    public Map<String, String> getServerConfiguration() {
        return this.serverConfiguration;
    }
}

