/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.vcs.configuration;

import com.atlassian.bamboo.core.BambooEntityOid;
import com.atlassian.bamboo.plan.branch.VcsBranch;
import com.atlassian.bamboo.repository.LegacyRepositoryDataImpl;
import com.atlassian.bamboo.repository.RepositoryConfigurationReference;
import com.atlassian.bamboo.repository.RepositoryData;
import com.atlassian.bamboo.repository.RepositoryDataEntity;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.utils.BambooInterners;
import com.atlassian.bamboo.vcs.configuration.ChangeDetectionSourceDefinitionImpl;
import com.atlassian.bamboo.vcs.configuration.CompleteVcsRepositoryData;
import com.atlassian.bamboo.vcs.configuration.PartialVcsRepositoryData;
import com.atlassian.bamboo.vcs.configuration.VcsBambooSpecsDetectionOptions;
import com.atlassian.bamboo.vcs.configuration.VcsBambooSpecsDetectionOptionsImpl;
import com.atlassian.bamboo.vcs.configuration.VcsBranchDefinition;
import com.atlassian.bamboo.vcs.configuration.VcsBranchDefinitionImpl;
import com.atlassian.bamboo.vcs.configuration.VcsBranchDetectionOptions;
import com.atlassian.bamboo.vcs.configuration.VcsBranchDetectionOptionsImpl;
import com.atlassian.bamboo.vcs.configuration.VcsChangeDetectionOptions;
import com.atlassian.bamboo.vcs.configuration.VcsLocationDefinition;
import com.atlassian.bamboo.vcs.configuration.VcsLocationDefinitionImpl;
import com.atlassian.bamboo.vcs.configuration.VcsRepositoryData;
import com.atlassian.bamboo.vcs.configuration.legacy.configurator.LegacyBranchConfigurator;
import com.atlassian.bamboo.vcs.configuration.service.RawRepositoryConfiguration;
import com.atlassian.bamboo.vcs.configurator.VcsBranchConfigurator;
import com.atlassian.bamboo.vcs.viewer.configuration.VcsRepositoryViewerDefinition;
import com.atlassian.bamboo.vcs.viewer.configuration.VcsRepositoryViewerDefinitionImpl;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PartialVcsRepositoryDataImpl
implements PartialVcsRepositoryData {
    private final long id;
    private final BambooEntityOid oid;
    private final String pluginKey;
    private final String name;
    private final String description;
    private final boolean linked;
    private final boolean markedForDeletion;
    private final VcsLocationDefinition vcsLocationDefinition;
    private final VcsChangeDetectionOptions vcsChangeDetectionOptions;
    private final VcsBranchDetectionOptions vcsBranchDetectionOptions;
    private final VcsBranchDefinition vcsBranchDefinition;
    private final VcsRepositoryViewerDefinition vcsRepositoryViewerDefinition;
    private final VcsBambooSpecsDetectionOptions vcsBambooSpecsDetectionOptions;
    private transient Supplier<RepositoryData> legacyData;
    private final VcsRepositoryData inheritedData;

    private Supplier<RepositoryData> repositoryDataSupplier() {
        RepositoryConfigurationReference ref = ((VcsLocationDefinitionImpl)this.getCompleteData().getVcsLocation()).getConfigurationRef();
        if (ref != null) {
            return () -> new LegacyRepositoryDataImpl(this.getCompleteData(), ref);
        }
        return () -> {
            throw new UnsupportedOperationException("using new plugin in the old context is not supported yet");
        };
    }

    protected PartialVcsRepositoryDataImpl(long id, BambooEntityOid oid, String pluginKey, String name, String description, VcsBranch vcsBranch, String viewerPluginKey, Map<String, String> serverConfiguration, Map<String, String> changeDetectionConfiguration, Map<String, String> branchDetectionConfiguration, Map<String, String> branchConfiguration, Map<String, String> viewerConfiguration, Map<String, String> bambooSpecsDetectionConfiguration, String legacyXml, String legacyViewerXml, boolean linked, VcsRepositoryData inheritedData) {
        this.id = id;
        this.oid = oid;
        this.name = BambooInterners.intern((String)name);
        this.pluginKey = BambooInterners.moduleKey((String)pluginKey);
        this.description = BambooInterners.intern((String)description);
        this.linked = linked;
        this.markedForDeletion = false;
        this.vcsLocationDefinition = serverConfiguration != null || legacyXml != null ? new VcsLocationDefinitionImpl(serverConfiguration, legacyXml) : null;
        this.vcsBambooSpecsDetectionOptions = bambooSpecsDetectionConfiguration != null ? new VcsBambooSpecsDetectionOptionsImpl(bambooSpecsDetectionConfiguration) : null;
        this.vcsChangeDetectionOptions = changeDetectionConfiguration != null ? new ChangeDetectionSourceDefinitionImpl(changeDetectionConfiguration) : null;
        this.vcsBranchDetectionOptions = branchDetectionConfiguration != null ? new VcsBranchDetectionOptionsImpl(branchDetectionConfiguration) : null;
        this.vcsBranchDefinition = branchConfiguration != null ? new VcsBranchDefinitionImpl(branchConfiguration, vcsBranch) : null;
        this.vcsRepositoryViewerDefinition = viewerConfiguration != null && viewerPluginKey != null ? new VcsRepositoryViewerDefinitionImpl(viewerPluginKey, viewerConfiguration, legacyViewerXml) : null;
        this.inheritedData = inheritedData;
        this.legacyData = this.repositoryDataSupplier();
    }

    public PartialVcsRepositoryDataImpl(@NotNull RepositoryDataEntity repositoryData, @NotNull RawRepositoryConfiguration rawRepositoryConfiguration, @Nullable VcsRepositoryData inheritedData) {
        this.id = repositoryData.getId();
        this.oid = repositoryData.getOid();
        this.pluginKey = BambooInterners.moduleKey((String)repositoryData.getPluginKey());
        this.name = BambooInterners.intern((String)(inheritedData != null ? inheritedData.getName() : repositoryData.getName()));
        this.description = BambooInterners.intern((String)(inheritedData != null ? inheritedData.getDescription() : repositoryData.getDescription()));
        this.markedForDeletion = repositoryData.isMarkedForDeletion();
        this.linked = repositoryData.isGlobal();
        this.vcsLocationDefinition = rawRepositoryConfiguration.getServerConfiguration() != null || rawRepositoryConfiguration.getLegacyXml() != null ? new VcsLocationDefinitionImpl(rawRepositoryConfiguration.getServerConfiguration(), rawRepositoryConfiguration.getLegacyXml()) : null;
        this.vcsBambooSpecsDetectionOptions = rawRepositoryConfiguration.getBambooSpecsDetectionConfiguration() != null ? new VcsBambooSpecsDetectionOptionsImpl(rawRepositoryConfiguration.getBambooSpecsDetectionConfiguration()) : null;
        this.vcsChangeDetectionOptions = rawRepositoryConfiguration.getChangeDetectionConfiguration() != null ? new ChangeDetectionSourceDefinitionImpl(rawRepositoryConfiguration.getChangeDetectionConfiguration()) : null;
        this.vcsBranchDetectionOptions = rawRepositoryConfiguration.getBranchDetectionConfiguration() != null ? new VcsBranchDetectionOptionsImpl(rawRepositoryConfiguration.getBranchDetectionConfiguration()) : null;
        this.vcsBranchDefinition = rawRepositoryConfiguration.getBranchConfiguration() != null ? new VcsBranchDefinitionImpl(rawRepositoryConfiguration.getBranchConfiguration(), rawRepositoryConfiguration.getVcsBranch()) : null;
        this.vcsRepositoryViewerDefinition = rawRepositoryConfiguration.getViewerConfiguration() != null && rawRepositoryConfiguration.getViewerPluginKey() != null ? new VcsRepositoryViewerDefinitionImpl(rawRepositoryConfiguration.getViewerPluginKey(), rawRepositoryConfiguration.getViewerConfiguration(), rawRepositoryConfiguration.getLegacyViewerXml()) : null;
        this.inheritedData = inheritedData;
        this.legacyData = this.repositoryDataSupplier();
    }

    private PartialVcsRepositoryDataImpl(@NotNull VcsRepositoryData inheritedData) {
        this.id = -1L;
        this.oid = null;
        this.pluginKey = BambooInterners.moduleKey((String)inheritedData.getPluginKey());
        this.name = BambooInterners.intern((String)inheritedData.getName());
        this.description = BambooInterners.intern((String)inheritedData.getDescription());
        this.markedForDeletion = inheritedData.isMarkedForDeletion();
        this.linked = false;
        this.inheritedData = inheritedData;
        this.vcsLocationDefinition = null;
        this.vcsBranchDefinition = null;
        this.vcsChangeDetectionOptions = null;
        this.vcsBranchDetectionOptions = null;
        this.vcsRepositoryViewerDefinition = null;
        this.vcsBambooSpecsDetectionOptions = null;
    }

    private PartialVcsRepositoryDataImpl(@NotNull VcsRepositoryData other, VcsBranch newBranch, VcsBranchConfigurator vcsBranchConfigurator) {
        this.id = -1L;
        this.oid = null;
        this.pluginKey = BambooInterners.moduleKey((String)other.getPluginKey());
        this.name = BambooInterners.intern((String)other.getName());
        this.description = BambooInterners.intern((String)other.getDescription());
        this.markedForDeletion = other.isMarkedForDeletion();
        this.linked = false;
        this.vcsLocationDefinition = null;
        this.vcsRepositoryViewerDefinition = null;
        this.vcsChangeDetectionOptions = null;
        this.vcsBranchDetectionOptions = null;
        this.vcsBambooSpecsDetectionOptions = null;
        this.vcsBranchDefinition = new VcsBranchDefinitionImpl(other.getBranch().getConfiguration(), newBranch);
        vcsBranchConfigurator.setVcsBranchInConfig(this.vcsBranchDefinition.getConfiguration(), newBranch);
        this.inheritedData = other;
        this.legacyData = this.repositoryDataSupplier();
    }

    private PartialVcsRepositoryDataImpl(@NotNull VcsRepositoryData other, VcsBranch newBranch, LegacyBranchConfigurator legacyBranchConfigurator) {
        this.id = -1L;
        this.oid = null;
        this.pluginKey = BambooInterners.moduleKey((String)other.getPluginKey());
        this.name = BambooInterners.intern((String)other.getName());
        this.description = BambooInterners.intern((String)other.getDescription());
        this.markedForDeletion = other.isMarkedForDeletion();
        this.linked = false;
        this.vcsLocationDefinition = new VcsLocationDefinitionImpl(other.getVcsLocation(), legacyBranchConfigurator.getXmlStringWithNewVcsBranch(newBranch, other.asLegacyData().getConfiguration()));
        this.vcsChangeDetectionOptions = null;
        this.vcsBambooSpecsDetectionOptions = null;
        this.vcsBranchDetectionOptions = null;
        this.vcsBranchDefinition = new VcsBranchDefinitionImpl(new HashMap<String, String>(), newBranch);
        this.vcsRepositoryViewerDefinition = other.getViewerConfiguration() != null ? new VcsRepositoryViewerDefinitionImpl(other.getViewerConfiguration()) : null;
        this.legacyData = this.repositoryDataSupplier();
        this.inheritedData = other;
    }

    public static PartialVcsRepositoryDataImpl createChild(@NotNull VcsRepositoryData repositoryData) {
        return new PartialVcsRepositoryDataImpl(repositoryData);
    }

    public static PartialVcsRepositoryDataImpl createChildWithNewBranch(VcsRepositoryData repositoryDefinition, VcsBranch newBranch, VcsBranchConfigurator vcsBranchConfigurator) {
        LegacyBranchConfigurator legacyBranchConfigurator = (LegacyBranchConfigurator)Narrow.downTo((Object)vcsBranchConfigurator, LegacyBranchConfigurator.class);
        if (legacyBranchConfigurator != null) {
            return new PartialVcsRepositoryDataImpl(repositoryDefinition, newBranch, legacyBranchConfigurator);
        }
        return new PartialVcsRepositoryDataImpl(repositoryDefinition, newBranch, vcsBranchConfigurator);
    }

    @Nullable
    public VcsRepositoryData getInheritedData() {
        return this.inheritedData;
    }

    public boolean overridesLocation() {
        return this.getVcsLocation() != null;
    }

    public boolean overridesBranch() {
        return this.getBranch() != null;
    }

    public boolean overridesChangeDetectionOptions() {
        return this.getVcsChangeDetectionOptions() != null;
    }

    public boolean overridesBranchDetectionOptions() {
        return this.getVcsBranchDetectionOptions() != null;
    }

    public BambooEntityOid getOid() {
        return this.oid;
    }

    @NotNull
    public String getPluginKey() {
        return this.pluginKey;
    }

    @Nullable
    public VcsLocationDefinition getVcsLocation() {
        return this.vcsLocationDefinition;
    }

    @Nullable
    public VcsBranchDefinition getBranch() {
        return this.vcsBranchDefinition;
    }

    @Nullable
    public VcsChangeDetectionOptions getVcsChangeDetectionOptions() {
        return this.vcsChangeDetectionOptions;
    }

    @Nullable
    public VcsBranchDetectionOptions getVcsBranchDetectionOptions() {
        return this.vcsBranchDetectionOptions;
    }

    @Nullable
    public VcsBambooSpecsDetectionOptions getBambooSpecsConfiguration() {
        return this.vcsBambooSpecsDetectionOptions;
    }

    @Nullable
    public VcsRepositoryViewerDefinition getViewerConfiguration() {
        return this.vcsRepositoryViewerDefinition;
    }

    public boolean isMarkedForDeletion() {
        return this.markedForDeletion;
    }

    public boolean isLinked() {
        return this.linked;
    }

    public boolean isRootVcsLinked() {
        return this.linked || this.inheritedData != null && this.inheritedData.isRootVcsLinked();
    }

    public long getId() {
        return this.id;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    public boolean isLegacyRepository() {
        return this.vcsLocationDefinition.isLegacyRepository();
    }

    @NotNull
    public RepositoryData asLegacyData() {
        if (this.legacyData == null) {
            this.legacyData = this.repositoryDataSupplier();
        }
        return this.legacyData.get();
    }

    @NotNull
    public VcsRepositoryData getCompleteData() {
        return new CompleteVcsRepositoryData(this.inheritedData, this);
    }

    @Nullable
    public Long getParentId() {
        return this.inheritedData != null ? Long.valueOf(this.inheritedData.getId()) : null;
    }

    @Nullable
    public BambooEntityOid getParentOid() {
        return this.inheritedData != null ? this.inheritedData.getOid() : null;
    }

    public long getRootVcsRepositoryId() {
        return this.inheritedData != null ? this.inheritedData.getRootVcsRepositoryId() : this.id;
    }
}

