/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.vcs.configuration;

import com.atlassian.bamboo.collections.message.FinalHashMap;
import com.atlassian.bamboo.plan.branch.VcsBranch;
import com.atlassian.bamboo.plan.branch.VcsBranchImpl;
import com.atlassian.bamboo.vcs.configuration.VcsBranchDefinition;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class VcsBranchDefinitionImpl
implements VcsBranchDefinition {
    private final FinalHashMap<String, String> configuration;
    private final VcsBranch vcsBranch;

    public VcsBranchDefinitionImpl(@NotNull Map<String, String> configuration, @NotNull VcsBranch vcsBranch) {
        this.configuration = new FinalHashMap(configuration);
        this.vcsBranch = vcsBranch;
    }

    public VcsBranchDefinitionImpl(@NotNull VcsBranchDefinition branch) {
        this.configuration = new FinalHashMap(branch.getConfiguration());
        this.vcsBranch = new VcsBranchImpl(branch.getVcsBranch());
    }

    @NotNull
    public VcsBranch getVcsBranch() {
        return this.vcsBranch;
    }

    @NotNull
    public Map<String, String> getConfiguration() {
        return this.configuration;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VcsBranchDefinitionImpl that = (VcsBranchDefinitionImpl)o;
        if (this.configuration != null ? !this.configuration.equals(that.configuration) : that.configuration != null) {
            return false;
        }
        return !(this.vcsBranch != null ? !this.vcsBranch.equals(that.vcsBranch) : that.vcsBranch != null);
    }

    public int hashCode() {
        int result = this.configuration != null ? this.configuration.hashCode() : 0;
        result = 31 * result + (this.vcsBranch != null ? this.vcsBranch.hashCode() : 0);
        return result;
    }
}

