/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.vcs.configuration;

import com.atlassian.bamboo.collections.message.FinalHashMap;
import com.atlassian.bamboo.repository.RepositoryConfigurationReference;
import com.atlassian.bamboo.repository.RepositoryConfigurationReferenceConverter;
import com.atlassian.bamboo.vcs.configuration.VcsLocationDefinition;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamConverter;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsLocationDefinitionImpl
implements VcsLocationDefinition {
    private final FinalHashMap<String, String> serverConfiguration;
    @XStreamAlias(value="xmlData")
    @XStreamConverter(value=RepositoryConfigurationReferenceConverter.class)
    protected final RepositoryConfigurationReference configurationRef;

    public VcsLocationDefinitionImpl(@NotNull Map<String, String> serverConfiguration, @Nullable String legacyXml) {
        this.serverConfiguration = new FinalHashMap(serverConfiguration);
        this.configurationRef = legacyXml != null ? new RepositoryConfigurationReference(legacyXml) : null;
    }

    public VcsLocationDefinitionImpl(@NotNull VcsLocationDefinition vcsLocation) {
        this.serverConfiguration = new FinalHashMap(vcsLocation.getConfiguration());
        String legacyXml = vcsLocation.getLegacyConfigurationXml();
        this.configurationRef = legacyXml != null ? new RepositoryConfigurationReference(legacyXml) : null;
    }

    public VcsLocationDefinitionImpl(@NotNull VcsLocationDefinition vcsLocation, @Nullable String legacyXml) {
        this.serverConfiguration = new FinalHashMap(vcsLocation.getConfiguration());
        this.configurationRef = legacyXml != null ? new RepositoryConfigurationReference(legacyXml) : null;
    }

    public boolean isLegacyRepository() {
        return this.configurationRef != null;
    }

    @NotNull
    public Map<String, String> getConfiguration() {
        return this.serverConfiguration;
    }

    public RepositoryConfigurationReference getConfigurationRef() {
        return this.configurationRef;
    }

    public String getLegacyConfigurationXml() {
        return this.isLegacyRepository() ? this.configurationRef.getXmlString() : null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VcsLocationDefinitionImpl that = (VcsLocationDefinitionImpl)o;
        if (this.serverConfiguration != null ? !this.serverConfiguration.equals(that.serverConfiguration) : that.serverConfiguration != null) {
            return false;
        }
        return !(this.getLegacyConfigurationXml() != null ? !this.getLegacyConfigurationXml().equals(that.getLegacyConfigurationXml()) : that.getLegacyConfigurationXml() != null);
    }

    public int hashCode() {
        int result = this.serverConfiguration != null ? this.serverConfiguration.hashCode() : 0;
        result = 31 * result + (this.getLegacyConfigurationXml() != null ? this.getLegacyConfigurationXml().hashCode() : 0);
        return result;
    }
}

