/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.vcs.configuration;

import com.atlassian.bamboo.core.BambooEntityOid;
import com.atlassian.bamboo.repository.RepositoryData;
import com.atlassian.bamboo.utils.BambooInterners;
import com.atlassian.bamboo.vcs.configuration.ChangeDetectionSourceDefinitionImpl;
import com.atlassian.bamboo.vcs.configuration.LegacyRepositoryDataSupplier;
import com.atlassian.bamboo.vcs.configuration.VcsBambooSpecsDetectionOptions;
import com.atlassian.bamboo.vcs.configuration.VcsBambooSpecsDetectionOptionsImpl;
import com.atlassian.bamboo.vcs.configuration.VcsBranchDefinition;
import com.atlassian.bamboo.vcs.configuration.VcsBranchDefinitionImpl;
import com.atlassian.bamboo.vcs.configuration.VcsBranchDetectionOptions;
import com.atlassian.bamboo.vcs.configuration.VcsBranchDetectionOptionsImpl;
import com.atlassian.bamboo.vcs.configuration.VcsChangeDetectionOptions;
import com.atlassian.bamboo.vcs.configuration.VcsLocationDefinition;
import com.atlassian.bamboo.vcs.configuration.VcsLocationDefinitionImpl;
import com.atlassian.bamboo.vcs.configuration.VcsRepositoryData;
import com.atlassian.bamboo.vcs.viewer.configuration.VcsRepositoryViewerDefinition;
import com.atlassian.bamboo.vcs.viewer.configuration.VcsRepositoryViewerDefinitionImpl;
import io.atlassian.fugue.Suppliers;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsRepositoryDataImpl
implements VcsRepositoryData {
    private final long id;
    private final BambooEntityOid oid;
    private final String pluginKey;
    private final String name;
    private final String description;
    private final boolean linked;
    private final boolean rootVcsIsLinked;
    private final long rootId;
    private final boolean markedForDeletion;
    private final Long parentId;
    private final BambooEntityOid parentOid;
    private final VcsLocationDefinition vcsLocationDefinition;
    private final VcsChangeDetectionOptions vcsChangeDetectionOptions;
    private final VcsBranchDetectionOptions vcsBranchDetectionOptions;
    private final VcsBranchDefinition vcsBranchDefinition;
    private final VcsRepositoryViewerDefinition vcsRepositoryViewerDefinition;
    private final VcsBambooSpecsDetectionOptions bambooSpecsDetectionOptions;
    private transient Supplier<RepositoryData> legacyData;

    public VcsRepositoryDataImpl(@NotNull VcsRepositoryData other) {
        this.id = other.getId();
        this.oid = other.getOid();
        this.pluginKey = BambooInterners.moduleKey((String)other.getPluginKey());
        this.name = BambooInterners.intern((String)other.getName());
        this.description = BambooInterners.intern((String)other.getDescription());
        this.markedForDeletion = other.isMarkedForDeletion();
        this.linked = other.isLinked();
        this.rootId = other.getRootVcsRepositoryId();
        this.rootVcsIsLinked = other.isRootVcsLinked();
        this.parentId = other.getParentId();
        this.parentOid = other.getParentOid();
        this.vcsLocationDefinition = new VcsLocationDefinitionImpl(other.getVcsLocation());
        this.bambooSpecsDetectionOptions = other.getBambooSpecsDetectionOptions() != null ? new VcsBambooSpecsDetectionOptionsImpl(other.getBambooSpecsDetectionOptions().getConfiguration()) : null;
        this.vcsChangeDetectionOptions = other.getVcsChangeDetectionOptions() != null ? new ChangeDetectionSourceDefinitionImpl(other.getVcsChangeDetectionOptions()) : null;
        this.vcsBranchDetectionOptions = other.getVcsBranchDetectionOptions() != null ? new VcsBranchDetectionOptionsImpl(other.getVcsBranchDetectionOptions().getConfiguration()) : null;
        this.vcsBranchDefinition = other.getBranch() != null ? new VcsBranchDefinitionImpl(other.getBranch()) : null;
        this.vcsRepositoryViewerDefinition = other.getViewerConfiguration() != null ? new VcsRepositoryViewerDefinitionImpl(other.getViewerConfiguration()) : null;
        this.legacyData = Suppliers.memoize((Supplier)new LegacyRepositoryDataSupplier(this));
    }

    public BambooEntityOid getOid() {
        return this.oid;
    }

    @NotNull
    public String getPluginKey() {
        return this.pluginKey;
    }

    @NotNull
    public VcsLocationDefinition getVcsLocation() {
        return this.vcsLocationDefinition;
    }

    @Nullable
    public VcsBranchDefinition getBranch() {
        return this.vcsBranchDefinition;
    }

    @Nullable
    public VcsChangeDetectionOptions getVcsChangeDetectionOptions() {
        return this.vcsChangeDetectionOptions;
    }

    @Nullable
    public VcsBranchDetectionOptions getVcsBranchDetectionOptions() {
        return this.vcsBranchDetectionOptions;
    }

    @Nullable
    public VcsBambooSpecsDetectionOptions getBambooSpecsDetectionOptions() {
        return this.bambooSpecsDetectionOptions;
    }

    @Nullable
    public VcsRepositoryViewerDefinition getViewerConfiguration() {
        return this.vcsRepositoryViewerDefinition;
    }

    public boolean isMarkedForDeletion() {
        return this.markedForDeletion;
    }

    public boolean isLinked() {
        return this.linked;
    }

    public boolean isRootVcsLinked() {
        return this.rootVcsIsLinked;
    }

    public long getId() {
        return this.id;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    public boolean isLegacyRepository() {
        return this.vcsLocationDefinition.isLegacyRepository();
    }

    @Nullable
    public Long getParentId() {
        return this.parentId;
    }

    @Nullable
    public BambooEntityOid getParentOid() {
        return this.parentOid;
    }

    public long getRootVcsRepositoryId() {
        return this.rootId;
    }

    @NotNull
    public RepositoryData asLegacyData() {
        if (this.legacyData == null) {
            this.legacyData = Suppliers.memoize((Supplier)new LegacyRepositoryDataSupplier(this));
        }
        return this.legacyData.get();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VcsRepositoryDataImpl that = (VcsRepositoryDataImpl)o;
        if (this.id != that.id) {
            return false;
        }
        return !(this.oid != null ? !this.oid.equals((Object)that.oid) : that.oid != null);
    }

    public int hashCode() {
        int result = (int)(this.id ^ this.id >>> 32);
        result = 31 * result + (this.oid != null ? this.oid.hashCode() : 0);
        return result;
    }
}

