/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.vcs.configuration.legacy;

import com.atlassian.bamboo.commit.CommitContext;
import com.atlassian.bamboo.plan.branch.VcsBranch;
import com.atlassian.bamboo.repository.BranchDetectionCapableRepository;
import com.atlassian.bamboo.repository.BranchInformationProvider;
import com.atlassian.bamboo.repository.CacheId;
import com.atlassian.bamboo.repository.CachingAwareRepository;
import com.atlassian.bamboo.repository.RepositoryException;
import com.atlassian.bamboo.repository.plugin.RepositoryModuleDescriptor;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.vcs.configuration.VcsRepositoryData;
import com.atlassian.bamboo.vcs.configuration.legacy.LegacyExecutorBase;
import com.atlassian.bamboo.vcs.runtime.ContextualVcsId;
import com.atlassian.bamboo.vcs.runtime.IdentifyingExecutor;
import com.atlassian.bamboo.vcs.runtime.VcsBranchDetector;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LegacyBranchDetector
extends LegacyExecutorBase
implements VcsBranchDetector {
    public LegacyBranchDetector(RepositoryModuleDescriptor repositoryModuleDescriptor) {
        super(repositoryModuleDescriptor);
    }

    private BranchDetectionCapableRepository getBranchCapableInstance(@NotNull VcsRepositoryData repositoryData) {
        return this.getRepositoryInstanceAs(repositoryData, BranchDetectionCapableRepository.class);
    }

    @NotNull
    public List<VcsBranch> getOpenBranches(@NotNull VcsRepositoryData repositoryData) throws RepositoryException {
        return this.getBranchCapableInstance(repositoryData).getOpenBranches(null);
    }

    @NotNull
    public CommitContext getLastCommit(@NotNull VcsRepositoryData repositoryData) throws RepositoryException {
        return this.getBranchCapableInstance(repositoryData).getLastCommit();
    }

    @Nullable
    public CommitContext getFirstCommit(@NotNull VcsRepositoryData repositoryData) throws RepositoryException {
        return this.getBranchCapableInstance(repositoryData).getFirstCommit();
    }

    public boolean usePollingForBranchDetection(@NotNull VcsRepositoryData repositoryData) {
        BranchDetectionCapableRepository repository = this.getBranchCapableInstance(repositoryData);
        BranchInformationProvider bip = (BranchInformationProvider)Narrow.downTo((Object)repository, BranchInformationProvider.class);
        return bip == null || bip.usePollingForBranchDetection();
    }

    @Nullable
    public ContextualVcsId getVcsIdForExecutor(@NotNull VcsRepositoryData repositoryData) {
        BranchDetectionCapableRepository bdcr = this.getBranchCapableInstance(repositoryData);
        CachingAwareRepository car = (CachingAwareRepository)Narrow.to((Object)bdcr, CachingAwareRepository.class);
        if (car != null) {
            CacheId cacheId = car.getCacheId(CachingAwareRepository.CachableOperation.BRANCH_DETECTION);
            return new ContextualVcsId((IdentifyingExecutor)this, repositoryData, cacheId.getIds());
        }
        return null;
    }
}

