/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.vcs.configuration.legacy;

import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.vcsRevision.PlanVcsRevisionData;
import com.atlassian.bamboo.repository.CommitIsolationAwareRepository;
import com.atlassian.bamboo.repository.CustomRevisionDataAwareRepository;
import com.atlassian.bamboo.repository.OnceOffCapableRepository;
import com.atlassian.bamboo.repository.Repository;
import com.atlassian.bamboo.repository.RepositoryException;
import com.atlassian.bamboo.repository.plugin.RepositoryModuleDescriptor;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.v2.build.BuildRepositoryChanges;
import com.atlassian.bamboo.vcs.configuration.VcsRepositoryData;
import com.atlassian.bamboo.vcs.configuration.legacy.LegacyExecutorBase;
import com.atlassian.bamboo.vcs.runtime.CommitsIsolatingVcsChangeDetector;
import com.atlassian.bamboo.vcs.runtime.ContextualVcsId;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LegacyChangeDetector
extends LegacyExecutorBase
implements CommitsIsolatingVcsChangeDetector {
    private static final Logger log = Logger.getLogger(LegacyChangeDetector.class);

    public LegacyChangeDetector(RepositoryModuleDescriptor repositoryModuleDescriptor) {
        super(repositoryModuleDescriptor);
    }

    @NotNull
    public List<BuildRepositoryChanges> isolateCommits(@NotNull BuildRepositoryChanges changes, @NotNull VcsRepositoryData vcsRepositoryData) {
        Repository repository = this.getRepositoryInstance(vcsRepositoryData);
        CommitIsolationAwareRepository ciar = (CommitIsolationAwareRepository)Narrow.downTo((Object)repository, CommitIsolationAwareRepository.class);
        if (ciar != null) {
            return ciar.isolateCommits(changes);
        }
        log.warn((Object)"Commit isolation enabled but repository does not support it");
        return Lists.newArrayList((Object[])new BuildRepositoryChanges[]{changes});
    }

    @NotNull
    public BuildRepositoryChanges collectChangesSinceRevision(@NotNull PlanKey planKey, @NotNull VcsRepositoryData repositoryData, @NotNull PlanVcsRevisionData lastRevisionData) throws RepositoryException {
        Repository repository = this.getRepositoryInstance(repositoryData);
        CustomRevisionDataAwareRepository crdar = (CustomRevisionDataAwareRepository)Narrow.downTo((Object)repository, CustomRevisionDataAwareRepository.class);
        if (crdar != null) {
            return crdar.collectChangesSinceLastBuild(planKey.getKey(), lastRevisionData);
        }
        return repository.collectChangesSinceLastBuild(planKey.getKey(), lastRevisionData.getVcsRevisionKey());
    }

    @NotNull
    public BuildRepositoryChanges collectChangesForRevision(@NotNull PlanKey planKey, @NotNull VcsRepositoryData repositoryData, @NotNull String customRevision) throws RepositoryException {
        Repository repository = this.getRepositoryInstance(repositoryData);
        OnceOffCapableRepository oocr = (OnceOffCapableRepository)Narrow.downTo((Object)repository, OnceOffCapableRepository.class);
        if (oocr != null) {
            return oocr.collectChangesForRevision(planKey, customRevision);
        }
        log.debug((Object)("Repository " + repository.getName() + " has no collectChangesForRevision implementation - falling back to collectChangesSinceLastBuild..."));
        BuildRepositoryChanges buildRepositoryChanges = repository.collectChangesSinceLastBuild(planKey.getKey(), customRevision);
        buildRepositoryChanges.setChanges(buildRepositoryChanges.getChanges().stream().filter(commitContext -> commitContext != null && customRevision.equals(commitContext.guessChangeSetId())).collect(Collectors.toList()));
        return buildRepositoryChanges;
    }

    @Nullable
    public ContextualVcsId getVcsIdForExecutor(@NotNull VcsRepositoryData vcsRepositoryData) {
        return null;
    }
}

