/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.vcs.configuration.legacy;

import com.atlassian.bamboo.repository.Repository;
import com.atlassian.bamboo.repository.RepositoryConfigurationReference;
import com.atlassian.bamboo.repository.plugin.RepositoryModuleDescriptor;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.utils.CommonsConfigUtils;
import com.atlassian.bamboo.utils.ConfigUtils;
import com.atlassian.bamboo.vcs.configuration.VcsRepositoryData;
import com.google.common.base.Preconditions;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.configuration.StrictConfigurationComparator;
import org.apache.commons.configuration.XMLConfiguration;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class LegacyExecutorBase {
    private static final Logger log = Logger.getLogger(LegacyExecutorBase.class);
    protected final RepositoryModuleDescriptor repositoryModuleDescriptor;

    public LegacyExecutorBase(RepositoryModuleDescriptor repositoryModuleDescriptor) {
        this.repositoryModuleDescriptor = repositoryModuleDescriptor;
    }

    protected Repository getRepositoryInstance(@NotNull VcsRepositoryData vcsRepositoryData) {
        return vcsRepositoryData.asLegacyData().getRepository();
    }

    protected Repository getNewRepositoryInstance(@NotNull VcsRepositoryData vcsRepositoryData) {
        return vcsRepositoryData.asLegacyData().getNewRepositoryInstance();
    }

    private <T extends Repository> T castOrThrow(Repository repository, @NotNull Class<T> clazz) {
        Repository asT = (Repository)Narrow.downTo((Object)repository, clazz);
        Preconditions.checkState((asT != null ? 1 : 0) != 0, (Object)("Not instance of " + clazz.getName()));
        return (T)asT;
    }

    protected <T extends Repository> T getNewRepositoryInstanceAs(@NotNull VcsRepositoryData repositoryData, @NotNull Class<T> clazz) {
        Repository repository = this.getNewRepositoryInstance(repositoryData);
        return this.castOrThrow(repository, clazz);
    }

    protected <T extends Repository> T getRepositoryInstanceAs(@NotNull VcsRepositoryData repositoryData, @NotNull Class<T> clazz) {
        Repository repository = this.getRepositoryInstance(repositoryData);
        return this.castOrThrow(repository, clazz);
    }

    protected RepositoryConfigurationReference.RepoHierarchicalConfiguration xmlToConfiguration(@NotNull String localRepositoryDataXml) {
        XMLConfiguration xmlConfigFromXmlString = ConfigUtils.getXmlConfigFromXmlString((String)localRepositoryDataXml);
        RepositoryConfigurationReference.RepoHierarchicalConfiguration repoHierarchicalConfiguration = new RepositoryConfigurationReference.RepoHierarchicalConfiguration();
        CommonsConfigUtils.copyContent((XMLConfiguration)xmlConfigFromXmlString, (HierarchicalConfiguration)repoHierarchicalConfiguration);
        boolean isTheSame = new StrictConfigurationComparator().compare((Configuration)xmlConfigFromXmlString, (Configuration)repoHierarchicalConfiguration);
        Preconditions.checkArgument((boolean)isTheSame, (Object)("Configuration roundtrip mismatch for " + localRepositoryDataXml));
        return repoHierarchicalConfiguration;
    }
}

