/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.vcs.configuration.legacy;

import com.atlassian.bamboo.build.BuildLoggerManager;
import com.atlassian.bamboo.repository.BranchAwareRepository;
import com.atlassian.bamboo.repository.BranchDetectionCapableRepository;
import com.atlassian.bamboo.repository.BranchMergingAwareRepository;
import com.atlassian.bamboo.repository.CommitIsolationAwareRepository;
import com.atlassian.bamboo.repository.CustomVariableProviderRepository;
import com.atlassian.bamboo.repository.MavenPomAccessorCapableRepository;
import com.atlassian.bamboo.repository.PushCapableRepository;
import com.atlassian.bamboo.repository.Repository;
import com.atlassian.bamboo.repository.TestConnectionAwareRepository;
import com.atlassian.bamboo.repository.UniqueRevisionIdRepository;
import com.atlassian.bamboo.repository.cvsimpl.CVSRepository;
import com.atlassian.bamboo.repository.plugin.RepositoryModuleDescriptor;
import com.atlassian.bamboo.spring.ComponentAccessor;
import com.atlassian.bamboo.v2.build.repository.CustomSourceDirectoryAwareRepository;
import com.atlassian.bamboo.vcs.configuration.configurator.DefaultChangeDetectionOptionsConfigurator;
import com.atlassian.bamboo.vcs.configuration.legacy.LegacyBranchDetector;
import com.atlassian.bamboo.vcs.configuration.legacy.LegacyChangeDetector;
import com.atlassian.bamboo.vcs.configuration.legacy.LegacyConnectionTester;
import com.atlassian.bamboo.vcs.configuration.legacy.LegacyFixedDirectoryWorkingCopyManager;
import com.atlassian.bamboo.vcs.configuration.legacy.LegacyVariableGenerator;
import com.atlassian.bamboo.vcs.configuration.legacy.LegacyWorkingCopyManager;
import com.atlassian.bamboo.vcs.configuration.legacy.configurator.LegacyBranchConfigurator;
import com.atlassian.bamboo.vcs.configuration.legacy.configurator.LegacyMavenPomAccessor;
import com.atlassian.bamboo.vcs.configuration.legacy.configurator.LegacyRepositoryConfigurationExporter;
import com.atlassian.bamboo.vcs.configuration.legacy.configurator.LegacyVcsLocationConfigurator;
import com.atlassian.bamboo.vcs.configurator.VcsBranchConfigurator;
import com.atlassian.bamboo.vcs.configurator.VcsBranchDetectionOptionsConfigurator;
import com.atlassian.bamboo.vcs.configurator.VcsChangeDetectionOptionsConfigurator;
import com.atlassian.bamboo.vcs.configurator.VcsLocationConfigurator;
import com.atlassian.bamboo.vcs.configurator.VcsMavenPomAccessor;
import com.atlassian.bamboo.vcs.export.VcsRepositoryDataExporter;
import com.atlassian.bamboo.vcs.module.VcsRepositoryModuleDescriptor;
import com.atlassian.bamboo.vcs.runtime.VcsBranchCreator;
import com.atlassian.bamboo.vcs.runtime.VcsBranchDetector;
import com.atlassian.bamboo.vcs.runtime.VcsChangeDetector;
import com.atlassian.bamboo.vcs.runtime.VcsConnectionTester;
import com.atlassian.bamboo.vcs.runtime.VcsPullRequestDetector;
import com.atlassian.bamboo.vcs.runtime.VcsTagCreator;
import com.atlassian.bamboo.vcs.runtime.VcsVariableGenerator;
import com.atlassian.bamboo.vcs.runtime.VcsWorkingCopyManager;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.elements.ResourceDescriptor;
import com.atlassian.plugin.elements.ResourceLocation;
import com.atlassian.plugin.webresource.UrlMode;
import com.atlassian.plugin.webresource.WebResourceUrlProvider;
import io.atlassian.util.concurrent.LazyReference;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import org.dom4j.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LegacyRepositoryModuleDescriptor
implements VcsRepositoryModuleDescriptor {
    private static final String ICON_RESOURCE = "icon";
    private static final String DOWNLOAD_RESOURCE_TYPE = "download";
    private final RepositoryModuleDescriptor repositoryModuleDescriptor;
    private final LazyReference<String> optionDescription = new LazyReference<String>(){

        protected String create() throws Exception {
            Repository repository = (Repository)LegacyRepositoryModuleDescriptor.this.repositoryModuleDescriptor.getModule();
            Class<?> clazz = repository.getClass();
            try {
                Method method = clazz.getDeclaredMethod("getOptionDescription", new Class[0]);
                return method.invoke((Object)repository, new Object[0]).toString();
            }
            catch (Exception e) {
                return "";
            }
        }
    };
    private final LegacyWorkingCopyManager workingCopyManager;
    private final LegacyChangeDetector changeDetector;
    private final LegacyVcsLocationConfigurator serverConfigurator;
    private final LegacyBranchDetector branchDetector;
    private final LegacyBranchConfigurator branchConfigurator;
    private final LegacyConnectionTester legacyConnectionTester;
    private final LegacyVariableGenerator legacyVariableGenerator;
    private final LegacyMavenPomAccessor legacyMavenPomAccessor;
    private final Class<? extends VcsWorkingCopyManager> moduleClass;

    public LegacyRepositoryModuleDescriptor(RepositoryModuleDescriptor repositoryModuleDescriptor) {
        this.repositoryModuleDescriptor = repositoryModuleDescriptor;
        if (CustomSourceDirectoryAwareRepository.class.isAssignableFrom(repositoryModuleDescriptor.getModuleClass())) {
            this.workingCopyManager = new LegacyWorkingCopyManager(repositoryModuleDescriptor, (BuildLoggerManager)ComponentAccessor.BUILD_LOGGER_MANAGER.get());
            this.moduleClass = LegacyWorkingCopyManager.class;
        } else {
            this.workingCopyManager = new LegacyFixedDirectoryWorkingCopyManager(repositoryModuleDescriptor, (BuildLoggerManager)ComponentAccessor.BUILD_LOGGER_MANAGER.get());
            this.moduleClass = LegacyFixedDirectoryWorkingCopyManager.class;
        }
        this.changeDetector = new LegacyChangeDetector(repositoryModuleDescriptor);
        this.serverConfigurator = new LegacyVcsLocationConfigurator(repositoryModuleDescriptor);
        this.branchDetector = new LegacyBranchDetector(repositoryModuleDescriptor);
        this.branchConfigurator = BranchAwareRepository.class.isAssignableFrom(repositoryModuleDescriptor.getModuleClass()) ? new LegacyBranchConfigurator(repositoryModuleDescriptor) : null;
        this.legacyConnectionTester = TestConnectionAwareRepository.class.isAssignableFrom(repositoryModuleDescriptor.getModuleClass()) ? new LegacyConnectionTester(repositoryModuleDescriptor) : null;
        this.legacyVariableGenerator = CustomVariableProviderRepository.class.isAssignableFrom(repositoryModuleDescriptor.getModuleClass()) ? new LegacyVariableGenerator(repositoryModuleDescriptor) : null;
        this.legacyMavenPomAccessor = MavenPomAccessorCapableRepository.class.isAssignableFrom(repositoryModuleDescriptor.getModuleClass()) ? new LegacyMavenPomAccessor(repositoryModuleDescriptor) : null;
    }

    public String getCompleteKey() {
        return this.repositoryModuleDescriptor.getCompleteKey();
    }

    public String getPluginKey() {
        return this.repositoryModuleDescriptor.getPluginKey();
    }

    public String getKey() {
        return this.repositoryModuleDescriptor.getKey();
    }

    public String getName() {
        return this.getLegacyModule().getName();
    }

    public String getDescription() {
        return this.repositoryModuleDescriptor.getDescription();
    }

    public Class<VcsWorkingCopyManager> getModuleClass() {
        return this.moduleClass;
    }

    public void init(@NotNull Plugin plugin, @NotNull Element element) throws PluginParseException {
    }

    public boolean isEnabledByDefault() {
        return false;
    }

    public boolean isSystemModule() {
        return false;
    }

    public void destroy(Plugin plugin) {
    }

    public void destroy() {
    }

    public Float getMinJavaVersion() {
        return this.repositoryModuleDescriptor.getMinJavaVersion();
    }

    public boolean satisfiesMinJavaVersion() {
        return this.repositoryModuleDescriptor.satisfiesMinJavaVersion();
    }

    public Map<String, String> getParams() {
        return this.repositoryModuleDescriptor.getParams();
    }

    public String getI18nNameKey() {
        return this.repositoryModuleDescriptor.getI18nNameKey();
    }

    public String getDescriptionKey() {
        return this.repositoryModuleDescriptor.getDescriptionKey();
    }

    public Plugin getPlugin() {
        return this.repositoryModuleDescriptor.getPlugin();
    }

    public List<ResourceDescriptor> getResourceDescriptors() {
        return this.repositoryModuleDescriptor.getResourceDescriptors();
    }

    public List<ResourceDescriptor> getResourceDescriptors(String type) {
        return this.repositoryModuleDescriptor.getResourceDescriptors(type);
    }

    public ResourceDescriptor getResourceDescriptor(String type, String name) {
        return this.repositoryModuleDescriptor.getResourceDescriptor(type, name);
    }

    public ResourceLocation getResourceLocation(String type, String name) {
        String resourceName = name;
        switch (name) {
            case "editServer": {
                resourceName = "edit";
                break;
            }
            case "viewServer": {
                resourceName = "view";
                break;
            }
            case "editAdvancedServerOptions": {
                resourceName = "advancedEdit";
                break;
            }
            case "viewAdvancedServerOptions": {
                resourceName = "advancedView";
            }
        }
        return this.repositoryModuleDescriptor.getResourceLocation(type, resourceName);
    }

    public VcsWorkingCopyManager getModule() {
        return this.getWorkingCopyManager();
    }

    @Nullable
    public String getIcon() {
        WebResourceUrlProvider webResourceUrlProvider = (WebResourceUrlProvider)ComponentAccessor.WEB_RESOURCE_URL_PROVIDER.get();
        if (webResourceUrlProvider != null && this.getResourceDescriptor(DOWNLOAD_RESOURCE_TYPE, ICON_RESOURCE) != null) {
            return webResourceUrlProvider.getStaticPluginResourceUrl((ModuleDescriptor)this.repositoryModuleDescriptor, ICON_RESOURCE, UrlMode.RELATIVE);
        }
        return null;
    }

    @Nullable
    public String getOptionDescription() {
        return (String)this.optionDescription.get();
    }

    @Nullable
    public String getTooltipKey() {
        return this.repositoryModuleDescriptor.getConfigurator().getTooltipKey();
    }

    public boolean isPrimary() {
        return this.repositoryModuleDescriptor.getConfigurator().isPrimary();
    }

    public int getWeight() {
        return this.repositoryModuleDescriptor.getConfigurator().getWeight();
    }

    @NotNull
    public Repository getLegacyModule() {
        return (Repository)this.repositoryModuleDescriptor.getModule();
    }

    public RepositoryModuleDescriptor getLegacyRepositoryModuleDescriptor() {
        return this.repositoryModuleDescriptor;
    }

    @NotNull
    public VcsLocationConfigurator getVcsLocationConfigurator() {
        return this.serverConfigurator;
    }

    @Nullable
    public VcsChangeDetectionOptionsConfigurator getVcsChangeDetectionOptionsConfigurator() {
        Class repositoryClass = this.repositoryModuleDescriptor.getModuleClass();
        boolean quietPeriodSupported = !CVSRepository.class.isAssignableFrom(repositoryClass);
        boolean commitIsolationSupported = CommitIsolationAwareRepository.class.isAssignableFrom(repositoryClass);
        return new DefaultChangeDetectionOptionsConfigurator(quietPeriodSupported, commitIsolationSupported);
    }

    @Nullable
    public VcsBranchDetectionOptionsConfigurator getVcsBranchDetectionOptionsConfigurator() {
        return null;
    }

    @Nullable
    public VcsBranchConfigurator getVcsBranchConfigurator() {
        return this.branchConfigurator;
    }

    @NotNull
    public VcsChangeDetector getChangeDetector() {
        return this.changeDetector;
    }

    @NotNull
    public VcsWorkingCopyManager getWorkingCopyManager() {
        return this.workingCopyManager;
    }

    @Nullable
    public VcsConnectionTester getConnectionTester() {
        return this.legacyConnectionTester;
    }

    @Nullable
    public VcsBranchDetector getBranchDetector() {
        return this.branchDetector;
    }

    @Nullable
    public VcsBranchCreator getBranchCreator() {
        return null;
    }

    @Nullable
    public VcsTagCreator getTagCreator() {
        return null;
    }

    @Nullable
    public VcsPullRequestDetector getPullRequestDetector() {
        return null;
    }

    @Nullable
    public VcsVariableGenerator getVariableGenerator() {
        return this.legacyVariableGenerator;
    }

    @Nullable
    public VcsMavenPomAccessor getVcsMavenPomAccessor() {
        return this.legacyMavenPomAccessor;
    }

    @NotNull
    public VcsRepositoryDataExporter getExporter() {
        return new LegacyRepositoryConfigurationExporter(this.repositoryModuleDescriptor);
    }

    public boolean supportsMerging() {
        return BranchMergingAwareRepository.class.isAssignableFrom(this.repositoryModuleDescriptor.getModuleClass());
    }

    public boolean supportsRemoteUpdates() {
        return PushCapableRepository.class.isAssignableFrom(this.repositoryModuleDescriptor.getModuleClass());
    }

    public boolean supportsBranchDetection() {
        return BranchDetectionCapableRepository.class.isAssignableFrom(this.repositoryModuleDescriptor.getModuleClass());
    }

    public boolean supportsBranchOverrides() {
        return false;
    }

    public boolean supportsBranchCreation() {
        return false;
    }

    public boolean supportsTagCreation() {
        return false;
    }

    public boolean providesCustomVariables() {
        return CustomVariableProviderRepository.class.isAssignableFrom(this.repositoryModuleDescriptor.getModuleClass());
    }

    public boolean supportsTestingConnection() {
        return this.legacyConnectionTester != null;
    }

    public boolean supportsImportFromMaven() {
        return MavenPomAccessorCapableRepository.class.isAssignableFrom(this.repositoryModuleDescriptor.getModuleClass());
    }

    public boolean providesWorkingCopyStatus() {
        return false;
    }

    public boolean revisionIdsAreUnique() {
        return UniqueRevisionIdRepository.class.isAssignableFrom(this.repositoryModuleDescriptor.getModuleClass());
    }

    @NotNull
    public String getTypeString() {
        return this.repositoryModuleDescriptor.getKey();
    }

    @NotNull
    public String getDefaultTriggerKey() {
        return "com.atlassian.bamboo.triggers.atlassian-bamboo-triggers:poll";
    }

    @NotNull
    public String getDefaultVcsViewerKey() {
        return "none:none";
    }

    public boolean isEnabled() {
        return this.repositoryModuleDescriptor.isEnabled();
    }
}

