/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.vcs.configuration.legacy;

import com.atlassian.bamboo.build.BuildLoggerManager;
import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.plan.branch.VcsBranch;
import com.atlassian.bamboo.plan.vcsRevision.PlanVcsRevisionData;
import com.atlassian.bamboo.repository.BranchMergingAwareRepository;
import com.atlassian.bamboo.repository.CheckoutCustomRevisionDataAwareRepository;
import com.atlassian.bamboo.repository.MandatoryCleanCheckoutAwareRepository;
import com.atlassian.bamboo.repository.PushCapableRepository;
import com.atlassian.bamboo.repository.Repository;
import com.atlassian.bamboo.repository.RepositoryException;
import com.atlassian.bamboo.repository.plugin.RepositoryModuleDescriptor;
import com.atlassian.bamboo.util.BambooFileUtils;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.v2.build.BuildContext;
import com.atlassian.bamboo.v2.build.BuildRepositoryChanges;
import com.atlassian.bamboo.v2.build.CommonContext;
import com.atlassian.bamboo.v2.build.repository.CustomSourceDirectoryAwareRepository;
import com.atlassian.bamboo.v2.build.repository.LegacyRepository;
import com.atlassian.bamboo.v2.build.repository.RepositoryEventAware;
import com.atlassian.bamboo.vcs.configuration.VcsRepositoryData;
import com.atlassian.bamboo.vcs.configuration.legacy.DeploymentRepositoryBuildContext;
import com.atlassian.bamboo.vcs.configuration.legacy.LegacyExecutorBase;
import com.atlassian.bamboo.vcs.runtime.MergingVcsWorkingCopyManager;
import com.atlassian.bamboo.vcs.runtime.UpdatingVcsWorkingCopyManager;
import com.atlassian.bamboo.vcs.runtime.VcsWorkingCopy;
import com.atlassian.bamboo.vcs.runtime.VcsWorkingCopyManager;
import java.io.File;
import java.io.IOException;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class LegacyWorkingCopyManager
extends LegacyExecutorBase
implements VcsWorkingCopyManager,
MergingVcsWorkingCopyManager,
UpdatingVcsWorkingCopyManager {
    private static final Logger log = Logger.getLogger(LegacyWorkingCopyManager.class);
    private final BuildLoggerManager buildLoggerManager;

    public LegacyWorkingCopyManager(RepositoryModuleDescriptor repositoryModuleDescriptor, BuildLoggerManager buildLoggerManager) {
        super(repositoryModuleDescriptor);
        this.buildLoggerManager = buildLoggerManager;
    }

    private void beforeRetrieve(BuildContext buildContext, Repository repository, BuildLogger buildLogger, File targetPath) throws RepositoryException {
        if (repository instanceof RepositoryEventAware) {
            log.info((Object)buildLogger.addBuildLogEntry("Running preRetrieveSourceCode task..."));
            RepositoryEventAware repositoryEventAware = (RepositoryEventAware)repository;
            repositoryEventAware.preRetrieveSourceCode(buildContext, targetPath);
        }
        if (repository instanceof MandatoryCleanCheckoutAwareRepository && ((MandatoryCleanCheckoutAwareRepository)repository).isCleanCheckoutRequired()) {
            log.info((Object)buildLogger.addBuildLogEntry("Clean checkout enforced by repository configuration"));
            if (BambooFileUtils.isDirectoryImportant(targetPath)) {
                String errorMessage = "A clean build cannot be forced for " + buildContext.getEntityKey() + ", as the plan's source directory " + targetPath.getAbsolutePath() + " is reserved by the system. Please amend your build configuration.";
                log.warn((Object)buildLogger.addErrorLogEntry(errorMessage));
                throw new RepositoryException(errorMessage);
            }
            if (targetPath.exists()) {
                try {
                    BambooFileUtils.cleanDirectory(targetPath);
                }
                catch (IOException e) {
                    String errorMessage = "Unable to clean source directory '" + targetPath.getAbsolutePath() + "' " + e.getMessage();
                    log.warn((Object)buildLogger.addErrorLogEntry(errorMessage), (Throwable)e);
                    throw new RepositoryException(errorMessage, (Throwable)e);
                }
            }
        }
    }

    private void afterRetrieve(BuildContext buildContext, Repository repository, BuildLogger buildLogger, @NotNull File targetPath) {
        if (repository instanceof RepositoryEventAware) {
            log.info((Object)buildLogger.addBuildLogEntry("Running postRetrieveSourceCode task..."));
            RepositoryEventAware repositoryEventAware = (RepositoryEventAware)repository;
            repositoryEventAware.postRetrieveSourceCode(buildContext, targetPath);
        }
    }

    private BuildContext getBuildContext(@NotNull CommonContext commonContext) {
        if (commonContext instanceof BuildContext) {
            return (BuildContext)commonContext;
        }
        return new DeploymentRepositoryBuildContext(commonContext);
    }

    @NotNull
    public VcsWorkingCopy retrieveSourceCode(@NotNull CommonContext commonContext, @NotNull VcsRepositoryData repositoryData, @NotNull PlanVcsRevisionData targetRevision, @NotNull File targetPath) throws RepositoryException {
        String vcsRevisionKey;
        BuildLogger buildLogger = this.buildLoggerManager.getLogger(commonContext.getResultKey());
        Repository repository = this.getRepositoryInstance(repositoryData);
        BuildContext buildContext = this.getBuildContext(commonContext);
        this.beforeRetrieve(buildContext, repository, buildLogger, targetPath);
        CheckoutCustomRevisionDataAwareRepository checkoutCustomRevisionDataAwareRepository = (CheckoutCustomRevisionDataAwareRepository)Narrow.to((Object)repository, CheckoutCustomRevisionDataAwareRepository.class);
        if (checkoutCustomRevisionDataAwareRepository != null) {
            vcsRevisionKey = checkoutCustomRevisionDataAwareRepository.retrieveSourceCode(buildContext, targetRevision, targetPath, 1);
        } else {
            CustomSourceDirectoryAwareRepository customSourceDirectoryAwareRepository = (CustomSourceDirectoryAwareRepository)Narrow.to((Object)repository, CustomSourceDirectoryAwareRepository.class);
            if (customSourceDirectoryAwareRepository != null) {
                String vcsRevisionKey2 = customSourceDirectoryAwareRepository.retrieveSourceCode(buildContext, targetRevision.getVcsRevisionKey(), targetPath);
                return new VcsWorkingCopy(repositoryData.getId(), targetPath, vcsRevisionKey2);
            }
            LegacyRepository legacyRepository = (LegacyRepository)Narrow.to((Object)repository, LegacyRepository.class);
            if (legacyRepository != null) {
                log.info((Object)"Repository does not support checkout to subdirectory, falling back to the old method");
                vcsRevisionKey = legacyRepository.retrieveSourceCode(buildContext, targetRevision.getVcsRevisionKey());
            } else {
                throw new UnsupportedOperationException("This repository does not support checking out to arbitrary directory");
            }
        }
        this.afterRetrieve(buildContext, repository, buildLogger, targetPath);
        return new VcsWorkingCopy(repositoryData.getId(), targetPath, vcsRevisionKey);
    }

    @NotNull
    public VcsWorkingCopy updateToLatestRevision(@NotNull CommonContext commonContext, @NotNull VcsRepositoryData repositoryData, @NotNull File targetPath) throws RepositoryException {
        Repository repository = this.getRepositoryInstance(repositoryData);
        BuildRepositoryChanges changes = repository.collectChangesSinceLastBuild(commonContext.getEntityKey().getKey(), null);
        String targetRevision = changes.getVcsRevisionKey();
        return this.retrieveSourceCode(commonContext, repositoryData, new PlanVcsRevisionData(targetRevision, null), targetPath);
    }

    @NotNull
    public VcsWorkingCopy checkoutAndMerge(@NotNull CommonContext commonContext, @NotNull VcsRepositoryData vcsRepositoryData, @NotNull VcsBranch targetBranch, @NotNull PlanVcsRevisionData revisionOnTarget, @NotNull VcsBranch sourceBranch, @NotNull PlanVcsRevisionData sourceRevision, @NotNull File targetPath) throws RepositoryException {
        BranchMergingAwareRepository bmar = this.getNewRepositoryInstanceAs(vcsRepositoryData, BranchMergingAwareRepository.class);
        bmar.setVcsBranch(targetBranch);
        BuildContext buildContext = this.getBuildContext(commonContext);
        bmar.retrieveSourceCode(buildContext, revisionOnTarget.getVcsRevisionKey(), targetPath, 1);
        bmar.setVcsBranch(sourceBranch);
        boolean dirty = bmar.mergeWorkspaceWith(buildContext, targetPath, sourceRevision.getVcsRevisionKey());
        return new VcsWorkingCopy(vcsRepositoryData.getId(), targetPath, dirty ? revisionOnTarget.getVcsRevisionKey() : sourceRevision.getVcsRevisionKey(), dirty);
    }

    @NotNull
    public VcsWorkingCopy commitLocal(@NotNull VcsWorkingCopy workingCopy, @NotNull VcsRepositoryData vcsRepositoryData, @NotNull String commitMessage) throws RepositoryException {
        PushCapableRepository pcr = this.getRepositoryInstanceAs(vcsRepositoryData, PushCapableRepository.class);
        String newRevision = pcr.commit(workingCopy.getPath(), commitMessage);
        return new VcsWorkingCopy(vcsRepositoryData.getId(), workingCopy.getPath(), newRevision, false);
    }

    @NotNull
    public VcsWorkingCopy updateRemote(@NotNull VcsWorkingCopy workingCopy, @NotNull VcsRepositoryData vcsRepositoryData, @NotNull String commitMessage) throws RepositoryException {
        PushCapableRepository pcr = this.getRepositoryInstanceAs(vcsRepositoryData, PushCapableRepository.class);
        pcr.pushRevision(workingCopy.getPath(), workingCopy.getCurrentRevisionKey());
        return new VcsWorkingCopy(vcsRepositoryData.getId(), workingCopy.getPath(), workingCopy.getCurrentRevisionKey(), false);
    }
}

