/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.vcs.configuration.legacy.configurator;

import com.atlassian.bamboo.build.creation.RepositoryConfigHelper;
import com.atlassian.bamboo.repository.MavenPomAccessorCapableRepository;
import com.atlassian.bamboo.repository.Repository;
import com.atlassian.bamboo.repository.plugin.RepositoryModuleDescriptor;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.vcs.configuration.VcsRepositoryData;
import com.atlassian.bamboo.vcs.configuration.legacy.LegacyExecutorBase;
import com.atlassian.bamboo.vcs.configurator.VcsMavenPomAccessor;
import com.atlassian.bamboo.ww2.actions.build.admin.create.BuildConfiguration;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LegacyMavenPomAccessor
extends LegacyExecutorBase
implements VcsMavenPomAccessor {
    public LegacyMavenPomAccessor(RepositoryModuleDescriptor repositoryModuleDescriptor) {
        super(repositoryModuleDescriptor);
    }

    @NotNull
    public String getMavenScmProviderKey() {
        MavenPomAccessorCapableRepository mpacr = (MavenPomAccessorCapableRepository)Narrow.downTo((Object)this.repositoryModuleDescriptor.getModule(), MavenPomAccessorCapableRepository.class);
        Preconditions.checkState((mpacr != null ? 1 : 0) != 0);
        return mpacr.getMavenPomAccessor().getMavenScmProviderKey();
    }

    public Map<String, String> parseMavenScmUrlToVcsLocation(@NotNull String mavenScmUrl, @Nullable VcsRepositoryData existingData) throws IllegalArgumentException {
        MavenPomAccessorCapableRepository repository;
        if (existingData != null) {
            repository = this.getNewRepositoryInstanceAs(existingData, MavenPomAccessorCapableRepository.class);
            Preconditions.checkState((repository != null ? 1 : 0) != 0);
        } else {
            repository = (MavenPomAccessorCapableRepository)Narrow.downTo((Object)this.repositoryModuleDescriptor.getModule(), MavenPomAccessorCapableRepository.class);
            Preconditions.checkState((repository != null ? 1 : 0) != 0);
            BuildConfiguration buildConfiguration = new BuildConfiguration();
            repository.getMavenPomAccessor().addDefaultValues(buildConfiguration);
            repository.prepareConfigObject(buildConfiguration);
            repository.populateFromConfig((HierarchicalConfiguration)buildConfiguration);
        }
        repository.getMavenPomAccessor().parseMavenScmUrl(mavenScmUrl);
        return ImmutableMap.of((Object)"legacyXml", (Object)RepositoryConfigHelper.prepareXmlConfigurationString((Repository)repository, null));
    }
}

