/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.vcs.configuration.legacy.configurator;

import com.atlassian.bamboo.configuration.external.exporters.HierarchicalConfigurationExporterInternal;
import com.atlassian.bamboo.repository.plugin.RepositoryModuleDescriptor;
import com.atlassian.bamboo.specs.api.builders.AtlassianModule;
import com.atlassian.bamboo.specs.api.builders.EntityPropertiesBuilder;
import com.atlassian.bamboo.specs.api.builders.repository.AnyVcsRepository;
import com.atlassian.bamboo.specs.api.builders.repository.VcsChangeDetection;
import com.atlassian.bamboo.specs.api.model.repository.AnyVcsRepositoryProperties;
import com.atlassian.bamboo.specs.api.model.repository.VcsChangeDetectionProperties;
import com.atlassian.bamboo.specs.api.util.EntityPropertiesBuilders;
import com.atlassian.bamboo.utils.ConfigUtils;
import com.atlassian.bamboo.vcs.configuration.VcsBranchDefinition;
import com.atlassian.bamboo.vcs.configuration.VcsBranchDetectionOptions;
import com.atlassian.bamboo.vcs.configuration.VcsChangeDetectionOptions;
import com.atlassian.bamboo.vcs.configuration.VcsLocationDefinition;
import com.atlassian.bamboo.vcs.configuration.VcsLocationDefinitionImpl;
import com.atlassian.bamboo.vcs.configuration.VcsRepositoryData;
import com.atlassian.bamboo.vcs.configuration.legacy.configurator.LegacyVcsLocationConfigurator;
import com.atlassian.bamboo.vcs.export.VcsRepositoryDataExporter;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableMap;
import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LegacyRepositoryConfigurationExporter
extends LegacyVcsLocationConfigurator
implements VcsRepositoryDataExporter<AnyVcsRepository, AnyVcsRepositoryProperties> {
    private HierarchicalConfigurationExporterInternal hierarchicalConfigurationExporter = new HierarchicalConfigurationExporterInternal();
    private static final BiMap<VcsChangeDetection.FileFilteringOption, String> FILE_PATTERN_OPTION_MAP = ImmutableBiMap.of((Object)VcsChangeDetection.FileFilteringOption.EXCLUDE_ALL, (Object)"excludeAll", (Object)VcsChangeDetection.FileFilteringOption.INCLUDE_ONLY, (Object)"includeOnly", (Object)VcsChangeDetection.FileFilteringOption.NONE, (Object)"none");
    private static final VcsChangeDetection.FileFilteringOption DEFAULT_FILE_PATTERN_OPTION = VcsChangeDetection.FileFilteringOption.NONE;

    public LegacyRepositoryConfigurationExporter(RepositoryModuleDescriptor repositoryModuleDescriptor) {
        super(repositoryModuleDescriptor);
    }

    @NotNull
    public AnyVcsRepository getEntityPropertiesBuilder(@NotNull VcsRepositoryData repositoryData) {
        return new AnyVcsRepository(new AtlassianModule(repositoryData.getPluginKey()));
    }

    @NotNull
    public AnyVcsRepository appendLocationData(@NotNull AnyVcsRepository builder, @NotNull VcsLocationDefinition vcsLocationDefinition) {
        if (this.repositoryModuleDescriptor != null) {
            return builder.serverConfiguration(this.hierarchicalConfigurationExporter.generateDataMap(this.getRepositoryInstance(vcsLocationDefinition).toConfiguration()));
        }
        return builder.serverConfiguration(this.hierarchicalConfigurationExporter.generateDataMap(((VcsLocationDefinitionImpl)vcsLocationDefinition).getConfigurationRef().get()));
    }

    @NotNull
    public AnyVcsRepository appendBranchData(@NotNull AnyVcsRepository builder, @NotNull VcsBranchDefinition vcsBranchDefinition) {
        return builder;
    }

    @NotNull
    public AnyVcsRepository appendChangeDetectionOptions(@NotNull AnyVcsRepository builder, @NotNull VcsChangeDetectionOptions changeDetectionOptions) {
        VcsChangeDetection.FileFilteringOption fileFilteringOption = Optional.ofNullable(changeDetectionOptions.getFilterFilePatternOption()).filter(StringUtils::isNotBlank).map(arg_0 -> FILE_PATTERN_OPTION_MAP.inverse().get(arg_0)).orElse(DEFAULT_FILE_PATTERN_OPTION);
        return builder.changeDetectionConfiguration(new VcsChangeDetection().configuration(Collections.emptyMap()).commitIsolationEnabled(changeDetectionOptions.isCommitIsolationEnabled()).quietPeriodEnabled(changeDetectionOptions.isQuietPeriodEnabled()).quietPeriod(Duration.ofSeconds(changeDetectionOptions.getQuietPeriod())).quietPeriodMaxRetries(changeDetectionOptions.getMaxRetries()).changesetFilterPatternRegex(changeDetectionOptions.getChangesetFilterPatternRegex()).filterFilePatternOption(fileFilteringOption).filterFilePatternRegex(changeDetectionOptions.getFilterFilePatternRegex()));
    }

    @NotNull
    public AnyVcsRepository appendBranchDetectionOptions(@NotNull AnyVcsRepository builder, @NotNull VcsBranchDetectionOptions branchDetectionOptions) {
        return builder;
    }

    @NotNull
    public Map<String, String> importLocationData(@NotNull AnyVcsRepositoryProperties properties, @Nullable VcsLocationDefinition existingData) {
        HierarchicalConfiguration hierarchicalConfiguration = this.hierarchicalConfigurationExporter.fromDataMap(properties.getServerConfiguration());
        return ImmutableMap.of((Object)"legacyXml", (Object)ConfigUtils.asXmlString((HierarchicalConfiguration)hierarchicalConfiguration));
    }

    @Nullable
    public Map<String, String> importBranchData(@NotNull AnyVcsRepositoryProperties properties, @Nullable VcsBranchDefinition existingData) {
        return null;
    }

    @Nullable
    public Map<String, String> importChangeDetectionOptions(@NotNull AnyVcsRepositoryProperties properties, @Nullable VcsChangeDetectionOptions existingData) {
        VcsChangeDetectionProperties changeDetectionConfiguration = properties.getChangeDetectionConfiguration();
        if (changeDetectionConfiguration == null) {
            if (!properties.hasParent()) {
                changeDetectionConfiguration = (VcsChangeDetectionProperties)EntityPropertiesBuilders.build((EntityPropertiesBuilder)new VcsChangeDetection());
            } else {
                return null;
            }
        }
        HashMap<String, String> changeDetectionConfigurationMap = new HashMap<String, String>();
        changeDetectionConfigurationMap.put("commit.isolation.option", Boolean.toString(changeDetectionConfiguration.isCommitIsolationEnabled()));
        changeDetectionConfigurationMap.put("repository.common.quietPeriod.enabled", Boolean.toString(changeDetectionConfiguration.isQuietPeriodEnabled()));
        changeDetectionConfigurationMap.put("repository.common.quietPeriod.period", String.valueOf(changeDetectionConfiguration.getQuietPeriod().getSeconds()));
        changeDetectionConfigurationMap.put("repository.common.quietPeriod.maxRetries", String.valueOf(changeDetectionConfiguration.getMaxRetries()));
        VcsChangeDetection.FileFilteringOption fileFilteringOption = changeDetectionConfiguration.getFilterFilePatternOption() != null ? changeDetectionConfiguration.getFilterFilePatternOption() : DEFAULT_FILE_PATTERN_OPTION;
        changeDetectionConfigurationMap.put("filter.pattern.option", (String)FILE_PATTERN_OPTION_MAP.get((Object)fileFilteringOption));
        changeDetectionConfigurationMap.put("filter.pattern.regex", StringUtils.defaultString((String)changeDetectionConfiguration.getFilterFilePatternRegex()));
        changeDetectionConfigurationMap.put("changeset.filter.pattern.regex", StringUtils.defaultString((String)changeDetectionConfiguration.getChangesetFilterPatternRegex()));
        return changeDetectionConfigurationMap;
    }

    @NotNull
    public Map<String, String> importBranchDetectionOptions(@NotNull AnyVcsRepositoryProperties properties, @Nullable VcsBranchDetectionOptions existingData) {
        return Collections.emptyMap();
    }
}

