/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.vcs.configuration.legacy.configurator;

import com.atlassian.bamboo.build.creation.RepositoryConfigHelper;
import com.atlassian.bamboo.collections.ActionParametersMap;
import com.atlassian.bamboo.credentials.SharedCredentialDepender;
import com.atlassian.bamboo.plugin.BambooPluginUtils;
import com.atlassian.bamboo.repository.PreparableRepository;
import com.atlassian.bamboo.repository.Repository;
import com.atlassian.bamboo.repository.ScmTypePublishingRepository;
import com.atlassian.bamboo.repository.TestConnectionAwareRepository;
import com.atlassian.bamboo.repository.plugin.RepositoryModuleDescriptor;
import com.atlassian.bamboo.repository.ui.EditActionAwareRepository;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bamboo.utils.error.SimpleErrorCollection;
import com.atlassian.bamboo.v2.build.agent.capability.AgentContext;
import com.atlassian.bamboo.vcs.configuration.VcsLocationDefinition;
import com.atlassian.bamboo.vcs.configuration.VcsLocationDefinitionImpl;
import com.atlassian.bamboo.vcs.configuration.legacy.LegacyExecutorBase;
import com.atlassian.bamboo.vcs.configurator.VcsLocationConfigurator;
import com.atlassian.bamboo.vcs.configurator.VcsType;
import com.atlassian.bamboo.web.utils.BuildConfigurationActionHelper;
import com.atlassian.bamboo.ww2.actions.build.admin.create.BuildConfiguration;
import com.atlassian.spring.container.ContainerManager;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LegacyVcsLocationConfigurator
extends LegacyExecutorBase
implements VcsLocationConfigurator {
    private static final Logger log = Logger.getLogger(LegacyVcsLocationConfigurator.class);
    public static final String LEGACY_XML = "legacyXml";

    public LegacyVcsLocationConfigurator(RepositoryModuleDescriptor repositoryModuleDescriptor) {
        super(repositoryModuleDescriptor);
    }

    public void populateContextForCreate(@NotNull Map<String, Object> context) {
        Repository repository = (Repository)this.repositoryModuleDescriptor.getModule();
        BuildConfiguration bc = new BuildConfiguration();
        repository.addDefaultValues(bc);
        this.populateStackFromBuildConfiguration(context, (HierarchicalConfiguration)bc, repository);
    }

    protected Repository getRepositoryInstance(@Nullable VcsLocationDefinition vcsLocationDefinition) {
        Repository repository = (Repository)this.repositoryModuleDescriptor.getModule();
        if (vcsLocationDefinition != null) {
            AgentContext agentContext;
            Preconditions.checkState((boolean)vcsLocationDefinition.isLegacyRepository(), (Object)"Not a legacy repository");
            HierarchicalConfiguration bc = ((VcsLocationDefinitionImpl)vcsLocationDefinition).getConfigurationRef().get();
            repository.populateFromConfig(bc);
            PreparableRepository preparableRepository = (PreparableRepository)Narrow.downTo((Object)repository, PreparableRepository.class);
            if (preparableRepository != null && ((agentContext = (AgentContext)ContainerManager.getComponent((String)"agentContext")) == null || agentContext.getBuildAgent() == null)) {
                preparableRepository.onPrepare(bc);
            }
        }
        return repository;
    }

    private void populateStackFromBuildConfiguration(Map<String, Object> map, HierarchicalConfiguration buildConfiguration, Repository repository) {
        map.put("buildConfiguration", buildConfiguration);
        map.put("repository", repository);
        Iterator iterator = buildConfiguration.getKeys();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            Object value = this.getValue(buildConfiguration, key);
            map.put(key, value);
        }
    }

    private void copyModifiedConfigBackToApm(ActionParametersMap apm, HierarchicalConfiguration buildConfiguration) {
        Iterator iterator = buildConfiguration.getKeys();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            Object value = this.getValue(buildConfiguration, key);
            if (!(value instanceof File)) {
                apm.put((Object)key, value);
                continue;
            }
            apm.getFiles().put(key, (File)value);
        }
    }

    private Object getValue(HierarchicalConfiguration buildConfiguration, String key) {
        int maxIndex = buildConfiguration.getMaxIndex(key);
        Object value = maxIndex > 0 ? buildConfiguration.getList(key) : buildConfiguration.getProperty(key);
        return value;
    }

    public void populateContextForEdit(@NotNull Map<String, Object> context, @NotNull VcsLocationDefinition vcsLocationDefinition) {
        HierarchicalConfiguration bc;
        Repository repository;
        if (vcsLocationDefinition.isLegacyRepository()) {
            repository = (Repository)this.repositoryModuleDescriptor.getModule();
            bc = ((VcsLocationDefinitionImpl)vcsLocationDefinition).getConfigurationRef().get();
            repository.populateFromConfig(bc);
            EditActionAwareRepository eaar = (EditActionAwareRepository)Narrow.downTo((Object)repository, EditActionAwareRepository.class);
            if (eaar != null) {
                eaar.beforeEditPageRendering(bc);
            }
        } else {
            throw new IllegalStateException("Not a legacy repository");
        }
        this.populateStackFromBuildConfiguration(context, bc, repository);
    }

    public void populateContextForView(@NotNull Map<String, Object> context, @NotNull VcsLocationDefinition vcsLocationDefinition) {
        if (!vcsLocationDefinition.isLegacyRepository()) {
            throw new IllegalStateException("Not a legacy repository");
        }
        Repository repository = (Repository)this.repositoryModuleDescriptor.getModule();
        HierarchicalConfiguration bc = ((VcsLocationDefinitionImpl)vcsLocationDefinition).getConfigurationRef().get();
        repository.populateFromConfig(bc);
        this.populateStackFromBuildConfiguration(context, bc, repository);
    }

    public void validate(@NotNull ActionParametersMap actionParametersMap, @Nullable VcsLocationDefinition previousDefinition, final @NotNull ErrorCollection errorCollection) {
        EditActionAwareRepository eaar;
        final Repository repository = this.getRepositoryInstance(previousDefinition);
        final BuildConfiguration buildConfiguration = this.getBuildConfiguration(previousDefinition, repository);
        BuildConfigurationActionHelper.copyParamsToBuildConfiguration(actionParametersMap, buildConfiguration);
        repository.prepareConfigObject(buildConfiguration);
        final String message = "Failed to validate build configuration for the " + repository.getName() + " repository (" + repository.getKey() + ").";
        ErrorCollection myErrorCollection = BambooPluginUtils.callUnsafeCode(new BambooPluginUtils.NoThrowCallable<ErrorCollection>(message){

            @Override
            public ErrorCollection call() {
                return repository.validate(buildConfiguration);
            }

            @Override
            public void onThrow(@NotNull Throwable t) {
                SimpleErrorCollection exception = new SimpleErrorCollection(message + " " + t.getMessage());
                errorCollection.addErrorCollection((ErrorCollection)exception);
            }
        });
        errorCollection.addErrorCollection(myErrorCollection);
        if (!myErrorCollection.hasAnyErrors() && (eaar = (EditActionAwareRepository)Narrow.downTo((Object)repository, EditActionAwareRepository.class)) != null) {
            myErrorCollection = BambooPluginUtils.callUnsafeCode(new BambooPluginUtils.NoThrowCallable<ErrorCollection>(message){

                @Override
                public ErrorCollection call() {
                    return eaar.beforeSave((HierarchicalConfiguration)buildConfiguration);
                }

                @Override
                public void onThrow(@NotNull Throwable t) {
                    SimpleErrorCollection exception = new SimpleErrorCollection(message + " " + t.getMessage());
                    errorCollection.addErrorCollection((ErrorCollection)exception);
                }
            });
            errorCollection.addErrorCollection(myErrorCollection);
            this.copyModifiedConfigBackToApm(actionParametersMap, (HierarchicalConfiguration)buildConfiguration);
        }
    }

    public void validateForConnectionTesting(@NotNull ActionParametersMap actionParametersMap, @Nullable VcsLocationDefinition previousDefinition, final @NotNull ErrorCollection errorCollection) {
        final Repository repository = this.getRepositoryInstance(previousDefinition);
        final BuildConfiguration buildConfiguration = this.getBuildConfiguration(previousDefinition, repository);
        BuildConfigurationActionHelper.copyParamsToBuildConfiguration(actionParametersMap, buildConfiguration);
        repository.prepareConfigObject(buildConfiguration);
        final String message = "Failed to validate build configuration for the " + repository.getName() + " repository (" + repository.getKey() + ").";
        ErrorCollection myErrorCollection = BambooPluginUtils.callUnsafeCode(new BambooPluginUtils.NoThrowCallable<ErrorCollection>(message){

            @Override
            public ErrorCollection call() {
                TestConnectionAwareRepository tcar = (TestConnectionAwareRepository)Narrow.downTo((Object)repository, TestConnectionAwareRepository.class);
                if (tcar != null) {
                    return tcar.validateForConnectionTesting(buildConfiguration);
                }
                throw new IllegalStateException("Attempt to invoke test connection on repository that does not support it");
            }

            @Override
            public void onThrow(@NotNull Throwable t) {
                SimpleErrorCollection exception = new SimpleErrorCollection(message + " " + t.getMessage());
                errorCollection.addErrorCollection((ErrorCollection)exception);
            }
        });
        errorCollection.addErrorCollection(myErrorCollection);
    }

    @NotNull
    private BuildConfiguration getBuildConfiguration(@Nullable VcsLocationDefinition previousDefinition, Repository repository) {
        if (previousDefinition == null) {
            BuildConfiguration buildConfiguration = new BuildConfiguration();
            repository.addDefaultValues(buildConfiguration);
            return buildConfiguration;
        }
        return new BuildConfiguration(repository.toConfiguration());
    }

    @NotNull
    public Map<String, String> generateConfigMap(@NotNull ActionParametersMap actionParametersMap, @Nullable VcsLocationDefinition previousDefinition) {
        Repository oldRepository = this.getRepositoryInstance(previousDefinition);
        BuildConfiguration buildConfiguration = this.getBuildConfiguration(previousDefinition, oldRepository);
        BuildConfigurationActionHelper.copyParamsToBuildConfiguration(actionParametersMap, buildConfiguration);
        Repository repository = (Repository)this.repositoryModuleDescriptor.getModule();
        repository.prepareConfigObject(buildConfiguration);
        repository.populateFromConfig((HierarchicalConfiguration)buildConfiguration);
        return ImmutableMap.of((Object)LEGACY_XML, (Object)RepositoryConfigHelper.prepareXmlConfigurationString(repository, null));
    }

    public void addDefaultsForAdvancedOptions(@NotNull Map<String, String> cfgMap) {
    }

    @NotNull
    public String getLocationIdentifier(@NotNull VcsLocationDefinition vcsLocationDefinition) {
        Repository repository = this.getRepositoryInstance(vcsLocationDefinition);
        return repository.getLocationIdentifier();
    }

    @NotNull
    public String getServerHost(@NotNull VcsLocationDefinition vcsLocationDefinition) {
        Repository repository = this.getRepositoryInstance(vcsLocationDefinition);
        return repository.getHost();
    }

    @NotNull
    public Iterable<Long> getSharedCredentialsIds(@NotNull VcsLocationDefinition vcsLocationDefinition) {
        Repository repository = this.getRepositoryInstance(vcsLocationDefinition);
        SharedCredentialDepender scd = (SharedCredentialDepender)Narrow.reinterpret((Object)repository, SharedCredentialDepender.class);
        if (scd != null) {
            return scd.getSharedCredentialIds();
        }
        return Collections.emptyList();
    }

    public Optional<VcsType> getScmType(@NotNull VcsLocationDefinition vcsLocationDefinition) {
        Repository repository = this.getRepositoryInstance(vcsLocationDefinition);
        ScmTypePublishingRepository scmTypePublishingRepository = (ScmTypePublishingRepository)Narrow.downTo((Object)repository, ScmTypePublishingRepository.class);
        if (scmTypePublishingRepository != null) {
            return Optional.of(new VcsType(scmTypePublishingRepository.getScm()));
        }
        return Optional.empty();
    }
}

