/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.vcs.configuration.service;

import com.atlassian.annotations.Internal;
import com.atlassian.bamboo.plan.branch.VcsBranch;
import com.atlassian.bamboo.vcs.configuration.service.RawRepositoryConfiguration;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.io.Serializable;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

@XStreamAlias(value="repository")
@Internal
public final class RawRepositoryConfigurationImpl
implements RawRepositoryConfiguration,
Serializable {
    private final Map<String, String> serverConfiguration;
    private final Map<String, String> changeDetectionConfiguration;
    private final Map<String, String> branchDetectionConfiguration;
    private final Map<String, String> branchConfiguration;
    private final Map<String, String> bambooSpecsDetectionConfiguration;
    private final VcsBranch vcsBranch;
    private final String viewerPluginKey;
    private final Map<String, String> viewerConfiguration;
    private final String legacyXml;
    private final String legacyViewerXml;

    private RawRepositoryConfigurationImpl(VcsBranch vcsBranch, String viewerPluginKey, Map<String, String> serverConfiguration, Map<String, String> changeDetectionConfiguration, Map<String, String> branchDetectionConfiguration, Map<String, String> branchConfiguration, Map<String, String> viewerConfiguration, Map<String, String> bambooSpecsDetectionConfiguration, String legacyXml, String legacyViewerXml) {
        this.vcsBranch = vcsBranch;
        this.serverConfiguration = serverConfiguration;
        this.changeDetectionConfiguration = changeDetectionConfiguration;
        this.branchDetectionConfiguration = branchDetectionConfiguration;
        this.branchConfiguration = branchConfiguration;
        this.bambooSpecsDetectionConfiguration = bambooSpecsDetectionConfiguration;
        this.viewerConfiguration = viewerConfiguration;
        this.viewerPluginKey = viewerPluginKey;
        this.legacyXml = legacyXml;
        this.legacyViewerXml = legacyViewerXml;
    }

    @Override
    @Nullable
    public VcsBranch getVcsBranch() {
        return this.vcsBranch;
    }

    @Override
    public Map<String, String> getServerConfiguration() {
        return this.serverConfiguration;
    }

    @Override
    @Nullable
    public Map<String, String> getChangeDetectionConfiguration() {
        return this.changeDetectionConfiguration;
    }

    @Override
    @Nullable
    public Map<String, String> getBranchDetectionConfiguration() {
        return this.branchDetectionConfiguration;
    }

    @Override
    @Nullable
    public Map<String, String> getBranchConfiguration() {
        return this.branchConfiguration;
    }

    @Override
    @Nullable
    public Map<String, String> getBambooSpecsDetectionConfiguration() {
        return this.bambooSpecsDetectionConfiguration;
    }

    @Override
    @Nullable
    public String getViewerPluginKey() {
        return this.viewerPluginKey;
    }

    @Override
    @Nullable
    public Map<String, String> getViewerConfiguration() {
        return this.viewerConfiguration;
    }

    @Override
    @Nullable
    public String getLegacyXml() {
        return this.legacyXml;
    }

    @Override
    @Nullable
    public String getLegacyViewerXml() {
        return this.legacyViewerXml;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private VcsBranch vcsBranch;
        private String viewerPluginKey;
        private Map<String, String> serverConfiguration;
        private Map<String, String> changeDetectionConfiguration;
        private Map<String, String> branchDetectionConfiguration;
        private Map<String, String> branchConfiguration;
        private Map<String, String> viewerConfiguration;
        private Map<String, String> bambooSpecsDetectionConfiguration;
        private String legacyXml;
        private String legacyViewerXml;

        private Builder() {
        }

        public Builder serverConfiguration(Map<String, String> serverConfiguration) {
            this.serverConfiguration = serverConfiguration;
            return this;
        }

        public Builder changeDetectionConfiguration(Map<String, String> changeDetectionConfiguration) {
            this.changeDetectionConfiguration = changeDetectionConfiguration;
            return this;
        }

        public Builder branchDetectionConfiguration(Map<String, String> branchDetectionConfiguration) {
            this.branchDetectionConfiguration = branchDetectionConfiguration;
            return this;
        }

        public Builder branchConfiguration(Map<String, String> branchConfiguration) {
            this.branchConfiguration = branchConfiguration;
            return this;
        }

        public Builder bambooSpecsDetectionConfiguration(Map<String, String> bambooSpecsDetectionConfiguration) {
            this.bambooSpecsDetectionConfiguration = bambooSpecsDetectionConfiguration;
            return this;
        }

        public Builder vcsBranch(VcsBranch vcsBranch) {
            this.vcsBranch = vcsBranch;
            return this;
        }

        public Builder viewerPluginKey(String viewerPluginKey) {
            this.viewerPluginKey = viewerPluginKey;
            return this;
        }

        public Builder viewerConfiguration(Map<String, String> viewerConfiguration) {
            this.viewerConfiguration = viewerConfiguration;
            return this;
        }

        public Builder legacyXml(String legacyXml) {
            this.legacyXml = legacyXml;
            return this;
        }

        public Builder legacyViewerXml(String legacyViewerXml) {
            this.legacyViewerXml = legacyViewerXml;
            return this;
        }

        public Builder copyOf(RawRepositoryConfigurationImpl rawRepositoryConfiguration) {
            this.vcsBranch = rawRepositoryConfiguration.vcsBranch;
            this.viewerPluginKey = rawRepositoryConfiguration.viewerPluginKey;
            this.serverConfiguration = rawRepositoryConfiguration.serverConfiguration;
            this.changeDetectionConfiguration = rawRepositoryConfiguration.changeDetectionConfiguration;
            this.branchDetectionConfiguration = rawRepositoryConfiguration.branchDetectionConfiguration;
            this.branchConfiguration = rawRepositoryConfiguration.branchConfiguration;
            this.viewerConfiguration = rawRepositoryConfiguration.viewerConfiguration;
            this.bambooSpecsDetectionConfiguration = rawRepositoryConfiguration.bambooSpecsDetectionConfiguration;
            this.legacyXml = rawRepositoryConfiguration.legacyXml;
            this.legacyViewerXml = rawRepositoryConfiguration.legacyViewerXml;
            return this;
        }

        public RawRepositoryConfigurationImpl build() {
            return new RawRepositoryConfigurationImpl(this.vcsBranch, this.viewerPluginKey, this.serverConfiguration, this.changeDetectionConfiguration, this.branchDetectionConfiguration, this.branchConfiguration, this.viewerConfiguration, this.bambooSpecsDetectionConfiguration, this.legacyXml, this.legacyViewerXml);
        }
    }
}

