/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.vcs.configuration.service;

import com.atlassian.bamboo.persister.xstream.XStreamFactory;
import com.atlassian.bamboo.repository.RepositoryDataEntity;
import com.atlassian.bamboo.spring.ComponentAccessor;
import com.atlassian.bamboo.vcs.configuration.PartialVcsRepositoryData;
import com.atlassian.bamboo.vcs.configuration.legacy.configurator.LegacyBranchConfigurator;
import com.atlassian.bamboo.vcs.configuration.service.RawRepositoryConfiguration;
import com.atlassian.bamboo.vcs.configuration.service.RawRepositoryConfigurationImpl;
import com.atlassian.bamboo.vcs.configuration.service.RawRepositoryConfigurationXmlConverter;
import com.atlassian.bamboo.vcs.module.VcsRepositoryManager;
import com.atlassian.bamboo.vcs.module.VcsRepositoryModuleDescriptor;
import com.atlassian.bamboo.vcs.viewer.configuration.VcsRepositoryViewerDefinition;
import com.thoughtworks.xstream.XStream;
import java.util.Collections;
import java.util.HashMap;
import org.jetbrains.annotations.NotNull;

public class RawRepositoryConfigurationXmlConverterImpl
implements RawRepositoryConfigurationXmlConverter {
    private final XStream xStream;

    public RawRepositoryConfigurationXmlConverterImpl(XStreamFactory xStreamFactory) {
        this.xStream = xStreamFactory.createCompactXStream();
        this.xStream.processAnnotations(RawRepositoryConfigurationImpl.class);
    }

    @Override
    @NotNull
    public final RawRepositoryConfiguration fromVcsData(@NotNull PartialVcsRepositoryData repositoryData) {
        VcsRepositoryViewerDefinition vrvd;
        RawRepositoryConfigurationImpl.Builder builder = RawRepositoryConfigurationImpl.builder();
        if (repositoryData.getVcsLocation() != null) {
            builder.serverConfiguration(repositoryData.getVcsLocation().getConfiguration());
            builder.legacyXml(repositoryData.getVcsLocation().getLegacyConfigurationXml());
        }
        if (repositoryData.getBranch() != null) {
            builder.vcsBranch(repositoryData.getBranch().getVcsBranch()).branchConfiguration(repositoryData.getBranch().getConfiguration());
        }
        if (repositoryData.getVcsChangeDetectionOptions() != null) {
            builder.changeDetectionConfiguration(repositoryData.getVcsChangeDetectionOptions().getConfiguration());
        }
        if (repositoryData.getVcsBranchDetectionOptions() != null) {
            builder.branchDetectionConfiguration(repositoryData.getVcsBranchDetectionOptions().getConfiguration());
        }
        if (repositoryData.getBambooSpecsConfiguration() != null) {
            builder.bambooSpecsDetectionConfiguration(repositoryData.getBambooSpecsConfiguration().getConfiguration());
        }
        if ((vrvd = repositoryData.getViewerConfiguration()) != null) {
            builder.viewerPluginKey(vrvd.getPluginKey());
            builder.viewerConfiguration(vrvd.getConfiguration());
            builder.legacyViewerXml(vrvd.getLegacyConfigurationXml());
        }
        return builder.build();
    }

    public static boolean isEntityIn514Format(@NotNull RepositoryDataEntity entity) {
        return entity.getXmlData().startsWith("<repository");
    }

    @Override
    @NotNull
    public final RawRepositoryConfiguration fromEntity(@NotNull RepositoryDataEntity entity) {
        String xml = entity.getXmlData();
        if (RawRepositoryConfigurationXmlConverterImpl.isEntityIn514Format(entity)) {
            VcsRepositoryModuleDescriptor vcsRepositoryModuleDescriptor;
            RawRepositoryConfigurationImpl rawRepositoryConfiguration = (RawRepositoryConfigurationImpl)this.xStream.fromXML(xml);
            if (rawRepositoryConfiguration.getLegacyXml() != null && rawRepositoryConfiguration.getVcsBranch() == null && (vcsRepositoryModuleDescriptor = ((VcsRepositoryManager)ComponentAccessor.VCS_REPOSITORY_MANAGER.get()).getVcsRepositoryModuleDescriptor(entity.getPluginKey())) != null && vcsRepositoryModuleDescriptor.getVcsBranchConfigurator() != null) {
                LegacyBranchConfigurator legacyBranchConfigurator = (LegacyBranchConfigurator)vcsRepositoryModuleDescriptor.getVcsBranchConfigurator();
                return RawRepositoryConfigurationImpl.builder().copyOf(rawRepositoryConfiguration).vcsBranch(legacyBranchConfigurator.getVcsBranchFromRepositoryXml(rawRepositoryConfiguration.getLegacyXml())).branchConfiguration(new HashMap<String, String>()).build();
            }
            return rawRepositoryConfiguration;
        }
        RawRepositoryConfigurationImpl.Builder builder = RawRepositoryConfigurationImpl.builder().serverConfiguration(Collections.emptyMap()).legacyXml(xml);
        VcsRepositoryModuleDescriptor vcsRepositoryModuleDescriptor = ((VcsRepositoryManager)ComponentAccessor.VCS_REPOSITORY_MANAGER.get()).getVcsRepositoryModuleDescriptor(entity.getPluginKey());
        if (vcsRepositoryModuleDescriptor != null && vcsRepositoryModuleDescriptor.getVcsBranchConfigurator() != null) {
            LegacyBranchConfigurator legacyBranchConfigurator = (LegacyBranchConfigurator)vcsRepositoryModuleDescriptor.getVcsBranchConfigurator();
            builder.vcsBranch(legacyBranchConfigurator.getVcsBranchFromRepositoryXml(entity.getXmlData()));
            builder.branchConfiguration(new HashMap<String, String>());
        }
        return builder.build();
    }

    @Override
    @NotNull
    public String emptyXml() {
        return this.xStream.toXML((Object)RawRepositoryConfigurationImpl.builder().build());
    }

    @Override
    @NotNull
    public String asXml(@NotNull PartialVcsRepositoryData configuration) {
        return this.asXml(this.fromVcsData(configuration));
    }

    @Override
    @NotNull
    public final String asXml(@NotNull RawRepositoryConfiguration configuration) {
        return this.xStream.toXML((Object)configuration);
    }
}

