/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.vcs.configuration.service;

import com.atlassian.bamboo.variable.CustomVariableContext;
import com.atlassian.bamboo.variable.substitutor.VariableSubstitutor;
import com.atlassian.bamboo.vcs.configuration.VcsRepositoryData;
import com.atlassian.bamboo.vcs.configuration.service.VcsRepositoryConfigurationComparator;
import com.atlassian.bamboo.vcs.module.VcsRepositoryModuleDescriptor;
import com.atlassian.bamboo.vcs.runtime.ContextualVcsId;
import com.atlassian.bamboo.vcs.runtime.VcsBranchDetector;
import com.atlassian.bamboo.vcs.runtime.VcsChangeDetector;
import java.util.Objects;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class VcsRepositoryConfigurationComparatorImpl
implements VcsRepositoryConfigurationComparator {
    private static final Logger log = Logger.getLogger(VcsRepositoryConfigurationComparatorImpl.class);
    private final CustomVariableContext customVariableContext;

    public VcsRepositoryConfigurationComparatorImpl(CustomVariableContext customVariableContext) {
        this.customVariableContext = customVariableContext;
    }

    @Override
    public boolean isTheSameVcsLocation(VcsRepositoryModuleDescriptor moduleDescriptor, VariableSubstitutor variableSubstitutor, @NotNull VcsRepositoryData first, @NotNull VcsRepositoryData second) {
        if (!first.getPluginKey().equals(second.getPluginKey())) {
            return false;
        }
        if (first.getVcsLocation().equals(second.getVcsLocation())) {
            return true;
        }
        return (Boolean)this.customVariableContext.withVariableSubstitutor(variableSubstitutor, () -> {
            VcsBranchDetector branchDetector = moduleDescriptor.getBranchDetector();
            if (branchDetector != null) {
                ContextualVcsId idOfA = branchDetector.getVcsIdForExecutor(first);
                return idOfA != null && idOfA.equals((Object)branchDetector.getVcsIdForExecutor(second));
            }
            return false;
        });
    }

    @Override
    public boolean isTheSameBranch(VcsRepositoryModuleDescriptor moduleDescriptor, VariableSubstitutor variableSubstitutor, @NotNull VcsRepositoryData first, @NotNull VcsRepositoryData second) {
        if (!first.getPluginKey().equals(second.getPluginKey())) {
            return false;
        }
        if (first.getVcsLocation().equals(second.getVcsLocation()) && Objects.equals(first.getBranch(), second.getBranch())) {
            return true;
        }
        return (Boolean)this.customVariableContext.withVariableSubstitutor(variableSubstitutor, () -> {
            VcsChangeDetector changeDetector = moduleDescriptor.getChangeDetector();
            if (changeDetector != null) {
                ContextualVcsId idOfA = changeDetector.getVcsIdForExecutor(first);
                return idOfA != null && idOfA.equals((Object)changeDetector.getVcsIdForExecutor(second));
            }
            return false;
        });
    }
}

