/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.vcs.configuration.service;

import com.atlassian.bamboo.Key;
import com.atlassian.bamboo.bandana.PlanAwareBandanaContext;
import com.atlassian.bamboo.build.BuildDefinition;
import com.atlassian.bamboo.build.BuildDefinitionManager;
import com.atlassian.bamboo.build.Job;
import com.atlassian.bamboo.chains.Chain;
import com.atlassian.bamboo.chains.ChainResultsSummary;
import com.atlassian.bamboo.chains.ImmutableChainResultsSummary;
import com.atlassian.bamboo.collections.message.FinalHashSet;
import com.atlassian.bamboo.core.BambooIdProvider;
import com.atlassian.bamboo.core.ScopedExclusionService;
import com.atlassian.bamboo.core.ScopedExclusionServiceHelper;
import com.atlassian.bamboo.deployments.environments.Environment;
import com.atlassian.bamboo.deployments.environments.service.EnvironmentTaskService;
import com.atlassian.bamboo.event.BuildConfigurationUpdatedEvent;
import com.atlassian.bamboo.event.analytics.GenericAnalyticsEvent;
import com.atlassian.bamboo.persister.AuditLogEntity;
import com.atlassian.bamboo.persister.AuditLogEntityType;
import com.atlassian.bamboo.persister.AuditLogService;
import com.atlassian.bamboo.plan.Plan;
import com.atlassian.bamboo.plan.PlanIdentifier;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.branch.BranchDetectionService;
import com.atlassian.bamboo.plan.branch.BranchMonitoringConfiguration;
import com.atlassian.bamboo.plan.branch.ChainBranch;
import com.atlassian.bamboo.plan.branch.ChainBranchManager;
import com.atlassian.bamboo.plan.branch.PlanBranchWorkflow;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.plan.cache.ImmutableJob;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.plan.cache.ImmutablePlanCacheService;
import com.atlassian.bamboo.repository.LegacyRepositoryDefinitionImpl;
import com.atlassian.bamboo.repository.PlanRepositoryLink;
import com.atlassian.bamboo.repository.PlanRepositoryLinkImpl;
import com.atlassian.bamboo.repository.RepositoryConfigurationService;
import com.atlassian.bamboo.repository.RepositoryConfigurationServiceImpl;
import com.atlassian.bamboo.repository.RepositoryDataEntity;
import com.atlassian.bamboo.repository.RepositoryDataEntityImpl;
import com.atlassian.bamboo.repository.RepositoryDefinitionManager;
import com.atlassian.bamboo.repository.RepositoryPredicates;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.atlassian.bamboo.resultsummary.vcs.RepositoryChangeset;
import com.atlassian.bamboo.security.acegi.acls.BambooPermission;
import com.atlassian.bamboo.security.acegi.acls.HibernateAclImpl;
import com.atlassian.bamboo.security.acegi.acls.HibernateMutableAclService;
import com.atlassian.bamboo.security.acegi.acls.HibernateObjectIdentityImpl;
import com.atlassian.bamboo.specs.RssPermissionManager;
import com.atlassian.bamboo.specs.api.exceptions.PropertiesValidationException;
import com.atlassian.bamboo.specs.api.validators.common.ValidationContext;
import com.atlassian.bamboo.specs.api.validators.common.ValidationProblem;
import com.atlassian.bamboo.task.TaskConfigurationService;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.trigger.TriggerConfigurationService;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.utils.BambooPredicates;
import com.atlassian.bamboo.utils.ConfigUtils;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bamboo.utils.error.SimpleErrorCollection;
import com.atlassian.bamboo.vcs.configuration.PartialVcsRepositoryData;
import com.atlassian.bamboo.vcs.configuration.PartialVcsRepositoryDataBuilder;
import com.atlassian.bamboo.vcs.configuration.PartialVcsRepositoryDataImpl;
import com.atlassian.bamboo.vcs.configuration.PlanRepositoryDefinition;
import com.atlassian.bamboo.vcs.configuration.PlanRepositoryDefinitionImpl;
import com.atlassian.bamboo.vcs.configuration.VcsRepositoryData;
import com.atlassian.bamboo.vcs.configuration.service.RawRepositoryConfiguration;
import com.atlassian.bamboo.vcs.configuration.service.RawRepositoryConfigurationXmlConverter;
import com.atlassian.bamboo.vcs.configuration.service.VcsRepositoryConfigurationService;
import com.atlassian.bamboo.vcs.configurator.VcsBambooSpecsConfigurator;
import com.atlassian.bamboo.vcs.configurator.VcsBranchConfigurator;
import com.atlassian.bamboo.vcs.converter.Repository2VcsTypeConverter;
import com.atlassian.bamboo.vcs.module.VcsRepositoryManager;
import com.atlassian.bamboo.vcs.module.VcsRepositoryModuleDescriptor;
import com.atlassian.bamboo.vcs.viewer.configuration.VcsRepositoryViewerDefinitionImpl;
import com.atlassian.bamboo.vcs.viewer.converter.Web2VcsRepositoryViewerConverter;
import com.atlassian.bamboo.vcs.viewer.module.VcsRepositoryViewerManager;
import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.spring.container.ContainerManager;
import com.atlassian.user.EntityException;
import com.atlassian.user.User;
import com.atlassian.user.UserManager;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.opensymphony.xwork2.TextProvider;
import io.atlassian.util.concurrent.ManagedLock;
import io.atlassian.util.concurrent.ManagedLocks;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.acegisecurity.Authentication;
import org.acegisecurity.acls.MutableAcl;
import org.acegisecurity.acls.Permission;
import org.acegisecurity.acls.objectidentity.ObjectIdentity;
import org.acegisecurity.acls.sid.GrantedAuthoritySid;
import org.acegisecurity.acls.sid.PrincipalSid;
import org.acegisecurity.acls.sid.Sid;
import org.acegisecurity.context.SecurityContextHolder;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsRepositoryConfigurationServiceImpl
implements VcsRepositoryConfigurationService {
    private static final Logger log = Logger.getLogger(VcsRepositoryConfigurationServiceImpl.class);
    private static final String GLOBAL_REPOSITORY_LOCK_NAME = "__GLOBAL_REPOSITORY__LOCK__";
    private static final String REPOSITORY_HAS_BEEN_REMOVED = "Repository has been removed.";
    private static final String REPOSITORY_HAS_BEEN_CREATED = "Repository has been created.";
    private static final String REPOSITORY_TYPE_HAS_BEEN_CHANGED = "Repository type has been changed.";
    private static final String REPOSITORY_HAS_BEEN_MOVED = "Repository has been moved.";
    private static final String REPOSITORY_HAS_BEEN_SELECTED_FOR_CHANGE_DETECTION = "Repository has been marked for change detection.";
    private static final String REPOSITORY_NOT_SELECTED_FOR_CHANGE_DETECTION = "Repository has been removed from change detection.";
    private static final String GLOBAL_REPOSITORY_HAS_BEEN_CREATED = "Global repository %s has been created.";
    private static final String GLOBAL_REPOSITORY_HAS_BEEN_DELETED = "Global repository %s has been deleted.";
    private static final String GLOBAL_REPOSITORY_TYPE_HAS_BEEN_CHANGED = "Global repository %s type has been changed.";
    private static final String GLOBAL_REPOSITORY_CONFIGURATION_HAS_BEEN_CHANGED = "Global repository configuration has been changed.";
    private static final String GLOBAL_REPOSITORY_HAS_BEEN_ATTACHED = "Global repository %s has been attached.";
    private final Function<String, ManagedLock> globalRepositoryModificationLock = ManagedLocks.weakManagedLockFactory();
    private final RepositoryDefinitionManager repositoryDefinitionManager;
    private final AuditLogService auditLogService;
    private final HibernateMutableAclService aclService;
    private final RawRepositoryConfigurationXmlConverter rawRepositoryConfigurationXmlConverter;
    private final ImmutablePlanCacheService immutablePlanCacheService;
    private final ScopedExclusionService scopedExclusionService;
    private final TriggerConfigurationService triggerConfigurationService;
    private final TaskConfigurationService taskConfigurationService;
    private final ChainBranchManager chainBranchManager;
    private final EnvironmentTaskService environmentTaskService;
    private final BuildDefinitionManager buildDefinitionManager;
    private final EventPublisher eventPublisher;
    private final BranchDetectionService branchDetectionService;
    private final VcsRepositoryManager vcsRepositoryManager;
    @Inject
    private VcsRepositoryViewerManager vcsRepositoryViewerManager;
    @Inject
    private BandanaManager bandanaManager;
    @Inject
    private TextProvider textProvider;
    @Inject
    private UserManager userManager;
    @Inject
    private RssPermissionManager rssPermissionManager;
    @Inject
    private VcsBambooSpecsConfigurator vcsBambooSpecsConfigurator;

    public VcsRepositoryConfigurationServiceImpl(RepositoryDefinitionManager repositoryDefinitionManager, AuditLogService auditLogService, HibernateMutableAclService aclService, RawRepositoryConfigurationXmlConverter rawRepositoryConfigurationXmlConverter, ImmutablePlanCacheService immutablePlanCacheService, ScopedExclusionService scopedExclusionService, TriggerConfigurationService triggerConfigurationService, TaskConfigurationService taskConfigurationService, ChainBranchManager chainBranchManager, EnvironmentTaskService environmentTaskService, BuildDefinitionManager buildDefinitionManager, EventPublisher eventPublisher, BranchDetectionService branchDetectionService, VcsRepositoryManager vcsRepositoryManager) {
        this.repositoryDefinitionManager = repositoryDefinitionManager;
        this.auditLogService = auditLogService;
        this.aclService = aclService;
        this.rawRepositoryConfigurationXmlConverter = rawRepositoryConfigurationXmlConverter;
        this.immutablePlanCacheService = immutablePlanCacheService;
        this.scopedExclusionService = scopedExclusionService;
        this.triggerConfigurationService = triggerConfigurationService;
        this.taskConfigurationService = taskConfigurationService;
        this.chainBranchManager = chainBranchManager;
        this.environmentTaskService = environmentTaskService;
        this.buildDefinitionManager = buildDefinitionManager;
        this.eventPublisher = eventPublisher;
        this.branchDetectionService = branchDetectionService;
        this.vcsRepositoryManager = vcsRepositoryManager;
    }

    @NotNull
    public PartialVcsRepositoryData createPlanRepository(@NotNull Plan plan, @NotNull PartialVcsRepositoryData newVcsConfiguration) {
        return (PartialVcsRepositoryData)this.scopedExclusionService.withLock((Enum)ScopedExclusionService.ExclusionScopeType.REPOSITORY_DATA, (Object)plan.getPlanKey(), input -> {
            List existingDefinitions = this.repositoryDefinitionManager.getPlanRepositoryLinks((ImmutablePlan)plan);
            int position = 0;
            if (!existingDefinitions.isEmpty()) {
                PlanRepositoryLink lastExistingRepository = (PlanRepositoryLink)Iterables.getLast((Iterable)existingDefinitions);
                position = lastExistingRepository.getPosition() + 1;
            }
            return this.saveNewRepositoryLink(plan, newVcsConfiguration, position);
        });
    }

    @NotNull
    private PartialVcsRepositoryData saveNewRepositoryLink(@NotNull Plan plan, @NotNull PartialVcsRepositoryData newVcsConfiguration, int position) {
        RepositoryDataEntity savedEntity = this.createRepositoryDefinition(newVcsConfiguration);
        PlanRepositoryLinkImpl planRepository = new PlanRepositoryLinkImpl(plan, savedEntity, position);
        this.repositoryDefinitionManager.savePlanRepositoryWithDefinition((PlanRepositoryLink)planRepository);
        PartialVcsRepositoryData repositoryDefinition = this.repositoryDefinitionManager.entityToUnmergedData(savedEntity);
        Chain chain = (Chain)Narrow.downTo((Object)plan, Chain.class);
        if (chain != null) {
            this.triggerConfigurationService.addTriggeringRepository(chain, repositoryDefinition.getId());
        }
        this.auditLogService.log(REPOSITORY_HAS_BEEN_CREATED, (Key)plan.getPlanKey(), AuditLogEntityType.PLAN, new AuditLogEntity(AuditLogEntityType.REPOSITORY, this.getRepositoryHeader(repositoryDefinition)));
        return repositoryDefinition;
    }

    @NotNull
    public PartialVcsRepositoryData editRepository(@NotNull Plan plan, long repositoryId, @NotNull PartialVcsRepositoryData newVcsConfiguration) {
        return (PartialVcsRepositoryData)this.scopedExclusionService.withLock((Enum)ScopedExclusionService.ExclusionScopeType.REPOSITORY_DATA, (Object)plan.getPlanKey(), input -> {
            PlanRepositoryLink planRepositoryLink = this.repositoryDefinitionManager.getPlanRepositoryLink((ImmutablePlan)plan, repositoryId);
            if (planRepositoryLink == null) {
                throw new IllegalStateException("Repository " + repositoryId + " is not attached to plan " + plan.getPlanKey());
            }
            return this.mergeExistingRepositoryLink(plan, planRepositoryLink, newVcsConfiguration);
        });
    }

    @NotNull
    private PartialVcsRepositoryData mergeExistingRepositoryLink(@NotNull Plan plan, PlanRepositoryLink planRepositoryLink, PartialVcsRepositoryData newVcsConfiguration) {
        PartialVcsRepositoryData savedVcsConfiguration = this.convertToNewRepositoryConfiguration(newVcsConfiguration);
        RepositoryDataEntity repositoryEntity = planRepositoryLink.getRepositoryDataEntity();
        RawRepositoryConfiguration oldRepositoryConfiguration = this.rawRepositoryConfigurationXmlConverter.fromEntity(repositoryEntity);
        repositoryEntity.setName(savedVcsConfiguration.getName());
        repositoryEntity.setDescription(savedVcsConfiguration.getDescription());
        repositoryEntity.setPluginKey(savedVcsConfiguration.getPluginKey());
        RawRepositoryConfiguration rawVcsConfiguration = this.rawRepositoryConfigurationXmlConverter.fromVcsData(savedVcsConfiguration);
        repositoryEntity.setXmlData(this.rawRepositoryConfigurationXmlConverter.asXml(rawVcsConfiguration));
        repositoryEntity.setGlobal(false);
        this.repositoryDefinitionManager.saveRepositoryDefinition(repositoryEntity);
        this.logRepositoryConfigurationChanges(plan.getPlanKey(), repositoryEntity, rawVcsConfiguration, oldRepositoryConfiguration);
        return this.repositoryDefinitionManager.entityToUnmergedData(repositoryEntity);
    }

    public void setParentOfPlanRepository(@NotNull ImmutablePlan plan, long repositoryId, long parentRepositoryId) {
        this.scopedExclusionService.withLock((Enum)ScopedExclusionService.ExclusionScopeType.REPOSITORY_DATA, (Object)plan.getPlanKey(), input -> {
            PlanRepositoryLink planRepositoryLink = this.repositoryDefinitionManager.getPlanRepositoryLink(plan, repositoryId);
            if (planRepositoryLink == null) {
                throw new IllegalStateException("Repository " + repositoryId + " is not attached to plan " + plan.getPlanKey());
            }
            RepositoryDataEntity repositoryEntity = planRepositoryLink.getRepositoryDataEntity();
            RepositoryDataEntity parentEntity = this.repositoryDefinitionManager.getRepositoryDataEntity(parentRepositoryId);
            if (parentEntity == null) {
                throw new IllegalStateException("Repository " + parentRepositoryId + " does not exist");
            }
            repositoryEntity.setParent(parentEntity);
            repositoryEntity.setName(parentEntity.getName());
            repositoryEntity.setDescription(parentEntity.getDescription());
            repositoryEntity.setPluginKey(parentEntity.getPluginKey());
            repositoryEntity.setGlobal(false);
            this.repositoryDefinitionManager.saveRepositoryDefinition(repositoryEntity);
            return null;
        });
    }

    public PartialVcsRepositoryData replaceRepositoryInPlan(@NotNull Plan plan, @NotNull VcsRepositoryData parentRepository, @NotNull PartialVcsRepositoryData oldRepository, @NotNull PartialVcsRepositoryData newRepository) {
        return (PartialVcsRepositoryData)this.scopedExclusionService.withLock((Enum)ScopedExclusionService.ExclusionScopeType.REPOSITORY_DATA, (Object)plan.getPlanKey(), input -> {
            RepositoryDataEntityImpl repositoryEntity;
            PlanRepositoryLink planRepositoryLink = this.repositoryDefinitionManager.getPlanRepositoryLink((ImmutablePlan)plan, oldRepository.getId());
            if (planRepositoryLink == null) {
                throw new IllegalStateException("Repository " + oldRepository.getId() + " is not attached to plan " + plan.getPlanKey());
            }
            RepositoryDataEntity oldEntity = planRepositoryLink.getRepositoryDataEntity();
            if (newRepository.getId() > 0L) {
                repositoryEntity = this.repositoryDefinitionManager.getRepositoryDataEntity(newRepository.getId());
                Preconditions.checkState((repositoryEntity != null ? 1 : 0) != 0);
            } else {
                repositoryEntity = new RepositoryDataEntityImpl();
            }
            RepositoryDataEntity parentEntity = this.repositoryDefinitionManager.getRepositoryDataEntity(parentRepository.getId());
            Preconditions.checkState((parentEntity != null ? 1 : 0) != 0);
            RawRepositoryConfiguration oldRepositoryConfiguration = this.rawRepositoryConfigurationXmlConverter.fromVcsData(oldRepository);
            PartialVcsRepositoryData savedVcsConfiguration = this.convertToNewRepositoryConfiguration(newRepository);
            RawRepositoryConfiguration newRepositoryConfiguration = this.rawRepositoryConfigurationXmlConverter.fromVcsData(savedVcsConfiguration);
            repositoryEntity.setName(savedVcsConfiguration.getName());
            repositoryEntity.setDescription(savedVcsConfiguration.getDescription());
            repositoryEntity.setPluginKey(savedVcsConfiguration.getPluginKey());
            repositoryEntity.setParent(parentEntity);
            repositoryEntity.setXmlData(this.rawRepositoryConfigurationXmlConverter.asXml(newRepositoryConfiguration));
            repositoryEntity.setGlobal(false);
            planRepositoryLink.setRepositoryDataEntity((RepositoryDataEntity)repositoryEntity);
            this.repositoryDefinitionManager.savePlanRepositoryWithDefinition(planRepositoryLink);
            this.repositoryDefinitionManager.removeRepositoryIfUnused(oldEntity);
            this.handleRepositoryIdChange(plan, new PlanRepositoryDefinitionImpl(planRepositoryLink, this.repositoryDefinitionManager.entityToUnmergedData((RepositoryDataEntity)repositoryEntity)), oldRepository.getId());
            this.logRepositoryConfigurationChanges(plan.getPlanKey(), repositoryEntity, newRepositoryConfiguration, oldRepositoryConfiguration);
            this.auditLogService.log(REPOSITORY_HAS_BEEN_CREATED, (Key)plan.getPlanKey(), AuditLogEntityType.PLAN, new AuditLogEntity(AuditLogEntityType.REPOSITORY, this.getRepositoryHeader(repositoryEntity)));
            return this.repositoryDefinitionManager.entityToUnmergedData((RepositoryDataEntity)repositoryEntity);
        });
    }

    private PlanRepositoryLink attachGlobalRepositoryToPlanInternal(@NotNull Plan plan, long selectedGlobalRepositoryId) {
        RepositoryDataEntity parentEntity = this.repositoryDefinitionManager.getRepositoryDataEntity(selectedGlobalRepositoryId);
        if (parentEntity == null) {
            throw new IllegalStateException("Repository " + selectedGlobalRepositoryId + " does not exist");
        }
        RepositoryDataEntityImpl childEntity = new RepositoryDataEntityImpl();
        childEntity.setParent(parentEntity);
        childEntity.setName(parentEntity.getName());
        childEntity.setPluginKey(parentEntity.getPluginKey());
        childEntity.setDescription(parentEntity.getDescription());
        childEntity.setGlobal(false);
        childEntity.setXmlData(this.rawRepositoryConfigurationXmlConverter.emptyXml());
        List existingDefinitions = this.repositoryDefinitionManager.getPlanRepositoryLinks((ImmutablePlan)plan);
        if (existingDefinitions.stream().anyMatch(arg_0 -> BambooPredicates.hasBambooObjectEqualId(selectedGlobalRepositoryId).apply(arg_0))) {
            throw new IllegalArgumentException("Repository " + selectedGlobalRepositoryId + " is already attached to the Plan");
        }
        int position = 0;
        if (!existingDefinitions.isEmpty()) {
            PlanRepositoryLink lastExistingRepository = (PlanRepositoryLink)Iterables.getLast((Iterable)existingDefinitions);
            position = lastExistingRepository.getPosition() + 1;
        }
        PlanRepositoryLinkImpl planRepository = new PlanRepositoryLinkImpl(plan, childEntity, position);
        this.repositoryDefinitionManager.savePlanRepositoryWithDefinition((PlanRepositoryLink)planRepository);
        return planRepository;
    }

    @NotNull
    public PartialVcsRepositoryData linkRepositoryToPlan(@NotNull Plan plan, long selectedRepositoryId) {
        return (PartialVcsRepositoryData)this.scopedExclusionService.withLock((Enum)ScopedExclusionService.ExclusionScopeType.REPOSITORY_DATA, (Object)plan.getPlanKey(), input -> {
            PlanRepositoryLink planRepository = this.attachGlobalRepositoryToPlanInternal(plan, selectedRepositoryId);
            RepositoryDataEntity repositoryDataEntity = planRepository.getRepositoryDataEntity();
            this.auditLogService.log(String.format(GLOBAL_REPOSITORY_HAS_BEEN_ATTACHED, repositoryDataEntity.getName()), (Key)plan.getPlanKey(), AuditLogEntityType.PLAN, new AuditLogEntity(AuditLogEntityType.REPOSITORY, this.getRepositoryHeader(repositoryDataEntity)));
            PartialVcsRepositoryData repositoryDefinition = this.repositoryDefinitionManager.entityToUnmergedData(repositoryDataEntity);
            Chain chain = (Chain)Narrow.downTo((Object)plan, Chain.class);
            if (chain != null) {
                this.triggerConfigurationService.addTriggeringRepository(chain, repositoryDefinition.getId());
            }
            return repositoryDefinition;
        });
    }

    @NotNull
    public PartialVcsRepositoryData createLinkedRepository(@NotNull PartialVcsRepositoryData newVcsRepository, @NotNull User user, @NotNull RepositoryConfigurationService.LinkedRepositoryAccess accessOption) {
        return (PartialVcsRepositoryData)this.globalRepositoryModificationLock.apply(GLOBAL_REPOSITORY_LOCK_NAME).withLock(() -> {
            RepositoryDataEntityImpl repositoryEntity = new RepositoryDataEntityImpl();
            PartialVcsRepositoryData savedVcsConfiguration = this.convertToNewRepositoryConfiguration(newVcsRepository);
            if (newVcsRepository.getOid() != null) {
                repositoryEntity.setOid(newVcsRepository.getOid());
            }
            repositoryEntity.setName(savedVcsConfiguration.getName());
            repositoryEntity.setDescription(savedVcsConfiguration.getDescription());
            repositoryEntity.setPluginKey(savedVcsConfiguration.getPluginKey());
            RawRepositoryConfiguration rawVcsConfiguration = this.rawRepositoryConfigurationXmlConverter.fromVcsData(savedVcsConfiguration);
            repositoryEntity.setXmlData(this.rawRepositoryConfigurationXmlConverter.asXml(rawVcsConfiguration));
            repositoryEntity.setGlobal(true);
            this.repositoryDefinitionManager.saveRepositoryDefinition((RepositoryDataEntity)repositoryEntity);
            PartialVcsRepositoryDataImpl repositoryData = new PartialVcsRepositoryDataImpl(repositoryEntity, rawVcsConfiguration, null);
            MutableAcl acl = this.createNewSharedRepositoryDefaultAcl(user, repositoryEntity.getId(), accessOption);
            this.aclService.updateAcl(acl);
            this.auditLogService.log(String.format(GLOBAL_REPOSITORY_HAS_BEEN_CREATED, savedVcsConfiguration.getName()), null, null, new AuditLogEntity(AuditLogEntityType.REPOSITORY, this.getRepositoryHeader(repositoryData)));
            return repositoryData;
        });
    }

    @NotNull
    public PartialVcsRepositoryData editLinkedRepository(long repositoryId, @NotNull PartialVcsRepositoryData newVcsConfiguration) {
        PartialVcsRepositoryData newRepositoryData = (PartialVcsRepositoryData)this.globalRepositoryModificationLock.apply(GLOBAL_REPOSITORY_LOCK_NAME).withLock(() -> {
            RepositoryDataEntity repositoryEntity = this.repositoryDefinitionManager.getRepositoryDataEntity(repositoryId);
            if (repositoryEntity == null) {
                throw new IllegalStateException("Repository " + repositoryId + " does not exist");
            }
            PartialVcsRepositoryData savedVcsConfiguration = this.convertToNewRepositoryConfiguration(newVcsConfiguration);
            RawRepositoryConfiguration oldRepositoryConfiguration = this.rawRepositoryConfigurationXmlConverter.fromEntity(repositoryEntity);
            repositoryEntity.setName(savedVcsConfiguration.getName());
            repositoryEntity.setPluginKey(savedVcsConfiguration.getPluginKey());
            repositoryEntity.setDescription(savedVcsConfiguration.getDescription());
            RawRepositoryConfiguration rawVcsConfiguration = this.rawRepositoryConfigurationXmlConverter.fromVcsData(savedVcsConfiguration);
            repositoryEntity.setXmlData(this.rawRepositoryConfigurationXmlConverter.asXml(rawVcsConfiguration));
            this.repositoryDefinitionManager.saveRepositoryDefinition(repositoryEntity);
            this.logRepositoryConfigurationChanges(null, repositoryEntity, rawVcsConfiguration, oldRepositoryConfiguration);
            for (PlanRepositoryLink oldPlanRepository : this.repositoryDefinitionManager.getPlansUsingRepository(repositoryId)) {
                Plan plan = oldPlanRepository.getPlan();
                this.auditLogService.log(GLOBAL_REPOSITORY_CONFIGURATION_HAS_BEEN_CHANGED, (Key)plan.getPlanKey(), AuditLogEntityType.PLAN, new AuditLogEntity(AuditLogEntityType.REPOSITORY, this.getRepositoryHeader(repositoryEntity)));
            }
            return new PartialVcsRepositoryDataImpl(repositoryEntity, rawVcsConfiguration, null);
        });
        for (PlanIdentifier planIdentifier : this.repositoryDefinitionManager.getIdentifiersOfPlansUsingRepositoryOrItsDirectChildren(newRepositoryData.getId())) {
            this.immutablePlanCacheService.cascadeInvalidate(planIdentifier.getPlanKey());
        }
        return newRepositoryData;
    }

    public void deleteLinkedRepository(final long repositoryId) {
        this.globalRepositoryModificationLock.apply(GLOBAL_REPOSITORY_LOCK_NAME).withLock(new Runnable(){

            @Override
            public void run() {
                RepositoryDataEntity repositoryDataEntity = VcsRepositoryConfigurationServiceImpl.this.repositoryDefinitionManager.getRepositoryDataEntity(repositoryId);
                if (repositoryDataEntity == null) {
                    throw new IllegalStateException("Repository " + repositoryId + " does not exist");
                }
                VcsRepositoryConfigurationServiceImpl.this.aclService.deleteAcl((ObjectIdentity)new HibernateObjectIdentityImpl(RepositoryDataEntityImpl.class, (Serializable)Long.valueOf(repositoryId)), false);
                VcsRepositoryConfigurationServiceImpl.this.auditLogService.log(String.format(VcsRepositoryConfigurationServiceImpl.GLOBAL_REPOSITORY_HAS_BEEN_DELETED, repositoryDataEntity.getName()), null, null, new AuditLogEntity(AuditLogEntityType.REPOSITORY, (String)StringUtils.defaultIfEmpty((CharSequence)repositoryDataEntity.getName(), (CharSequence)repositoryDataEntity.getPluginKey())));
                VcsRepositoryConfigurationServiceImpl.this.rssPermissionManager.disableAllProjectAccess(repositoryId);
                VcsRepositoryConfigurationServiceImpl.this.rssPermissionManager.disableAllRepositoriesAccess(repositoryId);
                VcsRepositoryConfigurationServiceImpl.this.repositoryDefinitionManager.removeRepositoryIfUnused(repositoryDataEntity);
            }
        });
    }

    private boolean checkGlobalRepositoryName(String name, BambooIdProvider repositoryData) {
        return Iterables.any((Iterable)this.repositoryDefinitionManager.getLinkedRepositoriesUnrestricted(), (com.google.common.base.Predicate)new NameUsedByOtherRepositoryDefinitionPredicate(repositoryData, name));
    }

    public boolean validateLinkedRepositoryName(@NotNull String repositoryName, @Nullable BambooIdProvider vcsRepositoryData) {
        return (Boolean)this.globalRepositoryModificationLock.apply(GLOBAL_REPOSITORY_LOCK_NAME).withLock(() -> this.checkGlobalRepositoryName(repositoryName, vcsRepositoryData));
    }

    private boolean checkRepositoryName(@NotNull ImmutablePlan plan, @NotNull String name, @Nullable BambooIdProvider repositoryDefinition) {
        return Iterables.any((Iterable)this.repositoryDefinitionManager.getPlanRepositoryDefinitions((PlanIdentifier)plan), (com.google.common.base.Predicate)new NameUsedByOtherRepositoryDefinitionPredicate(repositoryDefinition, name));
    }

    public boolean validateRepositoryName(@NotNull ImmutablePlan immutablePlan, @NotNull String repositoryName, @Nullable BambooIdProvider repositoryDefinition) {
        return (Boolean)this.scopedExclusionService.withLock((Enum)ScopedExclusionService.ExclusionScopeType.REPOSITORY_DATA, (Object)immutablePlan.getPlanKey(), input -> this.checkRepositoryName(immutablePlan, repositoryName, repositoryDefinition));
    }

    public MutableAcl createNewSharedRepositoryDefaultAcl(@NotNull User user, long repositoryId, RepositoryConfigurationService.LinkedRepositoryAccess accessOption) {
        PrincipalSid creator = new PrincipalSid(user.getName());
        HibernateAclImpl acl = new HibernateAclImpl(new HibernateObjectIdentityImpl(RepositoryDataEntityImpl.class, (Serializable)Long.valueOf(repositoryId)), null, true, (Sid)creator);
        ContainerManager.autowireComponent((Object)acl);
        acl.insertAce(null, (Permission)BambooPermission.READ, (Sid)creator, true);
        acl.insertAce(null, (Permission)BambooPermission.ADMINISTRATION, (Sid)creator, true);
        if (accessOption == RepositoryConfigurationService.LinkedRepositoryAccess.ALL_USERS) {
            acl.insertAce(null, (Permission)BambooPermission.READ, (Sid)new GrantedAuthoritySid("ROLE_USER"), true);
        }
        return acl;
    }

    public void deleteRepository(@NotNull Plan plan, long repositoryId, Long replacementRepositoryId) {
        PlanRepositoryLink planRepository = this.repositoryDefinitionManager.getPlanRepositoryLink((ImmutablePlan)plan, repositoryId);
        if (planRepository == null) {
            throw new IllegalStateException("Repository " + repositoryId + " is not attached to plan " + plan.getPlanKey());
        }
        this.doDelete(planRepository, plan, repositoryId, replacementRepositoryId);
    }

    private void doDelete(PlanRepositoryLink planRepository, Plan plan, long repositoryId, Long replacementRepositoryId) {
        this.scopedExclusionService.withLock((Enum)ScopedExclusionService.ExclusionScopeType.REPOSITORY_DATA, (Object)plan.getPlanKey(), input -> {
            LegacyRepositoryDefinitionImpl repositoryDefinition = new LegacyRepositoryDefinitionImpl(planRepository);
            this.repositoryDefinitionManager.removeRepositoryFromPlan(planRepository);
            int position = planRepository.getPosition();
            List planRepositoryLinks = this.repositoryDefinitionManager.getPlanRepositoryLinks((ImmutablePlan)plan);
            for (PlanRepositoryLink planRepositoryLink : planRepositoryLinks) {
                if (planRepositoryLink.getPosition() < position) continue;
                planRepositoryLink.setPosition(position);
                this.repositoryDefinitionManager.savePlanRepositoryLink(planRepositoryLink);
                ++position;
            }
            if (replacementRepositoryId != null && replacementRepositoryId > 0L) {
                PlanRepositoryLink replacementLink = this.repositoryDefinitionManager.getPlanRepositoryLink((ImmutablePlan)plan, replacementRepositoryId.longValue());
                PlanRepositoryDefinitionImpl replacementRepository = new PlanRepositoryDefinitionImpl(replacementLink, this.repositoryDefinitionManager.entityToUnmergedData(replacementLink.getRepositoryDataEntity()));
                this.handleRepositoryIdChange(plan, replacementRepository, repositoryId);
            } else {
                this.handleRepositoryRemoval(plan, repositoryId);
            }
            if (planRepository.getPosition() == 0) {
                PlanRepositoryLink newDefault = (PlanRepositoryLink)Iterables.getFirst((Iterable)planRepositoryLinks, null);
                PlanRepositoryDefinitionImpl newDefaultDef = newDefault == null ? null : new PlanRepositoryDefinitionImpl(newDefault, this.repositoryDefinitionManager.entityToUnmergedData(newDefault.getRepositoryDataEntity()));
                this.handleChangeOfDefaultRepository(plan, newDefaultDef);
            }
            this.auditLogService.log(REPOSITORY_HAS_BEEN_REMOVED, (Key)plan.getPlanKey(), AuditLogEntityType.PLAN, new AuditLogEntity(AuditLogEntityType.REPOSITORY, this.getRepositoryHeader(planRepository)));
            return null;
        });
    }

    public void moveRepository(@NotNull Plan plan, long repositoryId, long beforePosition, long afterPosition) throws IllegalArgumentException, IllegalStateException {
        this.scopedExclusionService.withLock((Enum)ScopedExclusionService.ExclusionScopeType.REPOSITORY_DATA, (Object)plan.getPlanKey(), input -> {
            List repositories = this.repositoryDefinitionManager.getPlanRepositoryLinks((ImmutablePlan)plan);
            PlanRepositoryLink toMove = repositories.stream().filter(arg_0 -> RepositoryPredicates.hasPlanRepositoryLinkEqualRepositoryId(repositoryId).apply(arg_0)).findFirst().orElseGet(null);
            if (toMove == null) {
                throw new IllegalStateException("Repository with ID '" + repositoryId + "' is no longer in the list.");
            }
            boolean changingDefault = toMove.getPosition() == 0 || beforePosition <= 0L;
            AtomicInteger index = new AtomicInteger(0);
            ArrayList newPlanRepositories = Lists.newArrayList(this.getNewRepositoryList(repositories, toMove, beforePosition, afterPosition));
            newPlanRepositories.forEach(in -> in.setPosition(index.getAndAdd(1)));
            if (changingDefault) {
                this.handleChangeOfDefaultRepository(plan, this.repositoryDefinitionManager.entityToVcsData(((PlanRepositoryLink)Iterables.getFirst((Iterable)newPlanRepositories, null)).getRepositoryDataEntity()));
            }
            this.repositoryDefinitionManager.savePlanRepositoryLinks((List)newPlanRepositories);
            this.auditLogService.log(REPOSITORY_HAS_BEEN_MOVED, (Key)plan.getPlanKey(), AuditLogEntityType.PLAN, new AuditLogEntity(AuditLogEntityType.REPOSITORY, this.getRepositoryHeader(toMove)));
            return null;
        });
    }

    @NotNull
    protected List<PlanRepositoryLink> getNewRepositoryList(@NotNull List<PlanRepositoryLink> originalRepositories, @NotNull PlanRepositoryLink toMove, long beforeId, long afterId) {
        if (originalRepositories.isEmpty()) {
            return originalRepositories;
        }
        LinkedList<PlanRepositoryLink> newRepositories = new LinkedList<PlanRepositoryLink>(originalRepositories);
        newRepositories.remove(toMove);
        if (newRepositories.isEmpty()) {
            if (beforeId <= 0L && afterId <= 0L) {
                newRepositories.add(toMove);
                return newRepositories;
            }
            log.warn((Object)"Could not move repository. Repository list out of sync: repository before or repository after specified but the list has nothing else in it.");
        } else if (beforeId <= 0L) {
            if (newRepositories.getFirst().getRepositoryDataEntity().getId() == afterId) {
                newRepositories.addFirst(toMove);
                return newRepositories;
            }
            log.warn((Object)"Could not move repository. Repository list out of sync: repository after specified does not match the next repository.");
        } else if (afterId <= 0L) {
            if (newRepositories.getLast().getRepositoryDataEntity().getId() == beforeId) {
                newRepositories.addLast(toMove);
                return newRepositories;
            }
            log.warn((Object)"Could not move repository. Repository list out of sync: repository before specified does not match the last repository.");
        } else {
            ListIterator it = newRepositories.listIterator();
            while (it.hasNext()) {
                PlanRepositoryLink planRepository = (PlanRepositoryLink)it.next();
                if (beforeId != planRepository.getRepositoryDataEntity().getId()) continue;
                if (it.hasNext()) {
                    PlanRepositoryLink afterRepository = (PlanRepositoryLink)it.next();
                    if (afterRepository.getRepositoryDataEntity().getId() == afterId) {
                        newRepositories.add(it.previousIndex(), toMove);
                        return newRepositories;
                    }
                    log.warn((Object)"Could not move repository. Repository list out of sync: after repository specified does not match the next repository");
                    break;
                }
                log.warn((Object)"Could not move repository. Repository list out of sync: after repository specified but there are no more repository in the list");
                break;
            }
            log.warn((Object)"Could not move repository. Could not find the repository in the list to insert new repository after");
        }
        throw new IllegalStateException("Could not move repository, repository list is out of sync");
    }

    public void shareRepository(@NotNull Plan plan, @NotNull PartialVcsRepositoryData repositoryData, @NotNull String repositoryName, @Nullable String userDescription, @NotNull User user) {
        this.globalRepositoryModificationLock.apply(GLOBAL_REPOSITORY_LOCK_NAME).withLock(() -> this.scopedExclusionService.withLock((Enum)ScopedExclusionService.ExclusionScopeType.REPOSITORY_DATA, (Object)plan.getPlanKey(), ScopedExclusionServiceHelper.adapt(() -> {
            RepositoryDataEntity repositoryDataEntity = this.repositoryDefinitionManager.getRepositoryDataEntity(repositoryData.getId());
            if (repositoryDataEntity == null) {
                throw new IllegalStateException("Repository " + repositoryData.getId() + " does not exist");
            }
            if (repositoryDataEntity.isGlobal() || repositoryDataEntity.getParent() != null) {
                return;
            }
            repositoryDataEntity.setName(repositoryName);
            repositoryDataEntity.setDescription(userDescription);
            RepositoryDataEntityImpl globalClone = new RepositoryDataEntityImpl(repositoryDataEntity.getPluginKey(), repositoryDataEntity.getName(), repositoryDataEntity.getDescription(), repositoryDataEntity.getXmlData(), repositoryDataEntity.isMarkedForDeletion(), true, null);
            this.repositoryDefinitionManager.saveRepositoryDefinition((RepositoryDataEntity)globalClone);
            repositoryDataEntity.setParent((RepositoryDataEntity)globalClone);
            repositoryDataEntity.setXmlData(this.rawRepositoryConfigurationXmlConverter.emptyXml());
            this.repositoryDefinitionManager.saveRepositoryDefinition(repositoryDataEntity);
            MutableAcl acl = this.createNewSharedRepositoryDefaultAcl(user, globalClone.getId(), RepositoryConfigurationService.LinkedRepositoryAccess.ALL_USERS);
            this.aclService.updateAcl(acl);
        })));
    }

    public boolean validateRestartableStatus(@NotNull ResultsSummary resultSummary) {
        return this.validateRepositoriesStillAccessible(resultSummary, ImmutableChainResultsSummary::isRestartable);
    }

    public boolean validateContinuableStatus(@NotNull ResultsSummary resultSummary) {
        return this.validateRepositoriesStillAccessible(resultSummary, ImmutableChainResultsSummary::isContinuable);
    }

    private boolean validateRepositoriesStillAccessible(@NotNull ResultsSummary resultSummary, Predicate<ChainResultsSummary> isCorrectResultState) {
        ChainResultsSummary chainResultSummary = (ChainResultsSummary)Narrow.downTo((Object)resultSummary, ChainResultsSummary.class);
        if (chainResultSummary != null && isCorrectResultState.test(chainResultSummary)) {
            Set repositoryIds = chainResultSummary.getImmutablePlan().getEffectiveRepositoryDefinitions().stream().map(BambooIdProvider::getId).collect(Collectors.toSet());
            List changesets = chainResultSummary.getRepositoryChangesets();
            for (RepositoryChangeset changeset : changesets) {
                repositoryIds.remove(changeset.getRepositoryData().getId());
            }
            return repositoryIds.isEmpty();
        }
        return false;
    }

    public Map<ImmutableJob, List<TaskDefinition>> getRelevantJobsForRepositoryIdChange(@NotNull ImmutablePlan plan, long repositoryId) {
        LinkedHashMap<ImmutableJob, List<TaskDefinition>> tasksForJobs = new LinkedHashMap<ImmutableJob, List<TaskDefinition>>();
        ImmutableChain chain = (ImmutableChain)Narrow.to((Object)plan, ImmutableChain.class);
        if (chain != null) {
            for (ImmutableJob job : chain.getAllJobs()) {
                List tasks = this.taskConfigurationService.getRelevantTasksForRepositoryId(job, repositoryId);
                if (tasks.isEmpty()) continue;
                tasksForJobs.put(job, tasks);
            }
        }
        return tasksForJobs;
    }

    public PartialVcsRepositoryData convertToNewRepositoryConfiguration(@NotNull PartialVcsRepositoryData vcsRepositoryData) {
        PartialVcsRepositoryData result = this.convertToNewRepositoryConfigurationInternal(vcsRepositoryData);
        this.storeLegacyPluginKeysToBandana(result.getCompleteData());
        return result;
    }

    private PartialVcsRepositoryData convertToNewRepositoryConfigurationInternal(@NotNull PartialVcsRepositoryData vcsRepositoryData) {
        Web2VcsRepositoryViewerConverter viewerConverter;
        boolean parentHasSameVcsType;
        Repository2VcsTypeConverter converter = this.vcsRepositoryManager.findConverterFor(vcsRepositoryData.getPluginKey());
        boolean bl = parentHasSameVcsType = vcsRepositoryData.getInheritedData() != null && vcsRepositoryData.getInheritedData().getPluginKey().equals(vcsRepositoryData.getPluginKey());
        if (converter != null && !parentHasSameVcsType) {
            PartialVcsRepositoryDataBuilder builder = PartialVcsRepositoryDataBuilder.newBuilder().copyWithEmptyConfig(vcsRepositoryData).pluginKey(converter.producedVcsTypePluginKey());
            if (vcsRepositoryData.getVcsLocation() != null) {
                HierarchicalConfiguration configuration = vcsRepositoryData.asLegacyData().getConfiguration();
                builder.serverConfiguration(converter.extractServerConfiguration(configuration)).branchConfiguration(converter.extractBranchConfiguration(configuration));
                if (vcsRepositoryData.getCompleteData().getVcsChangeDetectionOptions() != null) {
                    HashMap<String, String> changeDetectionOptions = new HashMap<String, String>();
                    changeDetectionOptions.putAll(vcsRepositoryData.getCompleteData().getVcsChangeDetectionOptions().getConfiguration());
                    builder.changeDetectionConfiguration(changeDetectionOptions);
                } else {
                    Map<String, String> changeDetectionConfig = RepositoryConfigurationServiceImpl.extractChangeDetectionOptionFromConfiguration(configuration);
                    builder.changeDetectionConfiguration(changeDetectionConfig);
                }
                this.setVcsBranchPostConversion(builder, converter, vcsRepositoryData);
            }
            if (vcsRepositoryData.getViewerConfiguration() != null) {
                builder.viewerPluginKey(vcsRepositoryData.getViewerConfiguration().getPluginKey());
                builder.viewerConfiguration(vcsRepositoryData.getViewerConfiguration().getConfiguration());
                if (vcsRepositoryData.getViewerConfiguration().isLegacyViewer()) {
                    Web2VcsRepositoryViewerConverter viewerConverter2 = this.vcsRepositoryViewerManager.findConverterFor(vcsRepositoryData.getViewerConfiguration().getPluginKey());
                    if (viewerConverter2 != null) {
                        builder.viewerPluginKey(viewerConverter2.producedVcsRepositoryViewerPluginKey());
                        builder.viewerConfiguration(viewerConverter2.extractVcsViewerConfiguration(((VcsRepositoryViewerDefinitionImpl)vcsRepositoryData.getViewerConfiguration()).getConfigurationRef().get()));
                        builder.legacyViewerXml(null);
                    } else {
                        builder.legacyViewerXml(vcsRepositoryData.getViewerConfiguration().getLegacyConfigurationXml());
                    }
                }
            }
            if (vcsRepositoryData.getInheritedData() != null && vcsRepositoryData.getInheritedData().getPluginKey().equals(converter.producedVcsTypePluginKey())) {
                VcsRepositoryData inheritedData = vcsRepositoryData.getInheritedData();
                PartialVcsRepositoryData converted = builder.build();
                if (inheritedData.getVcsLocation().equals(converted.getVcsLocation())) {
                    builder.serverConfiguration(null);
                    builder.legacyXml(null);
                }
                if (Objects.equals(inheritedData.getBranch(), converted.getBranch())) {
                    builder.branchConfiguration(null);
                    builder.vcsBranch(null);
                }
                if (Objects.equals(inheritedData.getVcsBranchDetectionOptions(), converted.getVcsBranchDetectionOptions())) {
                    builder.branchDetectionConfiguration(null);
                }
                if (Objects.equals(inheritedData.getVcsChangeDetectionOptions(), converted.getVcsChangeDetectionOptions())) {
                    builder.changeDetectionConfiguration(null);
                }
                if (Objects.equals(inheritedData.getViewerConfiguration(), converted.getViewerConfiguration())) {
                    builder.viewerPluginKey(null);
                    builder.viewerConfiguration(null);
                    builder.legacyViewerXml(null);
                }
            }
            return builder.build();
        }
        if (vcsRepositoryData.getViewerConfiguration() != null && vcsRepositoryData.getViewerConfiguration().isLegacyViewer() && (viewerConverter = this.vcsRepositoryViewerManager.findConverterFor(vcsRepositoryData.getViewerConfiguration().getPluginKey())) != null) {
            PartialVcsRepositoryDataBuilder builder = PartialVcsRepositoryDataBuilder.newBuilder().fullCopy(vcsRepositoryData);
            builder.viewerPluginKey(viewerConverter.producedVcsRepositoryViewerPluginKey());
            builder.viewerConfiguration(viewerConverter.extractVcsViewerConfiguration(((VcsRepositoryViewerDefinitionImpl)vcsRepositoryData.getViewerConfiguration()).getConfigurationRef().get()));
            builder.legacyViewerXml(null);
            return builder.build();
        }
        log.debug((Object)"conversion called but nothing could be converted");
        return vcsRepositoryData;
    }

    private void setVcsBranchPostConversion(PartialVcsRepositoryDataBuilder builder, Repository2VcsTypeConverter converter, @NotNull PartialVcsRepositoryData vcsRepositoryData) {
        VcsRepositoryModuleDescriptor moduleDescriptor;
        VcsBranchConfigurator branchConfigurator;
        if (vcsRepositoryData.getBranch() != null) {
            builder.vcsBranch(vcsRepositoryData.getBranch().getVcsBranch());
        }
        if (builder.getBranchConfiguration() != null && (branchConfigurator = (moduleDescriptor = this.vcsRepositoryManager.getVcsRepositoryModuleDescriptor(converter.producedVcsTypePluginKey())).getVcsBranchConfigurator()) != null) {
            builder.vcsBranch(branchConfigurator.getVcsBranchFromConfig(builder.getBranchConfiguration()));
        }
    }

    private void storeLegacyPluginKeysToBandana(@NotNull VcsRepositoryData data) {
        boolean legacyViewer;
        boolean legacyRepository = data.getVcsLocation() != null && data.getVcsLocation().isLegacyRepository();
        boolean bl = legacyViewer = data.getViewerConfiguration() != null && data.getViewerConfiguration().isLegacyViewer();
        if (legacyRepository || legacyViewer) {
            FinalHashSet newValue;
            Set currentValueInBandana = (Set)this.bandanaManager.getValue((BandanaContext)PlanAwareBandanaContext.GLOBAL_CONTEXT, "legacy.vcs.plugins.used");
            FinalHashSet finalHashSet = newValue = currentValueInBandana != null ? new FinalHashSet((Iterable)currentValueInBandana) : new FinalHashSet();
            if (legacyRepository) {
                newValue.add(data.getPluginKey());
            }
            if (legacyViewer) {
                newValue.add(data.getViewerConfiguration().getPluginKey());
            }
            if (!newValue.equals(currentValueInBandana)) {
                this.bandanaManager.setValue((BandanaContext)PlanAwareBandanaContext.GLOBAL_CONTEXT, "legacy.vcs.plugins.used", (Object)newValue);
            }
        }
    }

    private String getRepositoryHeader(@NotNull PlanRepositoryLink planRepositoryLink) {
        return (String)StringUtils.defaultIfEmpty((CharSequence)planRepositoryLink.getRepositoryDataEntity().getName(), (CharSequence)planRepositoryLink.getRepositoryDataEntity().getPluginKey());
    }

    private String getRepositoryHeader(@NotNull PartialVcsRepositoryData repositoryData) {
        return (String)StringUtils.defaultIfEmpty((CharSequence)repositoryData.getName(), (CharSequence)repositoryData.getPluginKey());
    }

    private String getRepositoryHeader(@NotNull RepositoryDataEntity repositoryDataEntity) {
        return (String)StringUtils.defaultIfEmpty((CharSequence)repositoryDataEntity.getName(), (CharSequence)repositoryDataEntity.getPluginKey());
    }

    private void logRepositoryConfigurationChanges(@Nullable PlanKey planKey, RepositoryDataEntity repositoryDataEntity, RawRepositoryConfiguration configuration, RawRepositoryConfiguration oldConfiguration) {
        this.logRepositoryConfigurationChanges(planKey, repositoryDataEntity.getName(), configuration, oldConfiguration, this.getRepositoryHeader(repositoryDataEntity));
    }

    private Map<String, String> flatConfigMap(RawRepositoryConfiguration configuration) {
        HashMap<String, String> flatConfig = new HashMap<String, String>();
        if (configuration.getServerConfiguration() != null) {
            flatConfig.putAll(configuration.getServerConfiguration());
        }
        if (configuration.getBranchConfiguration() != null) {
            flatConfig.putAll(configuration.getBranchConfiguration());
        }
        if (configuration.getChangeDetectionConfiguration() != null) {
            flatConfig.putAll(configuration.getChangeDetectionConfiguration());
        }
        if (configuration.getLegacyXml() != null) {
            flatConfig.putAll(ConfigUtils.asMap((Configuration)ConfigUtils.getXmlConfigFromXmlString((String)configuration.getLegacyXml()), null));
        }
        if (configuration.getBambooSpecsDetectionConfiguration() != null) {
            flatConfig.putAll(configuration.getBambooSpecsDetectionConfiguration());
        }
        return flatConfig;
    }

    private void logRepositoryConfigurationChanges(@Nullable PlanKey planKey, String repositoryDefinitionName, RawRepositoryConfiguration configuration, RawRepositoryConfiguration oldConfiguration, String auditLogHeader) {
        boolean isLoggingGlobalRepository = planKey == null;
        Map<String, String> flatConfiguration = this.flatConfigMap(configuration);
        Map<String, String> flatOldConfiguration = this.flatConfigMap(oldConfiguration);
        HashSet allKeys = Sets.newHashSet(flatConfiguration.keySet());
        allKeys.addAll(flatOldConfiguration.keySet());
        Iterator iterator = allKeys.iterator();
        while (iterator.hasNext()) {
            String mapKey;
            String key = mapKey = (String)iterator.next();
            String newValue = flatConfiguration.get(mapKey);
            String oldValue = flatOldConfiguration.get(mapKey);
            if (oldValue == null && newValue == null) continue;
            if (isLoggingGlobalRepository) {
                key = "Global repository " + repositoryDefinitionName + ": " + key;
            }
            if (oldValue != null && newValue != null) {
                if (StringUtils.equals((CharSequence)newValue, (CharSequence)oldValue)) continue;
                this.auditLogService.log(key, oldValue, newValue, (Key)planKey, AuditLogEntityType.PLAN, new AuditLogEntity(AuditLogEntityType.REPOSITORY, auditLogHeader));
                continue;
            }
            if (newValue != null) continue;
            this.auditLogService.log(key, oldValue, "null", (Key)planKey, AuditLogEntityType.PLAN, new AuditLogEntity(AuditLogEntityType.REPOSITORY, auditLogHeader));
        }
    }

    private void handleRepositoryIdChange(@NotNull Plan plan, @NotNull PlanRepositoryDefinition repositoryDefinition, long oldRepositoryId) {
        long newRepositoryId = repositoryDefinition.getId();
        HashMap<Long, Long> repositoryIdChanges = new HashMap<Long, Long>();
        repositoryIdChanges.put(oldRepositoryId, newRepositoryId);
        Chain chain = (Chain)Narrow.to((Object)plan, Chain.class);
        if (chain != null) {
            if (!chain.hasMaster()) {
                for (Job job : chain.getAllJobs()) {
                    this.taskConfigurationService.updateRepositoryIdsInJobsTasks(job, repositoryIdChanges);
                }
                if (RepositoryPredicates.isPlanRepositoryDefinitionDefault().apply((Object)repositoryDefinition)) {
                    this.handleChangeOfDefaultRepository(plan, (VcsRepositoryData)repositoryDefinition);
                }
                for (ChainBranch chainBranch : this.chainBranchManager.getBranchesForChain((ImmutableChain)chain)) {
                    this.triggerConfigurationService.updateRepositoryIdsInTriggers((Chain)chainBranch, repositoryIdChanges);
                }
            }
            this.triggerConfigurationService.updateRepositoryIdsInTriggers(chain, repositoryIdChanges);
        }
    }

    private void handleRepositoryRemoval(@NotNull Plan plan, long removedRepositoryId) {
        ImmutableSet removedRepositoriesIds = ImmutableSet.of((Object)removedRepositoryId);
        Chain chain = (Chain)Narrow.to((Object)plan, Chain.class);
        if (chain != null) {
            if (!chain.hasMaster()) {
                for (Job job : chain.getAllJobs()) {
                    long workingDirSelector = job.getBuildDefinition().getRepositoryIdDefiningWorkingDir();
                    if (workingDirSelector != removedRepositoryId) continue;
                    BuildDefinition buildDefinition = job.getBuildDefinition();
                    buildDefinition.setRepositoryIdDefiningWorkingDir(-1L);
                    this.buildDefinitionManager.savePlanAndDefinition((Plan)job, buildDefinition);
                }
                for (ChainBranch chainBranch : this.chainBranchManager.getBranchesForChain((ImmutableChain)chain)) {
                    this.triggerConfigurationService.removeRepositoryIdsFromTriggers((Chain)chainBranch, (Set)removedRepositoriesIds);
                }
            }
            this.triggerConfigurationService.removeRepositoryIdsFromTriggers(chain, (Set)removedRepositoriesIds);
        }
    }

    private void handleRepositoryIdChangeForEnvironment(@NotNull Environment environment, @NotNull PlanRepositoryDefinition repositoryDefinition, long oldRepositoryId) {
        long newRepositoryId = repositoryDefinition.getId();
        HashMap<Long, Long> repositoryIdChanges = new HashMap<Long, Long>();
        repositoryIdChanges.put(oldRepositoryId, newRepositoryId);
        this.environmentTaskService.updateRepositoryIdsInTasks(environment, repositoryIdChanges);
    }

    private void handleChangeOfDefaultRepository(@NotNull Plan plan, @Nullable VcsRepositoryData newVcsData) {
        Chain chain = (Chain)Narrow.to((Object)plan, Chain.class);
        if (chain != null && !plan.hasMaster()) {
            BuildDefinition buildDefinition = plan.getBuildDefinition();
            BranchMonitoringConfiguration monitoringConfiguration = plan.getBuildDefinition().getBranchMonitoringConfiguration();
            if (PlanBranchWorkflow.BRANCH_WORKFLOW == monitoringConfiguration.getPlanBranchWorkflow()) {
                boolean newRepositorySupportsBranchDetection = false;
                if (newVcsData != null) {
                    VcsRepositoryModuleDescriptor moduleDescriptor = this.vcsRepositoryManager.getVcsRepositoryModuleDescriptor(newVcsData.getPluginKey());
                    boolean bl = newRepositorySupportsBranchDetection = moduleDescriptor != null && moduleDescriptor.supportsBranchDetection();
                }
                if (!newRepositorySupportsBranchDetection) {
                    monitoringConfiguration.setPlanBranchWorkflow(PlanBranchWorkflow.MANUAL_WORKFLOW);
                    monitoringConfiguration.setInactiveBranchCleanUpEnabled(false);
                    monitoringConfiguration.setRemovedBranchCleanUpEnabled(false);
                    this.buildDefinitionManager.savePlanAndDefinition(plan, buildDefinition);
                    this.eventPublisher.publish((Object)new BuildConfigurationUpdatedEvent((Object)this, plan.getPlanKey()));
                } else {
                    this.branchDetectionService.scheduleBranchListInitialisation(chain);
                }
            }
        }
    }

    private RepositoryDataEntity createRepositoryDefinition(PartialVcsRepositoryData newVcsConfiguration) {
        PartialVcsRepositoryData savedVcsConfiguration = this.convertToNewRepositoryConfiguration(newVcsConfiguration);
        VcsRepositoryData parent = savedVcsConfiguration.getInheritedData();
        RepositoryDataEntity parentEntity = parent != null ? this.repositoryDefinitionManager.getRepositoryDataEntity(parent.getId()) : null;
        RepositoryDataEntityImpl repositoryEntity = new RepositoryDataEntityImpl();
        repositoryEntity.setName(savedVcsConfiguration.getName());
        repositoryEntity.setDescription(savedVcsConfiguration.getDescription());
        repositoryEntity.setPluginKey(savedVcsConfiguration.getPluginKey());
        repositoryEntity.setParent(parentEntity);
        if (newVcsConfiguration.getOid() != null) {
            repositoryEntity.setOid(newVcsConfiguration.getOid());
        }
        RawRepositoryConfiguration rawVcsConfiguration = this.rawRepositoryConfigurationXmlConverter.fromVcsData(savedVcsConfiguration);
        repositoryEntity.setXmlData(this.rawRepositoryConfigurationXmlConverter.asXml(rawVcsConfiguration));
        repositoryEntity.setGlobal(false);
        this.repositoryDefinitionManager.saveRepositoryDefinition((RepositoryDataEntity)repositoryEntity);
        return repositoryEntity;
    }

    public void validateLinkedRepository(@NotNull PartialVcsRepositoryData vcsRepositoryData) throws PropertiesValidationException {
        VcsRepositoryData oldEntity;
        ArrayList<ValidationProblem> errors = new ArrayList<ValidationProblem>();
        if (vcsRepositoryData.getOid() != null) {
            VcsRepositoryData entityWithSameName;
            oldEntity = this.repositoryDefinitionManager.getVcsRepositoryDataByOid(vcsRepositoryData.getOid());
            if (!(oldEntity != null && StringUtils.equals((CharSequence)vcsRepositoryData.getName(), (CharSequence)oldEntity.getName()) || (entityWithSameName = this.repositoryDefinitionManager.getLinkedRepositoryByName(vcsRepositoryData.getName())) == null || entityWithSameName.getOid().equals((Object)vcsRepositoryData.getOid()))) {
                errors.add(new ValidationProblem(this.textProvider.getText("repository.global.error.nonUniqueName", Collections.singletonList(vcsRepositoryData.getName()))));
            }
        } else {
            oldEntity = this.repositoryDefinitionManager.getLinkedRepositoryByName(vcsRepositoryData.getName());
        }
        if (oldEntity != null && !StringUtils.equals((CharSequence)vcsRepositoryData.getPluginKey(), (CharSequence)oldEntity.getPluginKey())) {
            errors.add(new ValidationProblem(this.textProvider.getText("repository.validate.type.can.not.be.changed", (List)ImmutableList.of((Object)oldEntity.getPluginKey(), (Object)vcsRepositoryData.getPluginKey()))));
        }
        if (!errors.isEmpty()) {
            throw new PropertiesValidationException(errors);
        }
    }

    public PartialVcsRepositoryData mergeLinkedRepository(@NotNull PartialVcsRepositoryData vcsRepositoryData) throws PropertiesValidationException {
        User user;
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        String userName = authentication.getName();
        try {
            user = this.userManager.getUser(userName);
        }
        catch (EntityException e) {
            throw new PropertiesValidationException("Currently authenticated user is not found. ", (Throwable)e);
        }
        return (PartialVcsRepositoryData)this.globalRepositoryModificationLock.apply(GLOBAL_REPOSITORY_LOCK_NAME).withLock(() -> {
            VcsRepositoryData existingEntity;
            VcsRepositoryData vcsRepositoryData2 = existingEntity = vcsRepositoryData.getOid() != null ? this.repositoryDefinitionManager.getVcsRepositoryDataByOid(vcsRepositoryData.getOid()) : this.repositoryDefinitionManager.getLinkedRepositoryByName(vcsRepositoryData.getName());
            if (existingEntity != null) {
                PartialVcsRepositoryData repositoryData = this.editLinkedRepository(existingEntity.getId(), vcsRepositoryData);
                this.eventPublisher.publish((Object)new GenericAnalyticsEvent("bamboo.import.linkedRepository.update"));
                return repositoryData;
            }
            PartialVcsRepositoryData repositoryData = this.createLinkedRepository(vcsRepositoryData, user, RepositoryConfigurationService.LinkedRepositoryAccess.ALL_USERS);
            this.eventPublisher.publish((Object)new GenericAnalyticsEvent("bamboo.import.linkedRepository.create"));
            return repositoryData;
        });
    }

    public void validatePlanRepository(@NotNull Plan plan, @NotNull PartialVcsRepositoryData vcsRepositoryData) throws PropertiesValidationException {
        ArrayList<ValidationProblem> errors = new ArrayList<ValidationProblem>();
        VcsRepositoryData oldEntity = null;
        if (vcsRepositoryData.getOid() != null) {
            PlanRepositoryLink entityWithSameName;
            oldEntity = this.repositoryDefinitionManager.getVcsRepositoryDataByOid(vcsRepositoryData.getOid());
            if (!(oldEntity != null && StringUtils.equals((CharSequence)vcsRepositoryData.getName(), (CharSequence)oldEntity.getName()) || (entityWithSameName = this.repositoryDefinitionManager.getPlanRepositoryLinkByName((ImmutablePlan)plan, vcsRepositoryData.getName())) == null || entityWithSameName.getRepositoryDataEntity().getOid().equals((Object)vcsRepositoryData.getOid()))) {
                errors.add(new ValidationProblem(this.textProvider.getText("repository.error.nonUniqueName", Collections.singletonList(vcsRepositoryData.getName()))));
            }
            if (oldEntity != null) {
                List planRepositoryLinks = this.repositoryDefinitionManager.getPlansUsingRepository(oldEntity.getId());
                if (oldEntity.isLinked() || planRepositoryLinks.isEmpty() || planRepositoryLinks.stream().anyMatch(planRepositoryLink -> planRepositoryLink.getPlan().getId() != plan.getId())) {
                    errors.add(new ValidationProblem(this.textProvider.getText("repository.error.nonUniqueOid", (List)ImmutableList.of((Object)vcsRepositoryData.getOid().toString(), (Object)plan.getPlanKey().toString()))));
                }
            }
        } else {
            PlanRepositoryLink planRepositoryLinkByName = this.repositoryDefinitionManager.getPlanRepositoryLinkByName((ImmutablePlan)plan, vcsRepositoryData.getName());
            if (planRepositoryLinkByName != null) {
                RepositoryDataEntity repositoryDataEntity = planRepositoryLinkByName.getRepositoryDataEntity();
                oldEntity = this.repositoryDefinitionManager.entityToVcsData(repositoryDataEntity);
            }
        }
        if (oldEntity != null && !Objects.equals(vcsRepositoryData.getParentId(), oldEntity.getParentId())) {
            errors.add(new ValidationProblem(ValidationContext.of((String)"planRepository").with(vcsRepositoryData.getName()), this.textProvider.getText("repository.validate.parent.can.not.be.changed")));
        }
        if (oldEntity != null && !StringUtils.equals((CharSequence)vcsRepositoryData.getPluginKey(), (CharSequence)oldEntity.getPluginKey())) {
            errors.add(new ValidationProblem(ValidationContext.of((String)"planRepository").with(vcsRepositoryData.getName()), this.textProvider.getText("repository.validate.type.can.not.be.changed", (List)ImmutableList.of((Object)oldEntity.getPluginKey(), (Object)vcsRepositoryData.getPluginKey()))));
        }
        if (!errors.isEmpty()) {
            throw new PropertiesValidationException(errors);
        }
    }

    public void mergePlanRepositories(@NotNull Plan plan, @NotNull List<PartialVcsRepositoryData> vcsRepositoryDataList) throws PropertiesValidationException {
        this.scopedExclusionService.withLock((Enum)ScopedExclusionService.ExclusionScopeType.REPOSITORY_DATA, (Object)plan.getPlanKey(), input -> {
            List existingRepositoryLinkList = this.repositoryDefinitionManager.getPlanRepositoryLinks((ImmutablePlan)plan);
            int position = 0;
            for (PartialVcsRepositoryData newRepositoryData : vcsRepositoryDataList) {
                Optional<PlanRepositoryLink> matchingExistingRepositoryLink = existingRepositoryLinkList.stream().filter(planRepositoryLink -> {
                    RepositoryDataEntity oldRepositoryData = planRepositoryLink.getRepositoryDataEntity();
                    RepositoryDataEntity parentRepositoryData = oldRepositoryData.getParent();
                    return oldRepositoryData.getOid().equals((Object)newRepositoryData.getOid()) || parentRepositoryData != null && Objects.equals(parentRepositoryData.getId(), newRepositoryData.getParentId()) || parentRepositoryData == null && newRepositoryData.getParentId() == null && oldRepositoryData.getName().equals(newRepositoryData.getName());
                }).findFirst();
                if (matchingExistingRepositoryLink.isPresent()) {
                    PlanRepositoryLink existingRepositoryLink = matchingExistingRepositoryLink.get();
                    existingRepositoryLinkList.remove(existingRepositoryLink);
                    existingRepositoryLink.setPosition(position);
                    this.mergeExistingRepositoryLink(plan, existingRepositoryLink, newRepositoryData);
                } else {
                    this.saveNewRepositoryLink(plan, newRepositoryData, position);
                }
                ++position;
            }
            existingRepositoryLinkList.forEach(r -> {
                this.auditLogService.log(REPOSITORY_HAS_BEEN_REMOVED, (Key)plan.getPlanKey(), AuditLogEntityType.PLAN, new AuditLogEntity(AuditLogEntityType.REPOSITORY, this.getRepositoryHeader((PlanRepositoryLink)r)));
                this.repositoryDefinitionManager.removeRepositoryFromPlan(r);
            });
            return null;
        });
    }

    @NotNull
    public ErrorCollection configureRssDetection(long repositoryId, PartialVcsRepositoryData vcsRepositoryData, boolean isEnabled) {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        VcsRepositoryModuleDescriptor vcsModuleDesc = this.vcsRepositoryManager.getVcsRepositoryModuleDescriptor(vcsRepositoryData.getPluginKey());
        if (vcsModuleDesc == null || vcsModuleDesc.getBambooSpecsHandler() == null) {
            errorCollection.addErrorMessage(this.textProvider.getText("repository.resource.error.repository.specs.not.supported"));
        } else {
            PartialVcsRepositoryData newVcsRepositoryData = PartialVcsRepositoryDataBuilder.newBuilder().fullCopy(vcsRepositoryData).bambooSpecsDetectionConfiguration(this.vcsBambooSpecsConfigurator.generateConfigMap(isEnabled)).build();
            this.editLinkedRepository(repositoryId, newVcsRepositoryData);
        }
        return errorCollection;
    }

    private static class NameUsedByOtherRepositoryDefinitionPredicate
    implements com.google.common.base.Predicate<VcsRepositoryData> {
        private final BambooIdProvider repositoryData;
        private final String name;

        public NameUsedByOtherRepositoryDefinitionPredicate(@Nullable BambooIdProvider repositoryData, String name) {
            this.repositoryData = repositoryData;
            this.name = name;
        }

        public boolean apply(@Nullable VcsRepositoryData input) {
            if (this.repositoryData != null && this.repositoryData.getId() == input.getId()) {
                return false;
            }
            return input.getName().equals(this.name);
        }
    }
}

