/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.vcs.module;

import com.atlassian.bamboo.repository.RepositoryManager;
import com.atlassian.bamboo.repository.StandaloneRepository;
import com.atlassian.bamboo.repository.plugin.RepositoryModuleDescriptor;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.utils.NameProvider;
import com.atlassian.bamboo.utils.SystemProperty;
import com.atlassian.bamboo.vcs.configuration.legacy.LegacyRepositoryModuleDescriptor;
import com.atlassian.bamboo.vcs.converter.Repository2VcsTypeConverter;
import com.atlassian.bamboo.vcs.module.VcsRepositoryManager;
import com.atlassian.bamboo.vcs.module.VcsRepositoryModuleDescriptor;
import com.atlassian.collectors.CollectorsUtil;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.web.descriptors.WeightedDescriptor;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.context.annotation.Lazy;

public class VcsRepositoryManagerImpl
implements VcsRepositoryManager {
    private static final Comparator<VcsRepositoryModuleDescriptor> REPOSITORY_MODULE_DESCRIPTOR_COMPARATOR = Comparator.comparingInt(WeightedDescriptor::getWeight).thenComparing(NameProvider::getName);
    @Inject
    @Lazy
    private RepositoryManager repositoryManager;
    @Inject
    @Lazy
    private PluginAccessor pluginAccessor;

    @NotNull
    public List<VcsRepositoryModuleDescriptor> getAvailableRepositoryDescriptors() {
        boolean standaloneOnly = false;
        return (List)Stream.concat(this.pluginAccessor.getEnabledModuleDescriptorsByClass(VcsRepositoryModuleDescriptor.class).stream(), this.getLegacyRepositoryModuleDescriptors(standaloneOnly)).sorted(REPOSITORY_MODULE_DESCRIPTOR_COMPARATOR).collect(CollectorsUtil.toImmutableList());
    }

    @NotNull
    public List<VcsRepositoryModuleDescriptor> getAvailableStandaloneRepositoryDescriptors() {
        boolean standaloneOnly = true;
        return (List)Stream.concat(this.pluginAccessor.getEnabledModuleDescriptorsByClass(VcsRepositoryModuleDescriptor.class).stream(), this.getLegacyRepositoryModuleDescriptors(standaloneOnly)).sorted(REPOSITORY_MODULE_DESCRIPTOR_COMPARATOR).collect(CollectorsUtil.toImmutableList());
    }

    @Nullable
    public VcsRepositoryModuleDescriptor getVcsRepositoryModuleDescriptor(@NotNull String pluginKey) {
        VcsRepositoryModuleDescriptor vcsRepositoryModuleDescriptor = (VcsRepositoryModuleDescriptor)Narrow.reinterpret((Object)this.pluginAccessor.getEnabledPluginModule(pluginKey), VcsRepositoryModuleDescriptor.class);
        if (vcsRepositoryModuleDescriptor != null) {
            return vcsRepositoryModuleDescriptor;
        }
        RepositoryModuleDescriptor repositoryModuleDescriptor = (RepositoryModuleDescriptor)this.pluginAccessor.getEnabledPluginModule(pluginKey);
        if (repositoryModuleDescriptor != null) {
            return new LegacyRepositoryModuleDescriptor(repositoryModuleDescriptor);
        }
        return null;
    }

    @Nullable
    public VcsRepositoryModuleDescriptor getRepositoryModuleDescriptorByMavenScmKey(@NotNull String mavenScmKey, @NotNull String preferredPluginKey) {
        List matchingPlugins = this.getAvailableRepositoryDescriptors().stream().filter(VcsRepositoryModuleDescriptor::supportsImportFromMaven).filter(md -> mavenScmKey.equals(md.getVcsMavenPomAccessor().getMavenScmProviderKey())).collect(Collectors.toList());
        VcsRepositoryModuleDescriptor firstMatching = null;
        for (VcsRepositoryModuleDescriptor matching : matchingPlugins) {
            if (matching.getCompleteKey().equals(preferredPluginKey)) {
                return matching;
            }
            if (firstMatching != null) continue;
            firstMatching = matching;
        }
        return firstMatching;
    }

    @Nullable
    public Repository2VcsTypeConverter findConverterFor(@NotNull String pluginKey) {
        return this.pluginAccessor.getEnabledModulesByClass(Repository2VcsTypeConverter.class).stream().filter(c -> pluginKey.equals(c.acceptedRepositoryPluginKey())).findFirst().orElse(null);
    }

    @Nullable
    public Repository2VcsTypeConverter findReverseConverterFor(@NotNull String pluginKey) {
        return this.pluginAccessor.getEnabledModulesByClass(Repository2VcsTypeConverter.class).stream().filter(c -> pluginKey.equals(c.producedVcsTypePluginKey())).findFirst().orElse(null);
    }

    private Stream<? extends VcsRepositoryModuleDescriptor> getLegacyRepositoryModuleDescriptors(boolean standaloneOnly) {
        return this.repositoryManager.getAvailableRepositoryDescriptors().stream().filter(md -> !SystemProperty.HIDE_PORTED_LEGACY_REPOSITORIES.getTypedValue() || this.findConverterFor(md.getCompleteKey()) == null).filter(md -> !standaloneOnly || StandaloneRepository.class.isAssignableFrom(md.getModuleClass())).map(LegacyRepositoryModuleDescriptor::new);
    }
}

