/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.vcs.module;

import com.atlassian.bamboo.agent.AgentType;
import com.atlassian.bamboo.agent.AgentTypeHolder;
import com.atlassian.bamboo.plugin.RemoteAgentSupported;
import com.atlassian.bamboo.plugin.descriptor.AbstractBambooModuleDescriptor;
import com.atlassian.bamboo.repository.configuration.RepositoryConfigurator;
import com.atlassian.bamboo.repository.configuration.RepositoryConfiguratorImpl;
import com.atlassian.bamboo.spring.ComponentAccessor;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.vcs.BambooSpecsHandler;
import com.atlassian.bamboo.vcs.configurator.VcsBranchConfigurator;
import com.atlassian.bamboo.vcs.configurator.VcsBranchDetectionOptionsConfigurator;
import com.atlassian.bamboo.vcs.configurator.VcsChangeDetectionOptionsConfigurator;
import com.atlassian.bamboo.vcs.configurator.VcsLocationConfigurator;
import com.atlassian.bamboo.vcs.configurator.VcsMavenPomAccessor;
import com.atlassian.bamboo.vcs.export.VcsRepositoryDataExporter;
import com.atlassian.bamboo.vcs.module.VcsRepositoryModuleDescriptor;
import com.atlassian.bamboo.vcs.runtime.MergingVcsWorkingCopyManager;
import com.atlassian.bamboo.vcs.runtime.NoContextVcsWorkingCopyManager;
import com.atlassian.bamboo.vcs.runtime.UpdatingVcsWorkingCopyManager;
import com.atlassian.bamboo.vcs.runtime.VcsBranchCreator;
import com.atlassian.bamboo.vcs.runtime.VcsBranchDetector;
import com.atlassian.bamboo.vcs.runtime.VcsBuildWarningsUpdater;
import com.atlassian.bamboo.vcs.runtime.VcsChangeDetector;
import com.atlassian.bamboo.vcs.runtime.VcsCommitCommenter;
import com.atlassian.bamboo.vcs.runtime.VcsConnectionTester;
import com.atlassian.bamboo.vcs.runtime.VcsPullRequestDetector;
import com.atlassian.bamboo.vcs.runtime.VcsTagCreator;
import com.atlassian.bamboo.vcs.runtime.VcsVariableGenerator;
import com.atlassian.bamboo.vcs.runtime.VcsWorkingCopyManager;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.module.ModuleFactory;
import com.atlassian.plugin.webresource.UrlMode;
import com.atlassian.plugin.webresource.WebResourceUrlProvider;
import io.atlassian.util.concurrent.ResettableLazyReference;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.log4j.Logger;
import org.dom4j.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@RemoteAgentSupported
public class VcsRepositoryModuleDescriptorImpl
extends AbstractBambooModuleDescriptor<VcsWorkingCopyManager>
implements VcsRepositoryModuleDescriptor {
    private static final Logger log = Logger.getLogger(VcsRepositoryModuleDescriptorImpl.class);
    private static final String PRIMARY = "primary";
    private static final String WEIGHT = "weight";
    public static final String ICON_RESOURCE = "icon";
    public static final String DOWNLOAD_RESOURCE_TYPE = "download";
    private static final String TOOLTIP_KEY = "tooltipKey";
    private static final String DEFAULT_TRIGGER_KEY = "defaultTriggerKey";
    private static final String DEFAULT_VIEWER_KEY = "defaultViewerKey";
    private static final String POLLING_TRIGGER_KEY = "com.atlassian.bamboo.triggers.atlassian-bamboo-triggers:poll";
    private static final String SERVER_CONFIGURATOR = "serverConfigurator";
    private static final String CHANGE_DETECTION_CONFIGURATOR = "changeDetectionConfigurator";
    private static final String BRANCH_DETECTION_CONFIGURATOR = "branchDetectionConfigurator";
    private static final String BRANCH_CONFIGURATOR = "branchConfigurator";
    private static final String CHANGE_DETECTOR = "changeDetector";
    private static final String BRANCH_DETECTOR = "branchDetector";
    private static final String BRANCH_CREATOR = "branchCreator";
    private static final String TAG_CREATOR = "tagCreator";
    private static final String VARIABLE_GENERATOR = "variableGenerator";
    private static final String CONNECTION_TESTER = "connectionTester";
    private static final String UNIQUE_REVISION_IDS = "uniqueRevisionIds";
    private static final String MAVEN_POM_ACCESSOR = "mavenPomAccessor";
    private static final String BAMBOO_SPECS_HANDLER_TAG = "bambooSpecsHandler";
    private static final String BAMBOO_SPECS_CONFIGURATOR_TAG = "bambooSpecsConfigurator";
    private static final String EXPORTER = "exporter";
    private static final String PULL_REQUEST_DETECTOR = "pullRequestDetector";
    private static final String COMMIT_COMMENTER = "commitCommenter";
    private static final String BUILD_WARNINGS_UPDATER = "buildWarningsUpdater";
    private static final String VCS_TYPE = "vcsType";
    private static final String CLASS = "class";
    private RepositoryConfigurator repositoryConfigurator;
    private String serverConfiguratorClassName;
    private String changeDetectionConfiguratorClassName;
    private String branchDetectionConfiguratorClassName;
    private String branchConfiguratorClassName;
    private String changeDetectorClassName;
    private String branchDetectorClassName;
    private String branchCreatorClassName;
    private String tagCreatorClassName;
    private String connectionTesterClassName;
    private String variableGeneratorClassName;
    private String mavenPomAccessorClassName;
    private String exporterClassName;
    private String bambooSpecsHandlerClassName;
    private String pullRequestDetectorClassName;
    private String commitCommenterClassName;
    private String buildWarningsUpdaterClassName;
    private String defaultTriggerKey;
    private String defaultViewerKey;
    private String vcsType;
    private boolean revisionIdsAreUnique = false;
    private ResettableLazyReference<VcsLocationConfigurator> serverConfigurator = new ResettableLazyReference<VcsLocationConfigurator>(){

        protected VcsLocationConfigurator create() throws Exception {
            if (StringUtils.isNotBlank((CharSequence)VcsRepositoryModuleDescriptorImpl.this.serverConfiguratorClassName)) {
                Class configClass = VcsRepositoryModuleDescriptorImpl.this.plugin.loadClass(VcsRepositoryModuleDescriptorImpl.this.serverConfiguratorClassName, ((Object)((Object)this)).getClass());
                return (VcsLocationConfigurator)VcsRepositoryModuleDescriptorImpl.this.instantiateClass(configClass);
            }
            return null;
        }
    };
    private ResettableLazyReference<VcsBranchDetectionOptionsConfigurator> branchDetectionConfigurator = new ResettableLazyReference<VcsBranchDetectionOptionsConfigurator>(){

        protected VcsBranchDetectionOptionsConfigurator create() throws Exception {
            if (StringUtils.isNotBlank((CharSequence)VcsRepositoryModuleDescriptorImpl.this.branchDetectionConfiguratorClassName)) {
                Class configClass = VcsRepositoryModuleDescriptorImpl.this.plugin.loadClass(VcsRepositoryModuleDescriptorImpl.this.branchDetectionConfiguratorClassName, ((Object)((Object)this)).getClass());
                return (VcsBranchDetectionOptionsConfigurator)VcsRepositoryModuleDescriptorImpl.this.instantiateClass(configClass);
            }
            return null;
        }
    };
    private ResettableLazyReference<VcsChangeDetectionOptionsConfigurator> changeDetectionConfigurator = new ResettableLazyReference<VcsChangeDetectionOptionsConfigurator>(){

        protected VcsChangeDetectionOptionsConfigurator create() throws Exception {
            if (StringUtils.isNotBlank((CharSequence)VcsRepositoryModuleDescriptorImpl.this.changeDetectionConfiguratorClassName)) {
                Class configClass = VcsRepositoryModuleDescriptorImpl.this.plugin.loadClass(VcsRepositoryModuleDescriptorImpl.this.changeDetectionConfiguratorClassName, ((Object)((Object)this)).getClass());
                return (VcsChangeDetectionOptionsConfigurator)VcsRepositoryModuleDescriptorImpl.this.instantiateClass(configClass);
            }
            return null;
        }
    };
    private ResettableLazyReference<VcsBranchConfigurator> branchConfigurator = new ResettableLazyReference<VcsBranchConfigurator>(){

        protected VcsBranchConfigurator create() throws Exception {
            if (StringUtils.isNotBlank((CharSequence)VcsRepositoryModuleDescriptorImpl.this.branchConfiguratorClassName)) {
                Class configClass = VcsRepositoryModuleDescriptorImpl.this.plugin.loadClass(VcsRepositoryModuleDescriptorImpl.this.branchConfiguratorClassName, ((Object)((Object)this)).getClass());
                return (VcsBranchConfigurator)VcsRepositoryModuleDescriptorImpl.this.instantiateClass(configClass);
            }
            return null;
        }
    };
    private ResettableLazyReference<VcsChangeDetector> changeDetector = new ResettableLazyReference<VcsChangeDetector>(){

        protected VcsChangeDetector create() throws Exception {
            if (StringUtils.isNotBlank((CharSequence)VcsRepositoryModuleDescriptorImpl.this.changeDetectorClassName)) {
                Class configClass = VcsRepositoryModuleDescriptorImpl.this.plugin.loadClass(VcsRepositoryModuleDescriptorImpl.this.changeDetectorClassName, ((Object)((Object)this)).getClass());
                return (VcsChangeDetector)VcsRepositoryModuleDescriptorImpl.this.instantiateClass(configClass);
            }
            return null;
        }
    };
    private ResettableLazyReference<VcsBranchDetector> branchDetector = new ResettableLazyReference<VcsBranchDetector>(){

        protected VcsBranchDetector create() throws Exception {
            if (StringUtils.isNotBlank((CharSequence)VcsRepositoryModuleDescriptorImpl.this.branchDetectorClassName)) {
                Class clazz = VcsRepositoryModuleDescriptorImpl.this.plugin.loadClass(VcsRepositoryModuleDescriptorImpl.this.branchDetectorClassName, ((Object)((Object)this)).getClass());
                return (VcsBranchDetector)VcsRepositoryModuleDescriptorImpl.this.instantiateClass(clazz);
            }
            return null;
        }
    };
    private ResettableLazyReference<VcsPullRequestDetector> pullRequestDetector = new ResettableLazyReference<VcsPullRequestDetector>(){

        protected VcsPullRequestDetector create() throws Exception {
            if (StringUtils.isNotBlank((CharSequence)VcsRepositoryModuleDescriptorImpl.this.pullRequestDetectorClassName)) {
                Class clazz = VcsRepositoryModuleDescriptorImpl.this.plugin.loadClass(VcsRepositoryModuleDescriptorImpl.this.pullRequestDetectorClassName, ((Object)((Object)this)).getClass());
                return (VcsPullRequestDetector)VcsRepositoryModuleDescriptorImpl.this.instantiateClass(clazz);
            }
            return null;
        }
    };
    private ResettableLazyReference<VcsCommitCommenter> commitCommenter = new ResettableLazyReference<VcsCommitCommenter>(){

        protected VcsCommitCommenter create() throws Exception {
            if (StringUtils.isNotBlank((CharSequence)VcsRepositoryModuleDescriptorImpl.this.commitCommenterClassName)) {
                Class clazz = VcsRepositoryModuleDescriptorImpl.this.plugin.loadClass(VcsRepositoryModuleDescriptorImpl.this.commitCommenterClassName, ((Object)((Object)this)).getClass());
                return (VcsCommitCommenter)VcsRepositoryModuleDescriptorImpl.this.instantiateClass(clazz);
            }
            return null;
        }
    };
    private ResettableLazyReference<VcsBuildWarningsUpdater> buildWarningsUpdater = new ResettableLazyReference<VcsBuildWarningsUpdater>(){

        protected VcsBuildWarningsUpdater create() throws Exception {
            if (StringUtils.isNotBlank((CharSequence)VcsRepositoryModuleDescriptorImpl.this.buildWarningsUpdaterClassName)) {
                Class clazz = VcsRepositoryModuleDescriptorImpl.this.plugin.loadClass(VcsRepositoryModuleDescriptorImpl.this.buildWarningsUpdaterClassName, ((Object)((Object)this)).getClass());
                return (VcsBuildWarningsUpdater)VcsRepositoryModuleDescriptorImpl.this.instantiateClass(clazz);
            }
            return null;
        }
    };
    private ResettableLazyReference<VcsBranchCreator> branchCreator = new ResettableLazyReference<VcsBranchCreator>(){

        protected VcsBranchCreator create() throws Exception {
            if (StringUtils.isNotBlank((CharSequence)VcsRepositoryModuleDescriptorImpl.this.branchCreatorClassName)) {
                Class clazz = VcsRepositoryModuleDescriptorImpl.this.plugin.loadClass(VcsRepositoryModuleDescriptorImpl.this.branchCreatorClassName, ((Object)((Object)this)).getClass());
                return (VcsBranchCreator)VcsRepositoryModuleDescriptorImpl.this.instantiateClass(clazz);
            }
            return null;
        }
    };
    private ResettableLazyReference<VcsTagCreator> tagCreator = new ResettableLazyReference<VcsTagCreator>(){

        protected VcsTagCreator create() throws Exception {
            if (StringUtils.isNotBlank((CharSequence)VcsRepositoryModuleDescriptorImpl.this.tagCreatorClassName)) {
                Class clazz = VcsRepositoryModuleDescriptorImpl.this.plugin.loadClass(VcsRepositoryModuleDescriptorImpl.this.tagCreatorClassName, ((Object)((Object)this)).getClass());
                return (VcsTagCreator)VcsRepositoryModuleDescriptorImpl.this.instantiateClass(clazz);
            }
            return null;
        }
    };
    private ResettableLazyReference<VcsConnectionTester> connectionTester = new ResettableLazyReference<VcsConnectionTester>(){

        protected VcsConnectionTester create() throws Exception {
            if (StringUtils.isNotBlank((CharSequence)VcsRepositoryModuleDescriptorImpl.this.connectionTesterClassName)) {
                Class clazz = VcsRepositoryModuleDescriptorImpl.this.plugin.loadClass(VcsRepositoryModuleDescriptorImpl.this.connectionTesterClassName, ((Object)((Object)this)).getClass());
                return (VcsConnectionTester)VcsRepositoryModuleDescriptorImpl.this.instantiateClass(clazz);
            }
            return null;
        }
    };
    private ResettableLazyReference<VcsVariableGenerator> variableGenerator = new ResettableLazyReference<VcsVariableGenerator>(){

        protected VcsVariableGenerator create() throws Exception {
            if (StringUtils.isNotBlank((CharSequence)VcsRepositoryModuleDescriptorImpl.this.variableGeneratorClassName)) {
                Class clazz = VcsRepositoryModuleDescriptorImpl.this.plugin.loadClass(VcsRepositoryModuleDescriptorImpl.this.variableGeneratorClassName, ((Object)((Object)this)).getClass());
                return (VcsVariableGenerator)VcsRepositoryModuleDescriptorImpl.this.instantiateClass(clazz);
            }
            return null;
        }
    };
    private ResettableLazyReference<VcsMavenPomAccessor> mavenPomAccessor = new ResettableLazyReference<VcsMavenPomAccessor>(){

        protected VcsMavenPomAccessor create() throws Exception {
            if (StringUtils.isNotBlank((CharSequence)VcsRepositoryModuleDescriptorImpl.this.mavenPomAccessorClassName)) {
                Class clazz = VcsRepositoryModuleDescriptorImpl.this.plugin.loadClass(VcsRepositoryModuleDescriptorImpl.this.mavenPomAccessorClassName, ((Object)((Object)this)).getClass());
                return (VcsMavenPomAccessor)VcsRepositoryModuleDescriptorImpl.this.instantiateClass(clazz);
            }
            return null;
        }
    };
    private ResettableLazyReference<VcsRepositoryDataExporter> exporter = new ResettableLazyReference<VcsRepositoryDataExporter>(){

        protected VcsRepositoryDataExporter create() throws Exception {
            if (StringUtils.isNotBlank((CharSequence)VcsRepositoryModuleDescriptorImpl.this.exporterClassName)) {
                Class clazz = VcsRepositoryModuleDescriptorImpl.this.plugin.loadClass(VcsRepositoryModuleDescriptorImpl.this.exporterClassName, ((Object)((Object)this)).getClass());
                return (VcsRepositoryDataExporter)VcsRepositoryModuleDescriptorImpl.this.instantiateClass(clazz);
            }
            return null;
        }
    };
    private final ResettableLazyReference<BambooSpecsHandler> bambooSpecsHandler = new ResettableLazyReference<BambooSpecsHandler>(){

        protected BambooSpecsHandler create() throws Exception {
            return (BambooSpecsHandler)VcsRepositoryModuleDescriptorImpl.this.loadIfPresent(VcsRepositoryModuleDescriptorImpl.this.bambooSpecsHandlerClassName);
        }
    };

    @Nullable
    private <T> T loadIfPresent(String className) throws ClassNotFoundException {
        if (StringUtils.isBlank((CharSequence)className)) {
            return null;
        }
        Class clazz = this.plugin.loadClass(className, ((Object)((Object)this)).getClass());
        return (T)this.instantiateClass(clazz);
    }

    public VcsRepositoryModuleDescriptorImpl(ModuleFactory moduleFactory) {
        super(moduleFactory);
    }

    public void init(Plugin plugin, Element element) throws PluginParseException {
        super.init(plugin, element);
        String stringIsPrimary = element.attributeValue(PRIMARY);
        String stringWeight = element.attributeValue(WEIGHT);
        boolean isPrimary = Boolean.parseBoolean(stringIsPrimary);
        int weight = NumberUtils.toInt((String)stringWeight, (int)Integer.MAX_VALUE);
        String icon = this.getElementAsString(element.element(ICON_RESOURCE));
        String tooltipKey = this.getElementAsString(element.element(TOOLTIP_KEY));
        this.vcsType = this.getElementAsString(element.element(VCS_TYPE));
        if (StringUtils.isBlank((CharSequence)this.vcsType)) {
            this.vcsType = this.getKey();
        }
        this.revisionIdsAreUnique = Boolean.parseBoolean(this.getElementAsString(element.element(UNIQUE_REVISION_IDS)));
        this.defaultTriggerKey = Optional.ofNullable(this.getElementAsString(element.element(DEFAULT_TRIGGER_KEY))).orElse(POLLING_TRIGGER_KEY);
        this.defaultViewerKey = Optional.ofNullable(this.getElementAsString(element.element(DEFAULT_VIEWER_KEY))).orElse("none:none");
        this.repositoryConfigurator = new RepositoryConfiguratorImpl(weight, isPrimary, icon, tooltipKey);
        boolean optionalModule = false;
        this.serverConfiguratorClassName = this.prepareSubModuleConfiguration(element, this.serverConfigurator, SERVER_CONFIGURATOR, optionalModule, ModuleAvalability.SERVER_ONLY);
        this.changeDetectorClassName = this.prepareSubModuleConfiguration(element, this.changeDetector, CHANGE_DETECTOR, optionalModule, ModuleAvalability.SERVER_ONLY);
        optionalModule = true;
        this.changeDetectionConfiguratorClassName = this.prepareSubModuleConfiguration(element, this.changeDetectionConfigurator, CHANGE_DETECTION_CONFIGURATOR, optionalModule, ModuleAvalability.SERVER_ONLY);
        this.branchDetectionConfiguratorClassName = this.prepareSubModuleConfiguration(element, this.branchDetectionConfigurator, BRANCH_DETECTION_CONFIGURATOR, optionalModule, ModuleAvalability.SERVER_ONLY);
        this.branchDetectorClassName = this.prepareSubModuleConfiguration(element, this.branchDetector, BRANCH_DETECTOR, optionalModule, ModuleAvalability.SERVER_ONLY);
        this.branchCreatorClassName = this.prepareSubModuleConfiguration(element, this.branchCreator, BRANCH_CREATOR, optionalModule, ModuleAvalability.SERVER_AND_AGENT);
        this.tagCreatorClassName = this.prepareSubModuleConfiguration(element, this.tagCreator, TAG_CREATOR, optionalModule, ModuleAvalability.SERVER_AND_AGENT);
        this.variableGeneratorClassName = this.prepareSubModuleConfiguration(element, this.variableGenerator, VARIABLE_GENERATOR, optionalModule, ModuleAvalability.SERVER_AND_AGENT);
        this.bambooSpecsHandlerClassName = this.prepareSubModuleConfiguration(element, this.bambooSpecsHandler, BAMBOO_SPECS_HANDLER_TAG, optionalModule, ModuleAvalability.SERVER_ONLY);
        this.pullRequestDetectorClassName = this.prepareSubModuleConfiguration(element, this.pullRequestDetector, PULL_REQUEST_DETECTOR, optionalModule, ModuleAvalability.SERVER_ONLY);
        this.commitCommenterClassName = this.prepareSubModuleConfiguration(element, this.commitCommenter, COMMIT_COMMENTER, optionalModule, ModuleAvalability.SERVER_ONLY);
        this.buildWarningsUpdaterClassName = this.prepareSubModuleConfiguration(element, this.buildWarningsUpdater, BUILD_WARNINGS_UPDATER, optionalModule, ModuleAvalability.SERVER_ONLY);
        this.connectionTesterClassName = this.prepareSubModuleConfiguration(element, this.connectionTester, CONNECTION_TESTER, optionalModule, ModuleAvalability.SERVER_ONLY);
        this.mavenPomAccessorClassName = this.prepareSubModuleConfiguration(element, this.mavenPomAccessor, MAVEN_POM_ACCESSOR, optionalModule, ModuleAvalability.SERVER_ONLY);
        this.exporterClassName = this.prepareSubModuleConfiguration(element, this.exporter, EXPORTER, optionalModule, ModuleAvalability.SERVER_ONLY);
        boolean isBranchConfiguratorMandatory = this.branchConfiguratorClassName != null;
        optionalModule = !isBranchConfiguratorMandatory;
        this.branchConfiguratorClassName = this.prepareSubModuleConfiguration(element, this.branchConfigurator, BRANCH_CONFIGURATOR, optionalModule, ModuleAvalability.SERVER_ONLY);
    }

    @Override
    protected boolean isMutable() {
        return false;
    }

    @NotNull
    public VcsLocationConfigurator getVcsLocationConfigurator() {
        return (VcsLocationConfigurator)this.serverConfigurator.get();
    }

    @Nullable
    public VcsChangeDetectionOptionsConfigurator getVcsChangeDetectionOptionsConfigurator() {
        return (VcsChangeDetectionOptionsConfigurator)this.changeDetectionConfigurator.get();
    }

    @Nullable
    public VcsBranchDetectionOptionsConfigurator getVcsBranchDetectionOptionsConfigurator() {
        return (VcsBranchDetectionOptionsConfigurator)this.branchDetectionConfigurator.get();
    }

    @NotNull
    public VcsChangeDetector getChangeDetector() {
        return (VcsChangeDetector)this.changeDetector.get();
    }

    @NotNull
    public VcsWorkingCopyManager getWorkingCopyManager() {
        return (VcsWorkingCopyManager)this.getModule();
    }

    @Nullable
    public VcsBranchConfigurator getVcsBranchConfigurator() {
        return (VcsBranchConfigurator)this.branchConfigurator.get();
    }

    @Nullable
    public VcsBranchDetector getBranchDetector() {
        return (VcsBranchDetector)this.branchDetector.get();
    }

    @Nullable
    public VcsPullRequestDetector getPullRequestDetector() {
        return (VcsPullRequestDetector)this.pullRequestDetector.get();
    }

    @Nullable
    public VcsCommitCommenter getVcsCommitCommenter() {
        return (VcsCommitCommenter)this.commitCommenter.get();
    }

    @Nullable
    public VcsBuildWarningsUpdater getBuildWarningsUpdater() {
        return (VcsBuildWarningsUpdater)this.buildWarningsUpdater.get();
    }

    @Nullable
    public VcsBranchCreator getBranchCreator() {
        return (VcsBranchCreator)this.branchCreator.get();
    }

    @Nullable
    public VcsTagCreator getTagCreator() {
        return (VcsTagCreator)this.tagCreator.get();
    }

    @Nullable
    public VcsConnectionTester getConnectionTester() {
        return (VcsConnectionTester)this.connectionTester.get();
    }

    @Nullable
    public VcsVariableGenerator getVariableGenerator() {
        return (VcsVariableGenerator)this.variableGenerator.get();
    }

    @Nullable
    public VcsMavenPomAccessor getVcsMavenPomAccessor() {
        return (VcsMavenPomAccessor)this.mavenPomAccessor.get();
    }

    @NotNull
    public VcsRepositoryDataExporter getExporter() {
        return (VcsRepositoryDataExporter)this.exporter.get();
    }

    public BambooSpecsHandler getBambooSpecsHandler() {
        return (BambooSpecsHandler)this.bambooSpecsHandler.get();
    }

    @Nullable
    public String getOptionDescription() {
        return null;
    }

    @Nullable
    public String getIcon() {
        WebResourceUrlProvider webResourceUrlProvider = (WebResourceUrlProvider)ComponentAccessor.WEB_RESOURCE_URL_PROVIDER.get();
        if (webResourceUrlProvider != null && this.getResourceDescriptor(DOWNLOAD_RESOURCE_TYPE, ICON_RESOURCE) != null) {
            return webResourceUrlProvider.getStaticPluginResourceUrl((ModuleDescriptor)this, ICON_RESOURCE, UrlMode.RELATIVE);
        }
        return null;
    }

    @Nullable
    public String getTooltipKey() {
        return this.repositoryConfigurator.getTooltipKey();
    }

    public boolean isPrimary() {
        return this.repositoryConfigurator.isPrimary();
    }

    public int getWeight() {
        return this.repositoryConfigurator.getWeight();
    }

    public boolean supportsBranchDetection() {
        return this.branchConfigurator.get() != null && this.branchDetector.get() != null;
    }

    public boolean supportsBranchOverrides() {
        return this.branchConfigurator.get() != null;
    }

    public boolean supportsBranchCreation() {
        return this.branchCreator.get() != null;
    }

    public boolean supportsTagCreation() {
        return this.tagCreator.get() != null;
    }

    public boolean providesCustomVariables() {
        return this.variableGenerator.get() != null;
    }

    public boolean supportsMerging() {
        MergingVcsWorkingCopyManager mergingVcsWorkingCopyManager = (MergingVcsWorkingCopyManager)Narrow.downTo(this.getModule(), MergingVcsWorkingCopyManager.class);
        return this.branchConfigurator.get() != null && mergingVcsWorkingCopyManager != null && mergingVcsWorkingCopyManager.canDoMerge();
    }

    public boolean supportsRemoteUpdates() {
        return this.getModule() instanceof UpdatingVcsWorkingCopyManager;
    }

    public boolean supportsTestingConnection() {
        return this.connectionTester.get() != null;
    }

    public boolean supportsImportFromMaven() {
        return this.mavenPomAccessor.get() != null && this.getWorkingCopyManager() instanceof NoContextVcsWorkingCopyManager;
    }

    public boolean revisionIdsAreUnique() {
        return this.revisionIdsAreUnique;
    }

    @NotNull
    public String getTypeString() {
        return this.vcsType;
    }

    @NotNull
    public String getDefaultTriggerKey() {
        return this.defaultTriggerKey;
    }

    @NotNull
    public String getDefaultVcsViewerKey() {
        return this.defaultViewerKey;
    }

    private String prepareSubModuleConfiguration(Element element, ResettableLazyReference<?> reference, String elementName, boolean optional, ModuleAvalability moduleAvalability) {
        if (moduleAvalability == ModuleAvalability.SERVER_ONLY && AgentTypeHolder.get() != AgentType.LOCAL) {
            return null;
        }
        if (element.element(elementName) != null) {
            Element configuration = element.element(elementName);
            String clazz = configuration.attributeValue(CLASS);
            if (StringUtils.isBlank((CharSequence)clazz) && !optional) {
                log.warn((Object)("Vcs type module (" + this.getKey() + ") of plugin " + this.plugin.getKey() + " contains an incorrectly configured '" + elementName + "' element. Please use the 'class' attribute to define your '" + elementName + "' class"));
            }
            reference.reset();
            return clazz;
        }
        if (!optional) {
            log.warn((Object)("Vcs type module (" + this.getKey() + ") of plugin " + this.plugin.getKey() + " does not contain '" + elementName + "'element. This module will not function correctly."));
        }
        return null;
    }

    private static enum ModuleAvalability {
        SERVER_ONLY,
        SERVER_AND_AGENT;

    }
}

