/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.vcs.viewer.configuration;

import com.atlassian.bamboo.collections.message.FinalHashMap;
import com.atlassian.bamboo.repository.RepositoryConfigurationReference;
import com.atlassian.bamboo.repository.RepositoryConfigurationReferenceConverter;
import com.atlassian.bamboo.vcs.viewer.configuration.VcsRepositoryViewerDefinition;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamConverter;
import java.util.Map;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsRepositoryViewerDefinitionImpl
implements VcsRepositoryViewerDefinition {
    private final String pluginKey;
    private final FinalHashMap<String, String> configuration;
    @XStreamAlias(value="xmlData")
    @XStreamConverter(value=RepositoryConfigurationReferenceConverter.class)
    protected final RepositoryConfigurationReference configurationRef;

    public VcsRepositoryViewerDefinitionImpl(String pluginKey, Map<String, String> configuration, String legacyXml) {
        this.pluginKey = pluginKey;
        this.configuration = new FinalHashMap(configuration);
        this.configurationRef = legacyXml != null ? new RepositoryConfigurationReference(legacyXml) : null;
    }

    public VcsRepositoryViewerDefinitionImpl(VcsRepositoryViewerDefinition other) {
        this.pluginKey = other.getPluginKey();
        this.configuration = new FinalHashMap(other.getConfiguration());
        String legacyXml = other.getLegacyConfigurationXml();
        this.configurationRef = legacyXml != null ? new RepositoryConfigurationReference(legacyXml) : null;
    }

    @NotNull
    public String getPluginKey() {
        return this.pluginKey;
    }

    @NotNull
    public Map<String, String> getConfiguration() {
        return this.configuration;
    }

    public boolean isLegacyViewer() {
        return this.configurationRef != null;
    }

    @Nullable
    public String getLegacyConfigurationXml() {
        return this.isLegacyViewer() ? this.configurationRef.getXmlString() : null;
    }

    public RepositoryConfigurationReference getConfigurationRef() {
        return this.configurationRef;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VcsRepositoryViewerDefinitionImpl that = (VcsRepositoryViewerDefinitionImpl)o;
        return new EqualsBuilder().append((Object)this.pluginKey, (Object)that.pluginKey).append(this.configuration, that.configuration).append((Object)this.getLegacyConfigurationXml(), (Object)that.getLegacyConfigurationXml()).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.pluginKey).append(this.configuration).append((Object)this.getLegacyConfigurationXml()).toHashCode();
    }
}

