/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.vcs.viewer.legacy;

import com.atlassian.bamboo.commit.Commit;
import com.atlassian.bamboo.commit.CommitFile;
import com.atlassian.bamboo.commit.CommitImpl;
import com.atlassian.bamboo.plugin.descriptor.WebRepositoryViewerModuleDescriptor;
import com.atlassian.bamboo.repository.RepositoryData;
import com.atlassian.bamboo.vcs.configuration.VcsRepositoryData;
import com.atlassian.bamboo.vcs.viewer.legacy.LegacyVcsViewerBase;
import com.atlassian.bamboo.vcs.viewer.runtime.VcsRepositoryViewer;
import com.atlassian.bamboo.webrepository.CommitUrlProvider;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LegacyRepositoryViewer
extends LegacyVcsViewerBase
implements VcsRepositoryViewer {
    public LegacyRepositoryViewer(WebRepositoryViewerModuleDescriptor webRepositoryViewerModuleDescriptor) {
        super(webRepositoryViewerModuleDescriptor);
    }

    @Nullable
    public String getWebRepositoryUrlForRevision(@NotNull String revisionId, @NotNull VcsRepositoryData repositoryData) {
        return this.getUrlProvider(repositoryData).getWebRepositoryUrlForRevision(revisionId, this.getRepositoryData(repositoryData));
    }

    @NotNull
    public Map<String, String> getWebRepositoryUrlForRevisions(Stream<String> revisionIds, VcsRepositoryData repositoryDefinition) {
        Map result = this.getUrlProvider(repositoryDefinition).getWebRepositoryUrlForCommits((Collection)revisionIds.map(revId -> {
            CommitImpl commit = new CommitImpl();
            commit.setChangeSetId((String)revId);
            return commit;
        }).collect(Collectors.toList()), this.getRepositoryData(repositoryDefinition));
        return result.entrySet().stream().collect(Collectors.toMap(e -> ((Commit)e.getKey()).getChangeSetId(), Map.Entry::getValue));
    }

    @Nullable
    public String getWebRepositoryUrlForFile(@NotNull CommitFile file, @NotNull VcsRepositoryData repositoryData) {
        return this.invokeIfPresent("getWebRepositoryUrlForFile", file, repositoryData);
    }

    @Nullable
    public String getWebRepositoryUrlForFileRevision(@NotNull CommitFile file, @NotNull VcsRepositoryData repositoryData) {
        return this.invokeIfPresent("getWebRepositoryUrlForRevision", file, repositoryData);
    }

    @Nullable
    public String getWebRepositoryUrlForFileDiff(@NotNull CommitFile file, @NotNull VcsRepositoryData repositoryData) {
        return this.invokeIfPresent("getWebRepositoryUrlForDiff", file, repositoryData);
    }

    private String invokeIfPresent(String methodName, CommitFile file, VcsRepositoryData repositoryData) {
        CommitUrlProvider urlProvider = this.getUrlProvider(repositoryData);
        try {
            Method method = this.webRepositoryViewerModuleDescriptor.getModuleClass().getMethod(methodName, CommitFile.class, RepositoryData.class);
            return method.invoke((Object)urlProvider, file, this.getRepositoryData(repositoryData)).toString();
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            return null;
        }
    }
}

