/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.vcs.viewer.legacy;

import com.atlassian.bamboo.collections.ActionParametersMap;
import com.atlassian.bamboo.plugin.BambooPluginUtils;
import com.atlassian.bamboo.plugin.descriptor.WebRepositoryViewerModuleDescriptor;
import com.atlassian.bamboo.utils.ConfigUtils;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bamboo.utils.error.SimpleErrorCollection;
import com.atlassian.bamboo.vcs.viewer.configuration.VcsRepositoryViewerDefinition;
import com.atlassian.bamboo.vcs.viewer.configuration.VcsRepositoryViewerDefinitionImpl;
import com.atlassian.bamboo.vcs.viewer.configurator.VcsRepositoryViewerConfigurator;
import com.atlassian.bamboo.vcs.viewer.legacy.LegacyVcsViewerBase;
import com.atlassian.bamboo.web.utils.BuildConfigurationActionHelper;
import com.atlassian.bamboo.webrepository.WebRepositoryViewer;
import com.atlassian.bamboo.ww2.actions.build.admin.create.BuildConfiguration;
import com.google.common.collect.ImmutableMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LegacyVcsRepositoryViewerConfigurator
extends LegacyVcsViewerBase
implements VcsRepositoryViewerConfigurator {
    public static final String LEGACY_XML = "legacyXml";

    public LegacyVcsRepositoryViewerConfigurator(WebRepositoryViewerModuleDescriptor webRepositoryViewerModuleDescriptor) {
        super(webRepositoryViewerModuleDescriptor);
    }

    public void populateContextForCreate(@NotNull Map<String, Object> context) {
        WebRepositoryViewer viewer = (WebRepositoryViewer)this.webRepositoryViewerModuleDescriptor.getModule();
        BuildConfiguration bc = new BuildConfiguration();
        viewer.addDefaultValues(bc);
        this.populateStackFromBuildConfiguration(context, (HierarchicalConfiguration)bc);
    }

    public void populateContextForEdit(@NotNull Map<String, Object> context, @NotNull VcsRepositoryViewerDefinition vcsRepositoryViewerDefinition) {
        if (!vcsRepositoryViewerDefinition.isLegacyViewer()) {
            throw new IllegalStateException("Not a legacy viewer");
        }
        WebRepositoryViewer viewer = (WebRepositoryViewer)this.webRepositoryViewerModuleDescriptor.getModule();
        HierarchicalConfiguration bc = ((VcsRepositoryViewerDefinitionImpl)vcsRepositoryViewerDefinition).getConfigurationRef().get();
        viewer.populateFromConfig(bc);
        this.populateStackFromBuildConfiguration(context, bc);
    }

    public void populateContextForView(@NotNull Map<String, Object> context, @NotNull VcsRepositoryViewerDefinition vcsRepositoryViewerDefinition) {
        this.populateContextForEdit(context, vcsRepositoryViewerDefinition);
    }

    public void validate(@NotNull ActionParametersMap actionParametersMap, final @NotNull ErrorCollection errorCollection) {
        final WebRepositoryViewer viewer = (WebRepositoryViewer)this.webRepositoryViewerModuleDescriptor.getModule();
        final BuildConfiguration buildConfiguration = new BuildConfiguration();
        viewer.addDefaultValues(buildConfiguration);
        BuildConfigurationActionHelper.copyParamsToBuildConfiguration(actionParametersMap, buildConfiguration);
        viewer.prepareConfigObject(buildConfiguration);
        final String message = "Failed to validate build configuration for the " + viewer.getName() + " viewer (" + viewer.getKey() + ").";
        ErrorCollection myErrorCollection = BambooPluginUtils.callUnsafeCode(new BambooPluginUtils.NoThrowCallable<ErrorCollection>(message){

            @Override
            public ErrorCollection call() {
                return viewer.validate(buildConfiguration);
            }

            @Override
            public void onThrow(@NotNull Throwable t) {
                SimpleErrorCollection exception = new SimpleErrorCollection(message + " " + t.getMessage());
                errorCollection.addErrorCollection((ErrorCollection)exception);
            }
        });
        errorCollection.addErrorCollection(myErrorCollection);
    }

    @NotNull
    public Map<String, String> generateConfigMap(@NotNull ActionParametersMap actionParametersMap, @Nullable VcsRepositoryViewerDefinition previousViewerDefinition) {
        Object viewer = previousViewerDefinition != null && this.webRepositoryViewerModuleDescriptor.getCompleteKey().equals(previousViewerDefinition.getPluginKey()) ? this.getUrlProvider(previousViewerDefinition) : (WebRepositoryViewer)this.webRepositoryViewerModuleDescriptor.getModule();
        BuildConfiguration buildConfiguration = new BuildConfiguration();
        viewer.addDefaultValues(buildConfiguration);
        BuildConfigurationActionHelper.copyParamsToBuildConfiguration(actionParametersMap, buildConfiguration);
        viewer.prepareConfigObject(buildConfiguration);
        viewer.populateFromConfig((HierarchicalConfiguration)buildConfiguration);
        return ImmutableMap.of((Object)LEGACY_XML, (Object)ConfigUtils.asXmlString((HierarchicalConfiguration)viewer.toConfiguration()));
    }

    private void populateStackFromBuildConfiguration(Map<String, Object> map, HierarchicalConfiguration buildConfiguration) {
        map.put("buildConfiguration", buildConfiguration);
        Iterator iterator = buildConfiguration.getKeys();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            Object value = this.getValue(buildConfiguration, key);
            map.put(key, value);
        }
    }

    private Object getValue(HierarchicalConfiguration buildConfiguration, String key) {
        int maxIndex = buildConfiguration.getMaxIndex(key);
        Object value = maxIndex > 0 ? buildConfiguration.getList(key) : buildConfiguration.getProperty(key);
        return value;
    }
}

