/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.vcs.viewer.legacy;

import com.atlassian.bamboo.plugin.descriptor.WebRepositoryViewerModuleDescriptor;
import com.atlassian.bamboo.repository.RepositoryData;
import com.atlassian.bamboo.repository.RepositoryDataImpl;
import com.atlassian.bamboo.utils.ConfigUtils;
import com.atlassian.bamboo.vcs.configuration.VcsRepositoryData;
import com.atlassian.bamboo.vcs.viewer.configuration.VcsRepositoryViewerDefinition;
import com.atlassian.bamboo.webrepository.CommitUrlProvider;
import com.atlassian.bamboo.webrepository.WebRepositoryViewer;
import com.google.common.base.Preconditions;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class LegacyVcsViewerBase {
    private static final Logger log = Logger.getLogger(LegacyVcsViewerBase.class);
    protected final WebRepositoryViewerModuleDescriptor webRepositoryViewerModuleDescriptor;

    public LegacyVcsViewerBase(WebRepositoryViewerModuleDescriptor webRepositoryViewerModuleDescriptor) {
        this.webRepositoryViewerModuleDescriptor = webRepositoryViewerModuleDescriptor;
    }

    protected CommitUrlProvider getUrlProvider(VcsRepositoryViewerDefinition viewerDefinition) {
        Preconditions.checkState((boolean)viewerDefinition.getPluginKey().equals(this.webRepositoryViewerModuleDescriptor.getCompleteKey()));
        WebRepositoryViewer webRepositoryViewer = (WebRepositoryViewer)this.webRepositoryViewerModuleDescriptor.getModule();
        webRepositoryViewer.populateFromConfig((HierarchicalConfiguration)ConfigUtils.getXmlConfigFromXmlString((String)viewerDefinition.getLegacyConfigurationXml()));
        return (CommitUrlProvider)webRepositoryViewer;
    }

    protected CommitUrlProvider getUrlProvider(VcsRepositoryData vcsRepositoryData) {
        VcsRepositoryViewerDefinition viewerConfiguration = vcsRepositoryData.getViewerConfiguration();
        Preconditions.checkNotNull((Object)viewerConfiguration);
        return this.getUrlProvider(viewerConfiguration);
    }

    protected RepositoryData getRepositoryData(@NotNull VcsRepositoryData vcsRepositoryData) {
        if (vcsRepositoryData.isLegacyRepository()) {
            return vcsRepositoryData.asLegacyData();
        }
        return new RepositoryDataImpl(vcsRepositoryData);
    }
}

