/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.vcs.viewer.module;

import com.atlassian.bamboo.plugin.descriptor.WebRepositoryViewerModuleDescriptor;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.utils.SystemProperty;
import com.atlassian.bamboo.vcs.configuration.VcsRepositoryData;
import com.atlassian.bamboo.vcs.viewer.converter.Web2VcsRepositoryViewerConverter;
import com.atlassian.bamboo.vcs.viewer.legacy.LegacyVcsRepositoryViewerModuleDescriptor;
import com.atlassian.bamboo.vcs.viewer.module.VcsRepositoryViewerManager;
import com.atlassian.bamboo.vcs.viewer.module.VcsRepositoryViewerModuleDescriptor;
import com.atlassian.bamboo.vcs.viewer.runtime.VcsRepositoryViewer;
import com.atlassian.bamboo.webrepository.CommitUrlProvider;
import com.atlassian.bamboo.webrepository.WebRepositoryViewerManager;
import com.atlassian.plugin.PluginAccessor;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsRepositoryViewerManagerImpl
implements VcsRepositoryViewerManager {
    private final PluginAccessor pluginAccessor;
    private final WebRepositoryViewerManager webRepositoryViewerManager;

    public VcsRepositoryViewerManagerImpl(PluginAccessor pluginAccessor, WebRepositoryViewerManager webRepositoryViewerManager) {
        this.pluginAccessor = pluginAccessor;
        this.webRepositoryViewerManager = webRepositoryViewerManager;
    }

    public Stream<VcsRepositoryViewerModuleDescriptor> getAvailableRepositoryViewers() {
        return Stream.concat(this.pluginAccessor.getEnabledModuleDescriptorsByClass(VcsRepositoryViewerModuleDescriptor.class).stream(), this.getLegacyRepositoryModuleDescriptors());
    }

    @NotNull
    public Stream<VcsRepositoryViewerModuleDescriptor> getAvailableViewersForRepositoryType(String pluginKey) {
        return this.getAvailableRepositoryViewers().filter(v -> v.supportsVcsRepositoryType(pluginKey));
    }

    @Nullable
    public VcsRepositoryViewerModuleDescriptor getVcsRepositoryViewerModuleDescriptor(@NotNull String pluginKey) {
        VcsRepositoryViewerModuleDescriptor moduleDescriptor = (VcsRepositoryViewerModuleDescriptor)Narrow.to((Object)this.pluginAccessor.getEnabledPluginModule(pluginKey), VcsRepositoryViewerModuleDescriptor.class);
        if (moduleDescriptor != null) {
            return moduleDescriptor;
        }
        WebRepositoryViewerModuleDescriptor viewerModuleDescriptor = (WebRepositoryViewerModuleDescriptor)this.pluginAccessor.getEnabledPluginModule(pluginKey);
        if (viewerModuleDescriptor != null && CommitUrlProvider.class.isAssignableFrom(viewerModuleDescriptor.getModuleClass())) {
            return new LegacyVcsRepositoryViewerModuleDescriptor(viewerModuleDescriptor);
        }
        return null;
    }

    private Stream<? extends VcsRepositoryViewerModuleDescriptor> getLegacyRepositoryModuleDescriptors() {
        return this.webRepositoryViewerManager.getWebRepositoryViewerModuleDescriptors().stream().filter(md -> !SystemProperty.HIDE_PORTED_LEGACY_REPOSITORIES.getTypedValue() || this.findConverterFor(md.getCompleteKey()) == null).filter(md -> !md.getCompleteKey().equals("bamboo.webrepositoryviewer.provided:noRepositoryViewer")).filter(md -> CommitUrlProvider.class.isAssignableFrom(md.getModuleClass())).map(LegacyVcsRepositoryViewerModuleDescriptor::new);
    }

    @Nullable
    public VcsRepositoryViewer getViewerForRepository(@NotNull VcsRepositoryData vcsRepositoryData) {
        VcsRepositoryViewerModuleDescriptor md;
        if (vcsRepositoryData.getViewerConfiguration() != null && (md = this.getVcsRepositoryViewerModuleDescriptor(vcsRepositoryData.getViewerConfiguration().getPluginKey())) != null) {
            return (VcsRepositoryViewer)md.getModule();
        }
        return null;
    }

    @Nullable
    public Web2VcsRepositoryViewerConverter findConverterFor(@NotNull String pluginKey) {
        return this.pluginAccessor.getEnabledModulesByClass(Web2VcsRepositoryViewerConverter.class).stream().filter(c -> pluginKey.equals(c.acceptedWebRepositoryViewerPluginKey())).findFirst().orElse(null);
    }
}

