/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.vcs.viewer.module;

import com.atlassian.bamboo.plugin.BambooPluginUtils;
import com.atlassian.bamboo.plugin.descriptor.AbstractBambooModuleDescriptor;
import com.atlassian.bamboo.vcs.viewer.configurator.VcsRepositoryViewerConfigurator;
import com.atlassian.bamboo.vcs.viewer.module.VcsRepositoryViewerEmptyConfigurator;
import com.atlassian.bamboo.vcs.viewer.module.VcsRepositoryViewerExporter;
import com.atlassian.bamboo.vcs.viewer.module.VcsRepositoryViewerModuleDescriptor;
import com.atlassian.bamboo.vcs.viewer.runtime.VcsRepositoryViewer;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.module.ModuleFactory;
import io.atlassian.util.concurrent.LazyReference;
import io.atlassian.util.concurrent.ResettableLazyReference;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.dom4j.Element;
import org.jetbrains.annotations.NotNull;

public class VcsRepositoryViewerModuleDescriptorImpl
extends AbstractBambooModuleDescriptor<VcsRepositoryViewer>
implements VcsRepositoryViewerModuleDescriptor {
    private static final Logger log = Logger.getLogger(VcsRepositoryViewerModuleDescriptorImpl.class);
    private static final String EXPORTER = "exporter";
    private static final String CONFIGURATOR = "configurator";
    private static final String CLASS = "class";
    private static final String SUPPORTED_VCS = "supportedVcs";
    private static final String VCS_TYPE = "vcsType";
    private String configuratorClassName;
    private Collection<String> supportedVcsPluginKeys;
    private String exporterClassName;
    private ResettableLazyReference<VcsRepositoryViewerConfigurator> configurator = new ResettableLazyReference<VcsRepositoryViewerConfigurator>(){

        protected VcsRepositoryViewerConfigurator create() throws Exception {
            if (StringUtils.isNotBlank((CharSequence)VcsRepositoryViewerModuleDescriptorImpl.this.configuratorClassName)) {
                Class configClass = VcsRepositoryViewerModuleDescriptorImpl.this.plugin.loadClass(VcsRepositoryViewerModuleDescriptorImpl.this.configuratorClassName, ((Object)((Object)this)).getClass());
                return (VcsRepositoryViewerConfigurator)VcsRepositoryViewerModuleDescriptorImpl.this.instantiateClass(configClass);
            }
            return new VcsRepositoryViewerEmptyConfigurator();
        }

        protected void onReset(LazyReference<VcsRepositoryViewerConfigurator> oldValue) {
            VcsRepositoryViewerModuleDescriptorImpl.this.exporter.reset();
        }
    };
    private final ResettableLazyReference<VcsRepositoryViewerExporter> exporter = new ResettableLazyReference<VcsRepositoryViewerExporter>(){

        protected VcsRepositoryViewerExporter create() throws Exception {
            if (StringUtils.isNotBlank((CharSequence)VcsRepositoryViewerModuleDescriptorImpl.this.exporterClassName)) {
                Class configClass = VcsRepositoryViewerModuleDescriptorImpl.this.plugin.loadClass(VcsRepositoryViewerModuleDescriptorImpl.this.exporterClassName, ((Object)((Object)this)).getClass());
                return (VcsRepositoryViewerExporter)VcsRepositoryViewerModuleDescriptorImpl.this.instantiateClass(configClass);
            }
            return null;
        }
    };

    public VcsRepositoryViewerModuleDescriptorImpl(ModuleFactory moduleFactory) {
        super(moduleFactory);
    }

    public void init(Plugin plugin, Element element) throws PluginParseException {
        super.init(plugin, element);
        this.configuratorClassName = this.prepareConfiguratorSubModule(element);
        this.exporterClassName = BambooPluginUtils.prepareSubModuleConfiguration(element, this.exporter, EXPORTER, this.getKey(), "VCS Repository Viewer", plugin.getKey());
        Element supportedVcs = element.element(SUPPORTED_VCS);
        if (supportedVcs != null) {
            List typeElements = supportedVcs.elements(VCS_TYPE);
            this.supportedVcsPluginKeys = typeElements.stream().map(this::getElementAsString).map(String::trim).collect(Collectors.toSet());
        }
    }

    @NotNull
    public VcsRepositoryViewerConfigurator getConfigurator() {
        return (VcsRepositoryViewerConfigurator)this.configurator.get();
    }

    public boolean supportsVcsRepositoryType(@NotNull String pluginKey) {
        return CollectionUtils.isEmpty(this.supportedVcsPluginKeys) || this.supportedVcsPluginKeys.contains(pluginKey);
    }

    private String prepareConfiguratorSubModule(Element element) {
        if (element.element(CONFIGURATOR) != null) {
            Element configuration = element.element(CONFIGURATOR);
            String clazz = configuration.attributeValue(CLASS);
            if (StringUtils.isBlank((CharSequence)clazz)) {
                log.warn((Object)("Vcs type module (" + this.getKey() + ") of plugin " + this.plugin.getKey() + " contains an incorrectly configured '" + CONFIGURATOR + "' element. Please use the 'class' attribute to define your '" + CONFIGURATOR + "' class"));
            }
            this.configurator.reset();
            return clazz;
        }
        return null;
    }

    @NotNull
    public VcsRepositoryViewerExporter getExporter() {
        return (VcsRepositoryViewerExporter)this.exporter.get();
    }
}

